/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.ElementState;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfLoad;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BusDcState
extends ElementState<LfBus> {
    private final Map<String, Double> generatorsTargetP;
    private final Map<String, Double> generatorsInitialTargetP;
    private final Map<String, Boolean> participatingGenerators;
    private final Map<String, Boolean> disablingStatusGenerators;
    private final List<LoadDcState> loadStates;

    public BusDcState(LfBus bus) {
        super(bus);
        this.generatorsTargetP = bus.getGenerators().stream().collect(Collectors.toMap(LfGenerator::getId, LfGenerator::getTargetP));
        this.generatorsInitialTargetP = bus.getGenerators().stream().collect(Collectors.toMap(LfGenerator::getId, LfGenerator::getInitialTargetP));
        this.participatingGenerators = bus.getGenerators().stream().collect(Collectors.toMap(LfGenerator::getId, LfGenerator::isParticipating));
        this.disablingStatusGenerators = bus.getGenerators().stream().collect(Collectors.toMap(LfGenerator::getId, LfGenerator::isDisabled));
        this.loadStates = bus.getLoads().stream().map(load -> this.createLoadState().save((LfLoad)load)).toList();
    }

    protected LoadDcState createLoadState() {
        return new LoadDcState();
    }

    @Override
    public void restore() {
        super.restore();
        ((LfBus)this.element).getGenerators().forEach(g -> g.setTargetP(this.generatorsTargetP.get(g.getId())));
        ((LfBus)this.element).getGenerators().forEach(g -> g.setInitialTargetP(this.generatorsInitialTargetP.get(g.getId())));
        ((LfBus)this.element).getGenerators().forEach(g -> g.setParticipating(this.participatingGenerators.get(g.getId())));
        ((LfBus)this.element).getGenerators().forEach(g -> g.setDisabled(this.disablingStatusGenerators.get(g.getId())));
        for (int i = 0; i < this.loadStates.size(); ++i) {
            LfLoad load = ((LfBus)this.element).getLoads().get(i);
            this.loadStates.get(i).restore(load);
        }
    }

    public static BusDcState save(LfBus bus) {
        return new BusDcState(bus);
    }

    protected static class LoadDcState {
        private double loadTargetP;
        private double absVariableLoadTargetP;
        private Map<String, Boolean> loadsDisablingStatus;

        protected LoadDcState() {
        }

        protected LoadDcState save(LfLoad load) {
            this.loadTargetP = load.getTargetP();
            this.absVariableLoadTargetP = load.getAbsVariableTargetP();
            this.loadsDisablingStatus = new HashMap<String, Boolean>(load.getOriginalLoadsDisablingStatus());
            return this;
        }

        protected void restore(LfLoad load) {
            load.setTargetP(this.loadTargetP);
            load.setAbsVariableTargetP(this.absVariableLoadTargetP);
            load.setOriginalLoadsDisablingStatus(this.loadsDisablingStatus);
        }
    }
}

