/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import java.util.List;

public class Control {
    protected double targetValue;

    protected Control(double targetValue) {
        this.targetValue = targetValue;
    }

    public double getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(double targetValue) {
        this.targetValue = targetValue;
    }

    private static double[] createUniformReactiveKeys(List<LfBus> controllerBuses, LfGenerator.GeneratorControlType generatorControlType) {
        double[] qKeys = new double[controllerBuses.size()];
        for (int i = 0; i < controllerBuses.size(); ++i) {
            LfBus controllerBus = controllerBuses.get(i);
            qKeys[i] = controllerBus.getGenerators().stream().filter(gen -> gen.getGeneratorControlType() == generatorControlType).count();
        }
        return qKeys;
    }

    private static double[] createReactiveKeysFromMaxReactivePowerRange(List<LfBus> controllerBuses, LfGenerator.GeneratorControlType generatorControlType) {
        double[] qKeys = new double[controllerBuses.size()];
        for (int i = 0; i < controllerBuses.size(); ++i) {
            LfBus controllerBus = controllerBuses.get(i);
            for (LfGenerator generator : controllerBus.getGenerators()) {
                double maxRangeQ = generator.getRangeQ(LfGenerator.ReactiveRangeMode.MAX);
                if (maxRangeQ < 0.01 || maxRangeQ > 100.0) {
                    return Control.createUniformReactiveKeys(controllerBuses, generatorControlType);
                }
                int n = i;
                qKeys[n] = qKeys[n] + maxRangeQ;
            }
        }
        return qKeys;
    }

    static double[] createReactiveKeys(List<LfBus> controllerBuses, LfGenerator.GeneratorControlType generatorControlType) {
        double[] qKeys = new double[controllerBuses.size()];
        for (int i = 0; i < controllerBuses.size(); ++i) {
            LfBus controllerBus = controllerBuses.get(i);
            for (LfGenerator generator : controllerBus.getGenerators()) {
                double qKey = generator.getRemoteControlReactiveKey().orElse(Double.NaN);
                if (Double.isNaN(qKey)) {
                    return Control.createReactiveKeysFromMaxReactivePowerRange(controllerBuses, generatorControlType);
                }
                int n = i;
                qKeys[n] = qKeys[n] + qKey;
            }
        }
        return qKeys;
    }
}

