/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.GeneratorVoltageControl;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.PiModel;
import java.util.Locale;
import java.util.Objects;
import org.anarres.graphviz.builder.GraphVizAttribute;
import org.anarres.graphviz.builder.GraphVizEdge;
import org.anarres.graphviz.builder.GraphVizGraph;
import org.anarres.graphviz.builder.GraphVizNode;
import org.anarres.graphviz.builder.GraphVizScope;

public class GraphVizGraphBuilder {
    private final LfNetwork network;

    public GraphVizGraphBuilder(LfNetwork network) {
        this.network = Objects.requireNonNull(network);
    }

    private static String getNodeLabel(LfBus bus) {
        StringBuilder builder = new StringBuilder(Integer.toString(bus.getNum())).append("\n").append(bus.getId());
        if (bus.getGenerationTargetP() != 0.0 || bus.getGenerationTargetQ() != 0.0) {
            builder.append("\ngen=").append(String.format(Locale.US, "%.1f", bus.getGenerationTargetP() * 100.0)).append(" MW ").append(String.format(Locale.US, "%.1f", bus.getGenerationTargetQ() * 100.0)).append(" MVar");
        }
        if (bus.getLoadTargetP() != 0.0 || bus.getLoadTargetQ() != 0.0) {
            builder.append("\nload=").append(String.format(Locale.US, "%.1f", bus.getLoadTargetP() * 100.0)).append(" MW ").append(String.format(Locale.US, "%.1f", bus.getLoadTargetQ() * 100.0)).append(" MVar");
        }
        return builder.toString();
    }

    private static String getEdgeLabel(LfBranch branch) {
        StringBuilder builder = new StringBuilder(branch.getId());
        PiModel piModel = branch.getPiModel();
        if (piModel.getR1() != 1.0) {
            builder.append("\nr1=").append(String.format(Locale.US, "%.3f", piModel.getR1()));
        }
        if (piModel.getA1() != 0.0) {
            builder.append("\na1=").append(String.format(Locale.US, "%.3f", piModel.getA1()));
        }
        return builder.toString();
    }

    private static String getEdgeColor(LfBranch branch, LoadFlowModel loadFlowModel) {
        if (branch.isZeroImpedance(loadFlowModel)) {
            return branch.isSpanningTreeEdge(loadFlowModel) ? "red" : "orange";
        }
        return "black";
    }

    public GraphVizGraph build(LoadFlowModel loadFlowModel) {
        GraphVizGraph graph = new GraphVizGraph().label((CharSequence)this.network.getId());
        GraphVizScope.Impl scope = new GraphVizScope.Impl();
        for (LfBus bus : this.network.getBuses()) {
            ((GraphVizNode)((GraphVizNode)((GraphVizNode)((GraphVizNode)graph.node((GraphVizScope)scope, (Object)bus.getNum()).label((CharSequence)GraphVizGraphBuilder.getNodeLabel(bus))).attr(GraphVizAttribute.shape, "box")).attr(GraphVizAttribute.style, "filled,rounded")).attr(GraphVizAttribute.fontsize, "10")).attr(GraphVizAttribute.fillcolor, "grey");
        }
        for (LfBus bus : this.network.getBuses()) {
            if (!bus.isGeneratorVoltageControlled()) continue;
            GeneratorVoltageControl vc = bus.getGeneratorVoltageControl().orElseThrow();
            for (LfBus controllerBus : vc.getControllerElements()) {
                GraphVizEdge edge = graph.edge((GraphVizScope)scope, (Object)controllerBus.getNum(), (Object)bus.getNum(), (Object)controllerBus);
                ((GraphVizEdge)edge.attr(GraphVizAttribute.color, "lightgray")).attr(GraphVizAttribute.style, "dotted");
            }
        }
        for (LfBranch branch : this.network.getBranches()) {
            LfBus bus1 = branch.getBus1();
            LfBus bus2 = branch.getBus2();
            if (bus1 == null || bus2 == null) continue;
            GraphVizEdge edge = graph.edge((GraphVizScope)scope, (Object)bus1.getNum(), (Object)bus2.getNum(), (Object)branch.getNum());
            edge.label().append((CharSequence)GraphVizGraphBuilder.getEdgeLabel(branch));
            ((GraphVizEdge)((GraphVizEdge)edge.attr(GraphVizAttribute.color, GraphVizGraphBuilder.getEdgeColor(branch, loadFlowModel))).attr(GraphVizAttribute.style, branch.isDisabled() ? "dashed" : "")).attr(GraphVizAttribute.dir, "none");
        }
        return graph;
    }
}

