/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Country;
import com.powsybl.openloadflow.network.AbstractSlackBusSelector;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.SelectedSlackBus;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class LargestGeneratorSlackBusSelector
extends AbstractSlackBusSelector {
    private final double plausibleActivePowerLimit;

    public LargestGeneratorSlackBusSelector(double plausibleActivePowerLimit) {
        this(plausibleActivePowerLimit, Collections.emptySet());
    }

    public LargestGeneratorSlackBusSelector(double plausibleActivePowerLimit, Set<Country> countries) {
        super(countries);
        this.plausibleActivePowerLimit = plausibleActivePowerLimit;
    }

    private static double getMaxP(LfBus bus) {
        return bus.getGenerators().stream().mapToDouble(LfGenerator::getMaxTargetP).sum();
    }

    private boolean isGeneratorInvalid(LfGenerator generator) {
        return generator.isFictitious() || generator.getMaxP() > this.plausibleActivePowerLimit / 100.0;
    }

    @Override
    public SelectedSlackBus select(List<LfBus> buses, int limit) {
        List<LfBus> slackBuses = buses.stream().filter(bus -> !bus.isFictitious()).filter(this::filterByCountry).filter(bus -> !bus.getGenerators().isEmpty() && bus.getGenerators().stream().noneMatch(this::isGeneratorInvalid)).sorted(Comparator.comparingDouble(LargestGeneratorSlackBusSelector::getMaxP).reversed()).limit(limit).collect(Collectors.toList());
        return new SelectedSlackBus(slackBuses, "Largest generator bus");
    }
}

