/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.LfAsymLineAdmittanceMatrix;
import com.powsybl.openloadflow.network.SimplePiModel;
import java.util.Objects;

public class LfAsymLine {
    private final SimplePiModel piZeroComponent;
    private final SimplePiModel piPositiveComponent;
    private final SimplePiModel piNegativeComponent;
    private final boolean phaseOpenA;
    private final boolean phaseOpenB;
    private final boolean phaseOpenC;
    private final LfAsymLineAdmittanceMatrix admittanceMatrix;

    public LfAsymLine(SimplePiModel piZeroComponent, SimplePiModel piPositiveComponent, SimplePiModel piNegativeComponent, boolean phaseOpenA, boolean phaseOpenB, boolean phaseOpenC) {
        this.piZeroComponent = Objects.requireNonNull(piZeroComponent);
        this.piPositiveComponent = Objects.requireNonNull(piPositiveComponent);
        this.piNegativeComponent = Objects.requireNonNull(piNegativeComponent);
        this.phaseOpenA = phaseOpenA;
        this.phaseOpenB = phaseOpenB;
        this.phaseOpenC = phaseOpenC;
        this.admittanceMatrix = new LfAsymLineAdmittanceMatrix(this);
    }

    public LfAsymLineAdmittanceMatrix getAdmittanceMatrix() {
        return this.admittanceMatrix;
    }

    public SimplePiModel getPiZeroComponent() {
        return this.piZeroComponent;
    }

    public SimplePiModel getPiPositiveComponent() {
        return this.piPositiveComponent;
    }

    public SimplePiModel getPiNegativeComponent() {
        return this.piNegativeComponent;
    }

    public boolean isPhaseOpenA() {
        return this.phaseOpenA;
    }

    public boolean isPhaseOpenB() {
        return this.phaseOpenB;
    }

    public boolean isPhaseOpenC() {
        return this.phaseOpenC;
    }
}

