/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.TwoSides;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.openloadflow.network.LfAsymLine;
import com.powsybl.openloadflow.network.SimplePiModel;
import com.powsybl.openloadflow.util.Fortescue;

public class LfAsymLineAdmittanceMatrix {
    public static final double EPS_VALUE = 1.0E-8;
    private final DenseMatrix mYzpn;

    public LfAsymLineAdmittanceMatrix(LfAsymLine asymLine) {
        this.mYzpn = LfAsymLineAdmittanceMatrix.update(LfAsymLineAdmittanceMatrix.build(asymLine.getPiZeroComponent(), asymLine.getPiPositiveComponent(), asymLine.getPiNegativeComponent()), asymLine.isPhaseOpenA(), asymLine.isPhaseOpenB(), asymLine.isPhaseOpenC());
    }

    private static DenseMatrix build(SimplePiModel piZeroComponent, SimplePiModel piPositiveComponent, SimplePiModel piNegativeComponent) {
        DenseMatrix mY = new DenseMatrix(12, 12);
        double rz = piZeroComponent.getR();
        double xz = piZeroComponent.getX();
        double g1z = piZeroComponent.getG1();
        double g2z = piZeroComponent.getG2();
        double b1z = piZeroComponent.getB1();
        double b2z = piZeroComponent.getB2();
        double g12z = rz / (rz * rz + xz * xz);
        double b12z = -xz / (rz * rz + xz * xz);
        double g21z = g12z;
        double b21z = b12z;
        double rp = piPositiveComponent.getR();
        double xp = piPositiveComponent.getX();
        double g1p = piPositiveComponent.getG1();
        double g2p = piPositiveComponent.getG2();
        double b1p = piPositiveComponent.getB1();
        double b2p = piPositiveComponent.getB2();
        double g12p = rp / (rp * rp + xp * xp);
        double b12p = -xp / (rp * rp + xp * xp);
        double g21p = g12p;
        double b21p = b12p;
        double rn = piNegativeComponent.getR();
        double xn = piNegativeComponent.getX();
        double g1n = piNegativeComponent.getG1();
        double g2n = piNegativeComponent.getG2();
        double b1n = piNegativeComponent.getB1();
        double b2n = piNegativeComponent.getB2();
        double g12n = rn / (rn * rn + xn * xn);
        double b12n = -xn / (rn * rn + xn * xn);
        double g21n = g12n;
        double b21n = b12n;
        LfAsymLineAdmittanceMatrix.add22Bloc(g12z + g1z, b12z + b1z, 1, 1, mY);
        LfAsymLineAdmittanceMatrix.add22Bloc(-g12z, -b12z, 1, 4, mY);
        LfAsymLineAdmittanceMatrix.add22Bloc(g12p + g1p, b12p + b1p, 2, 2, mY);
        LfAsymLineAdmittanceMatrix.add22Bloc(-g12p, -b12p, 2, 5, mY);
        LfAsymLineAdmittanceMatrix.add22Bloc(g12n + g1n, b12n + b1n, 3, 3, mY);
        LfAsymLineAdmittanceMatrix.add22Bloc(-g12n, -b12n, 3, 6, mY);
        LfAsymLineAdmittanceMatrix.add22Bloc(g21z + g2z, b21z + b2z, 4, 4, mY);
        LfAsymLineAdmittanceMatrix.add22Bloc(-g21z, -b21z, 4, 1, mY);
        LfAsymLineAdmittanceMatrix.add22Bloc(g21p + g2p, b21p + b2p, 5, 5, mY);
        LfAsymLineAdmittanceMatrix.add22Bloc(-g21p, -b21p, 5, 2, mY);
        LfAsymLineAdmittanceMatrix.add22Bloc(g21n + g2n, b21n + b2n, 6, 6, mY);
        LfAsymLineAdmittanceMatrix.add22Bloc(-g21n, -b21n, 6, 3, mY);
        return mY;
    }

    private static DenseMatrix update(DenseMatrix mYzpn, boolean phaseOpenA, boolean phaseOpenB, boolean phaseOpenC) {
        if (phaseOpenA || phaseOpenB || phaseOpenC) {
            DenseMatrix mYabc = LfAsymLineAdmittanceMatrix.productMatrixM1M2M3(LfAsymLineAdmittanceMatrix.buildTwoBlocsMatrix(Fortescue.createMatrix()), mYzpn, LfAsymLineAdmittanceMatrix.buildTwoBlocsMatrix(Fortescue.createInverseMatrix()));
            if (phaseOpenA) {
                LfAsymLineAdmittanceMatrix.cancelComponentMatrix(mYabc, 1);
            }
            if (phaseOpenB) {
                LfAsymLineAdmittanceMatrix.cancelComponentMatrix(mYabc, 2);
            }
            if (phaseOpenC) {
                LfAsymLineAdmittanceMatrix.cancelComponentMatrix(mYabc, 3);
            }
            return LfAsymLineAdmittanceMatrix.productMatrixM1M2M3(LfAsymLineAdmittanceMatrix.buildTwoBlocsMatrix(Fortescue.createInverseMatrix()), mYabc, LfAsymLineAdmittanceMatrix.buildTwoBlocsMatrix(Fortescue.createMatrix()));
        }
        return mYzpn;
    }

    private static DenseMatrix buildTwoBlocsMatrix(DenseMatrix m66) {
        DenseMatrix mFbloc = new DenseMatrix(12, 12);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                mFbloc.add(i, j, m66.get(i, j));
                mFbloc.add(i + 6, j + 6, m66.get(i, j));
            }
        }
        return mFbloc;
    }

    private static void cancelComponentMatrix(DenseMatrix m, int component) {
        m.resetRow(2 * component - 2);
        m.resetRow(2 * component - 1);
        m.resetRow(2 * component + 4);
        m.resetRow(2 * component + 5);
        m.resetColumn(2 * component - 2);
        m.resetColumn(2 * component - 1);
        m.resetColumn(2 * component + 4);
        m.resetColumn(2 * component + 5);
    }

    private static void add22Bloc(double mx, double my, int i, int j, DenseMatrix m) {
        m.add(2 * (i - 1), 2 * (j - 1), mx);
        m.add(2 * (i - 1), 2 * (j - 1) + 1, -my);
        m.add(2 * (i - 1) + 1, 2 * (j - 1), my);
        m.add(2 * (i - 1) + 1, 2 * (j - 1) + 1, mx);
    }

    private static DenseMatrix productMatrixM1M2M3(DenseMatrix m1, DenseMatrix m2, DenseMatrix m3) {
        DenseMatrix m2M3 = m2.times(m3);
        DenseMatrix mResult = m1.times(m2M3);
        mResult.removeSmallValues(1.0E-8);
        return mResult;
    }

    public boolean isCoupled() {
        boolean coupled = false;
        block0: for (int i = 1; i <= 6; ++i) {
            for (int j = 1; j <= 6; ++j) {
                if (i == j || !LfAsymLineAdmittanceMatrix.isResidualExistsBloc(this.mYzpn, i, j)) continue;
                coupled = true;
                continue block0;
            }
        }
        return coupled;
    }

    private static boolean isResidualExistsBloc(DenseMatrix m, int i, int j) {
        double residual = Math.abs(m.get(2 * i - 2, 2 * j - 2)) + Math.abs(m.get(2 * i - 1, 2 * j - 2));
        return residual > 1.0E-8;
    }

    public double getX(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h) {
        return this.mYzpn.get(2 * (3 * (i.getNum() - 1) + g.getNum()), 2 * (3 * (j.getNum() - 1) + h.getNum()));
    }

    public double getY(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h) {
        return this.mYzpn.get(2 * (3 * (i.getNum() - 1) + g.getNum()) + 1, 2 * (3 * (j.getNum() - 1) + h.getNum()));
    }
}

