/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.network.LfAsymGenerator;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.LfReferencePriorityInjection;
import com.powsybl.openloadflow.network.PropertyBag;
import com.powsybl.openloadflow.network.impl.LfNetworkLoadingReport;
import java.util.OptionalDouble;

public interface LfGenerator
extends PropertyBag,
LfReferencePriorityInjection {
    public static double kToQ(double k, LfGenerator generator) {
        double minQ = generator.getMinQ();
        double maxQ = generator.getMaxQ();
        return 0.5 * (k * (maxQ - minQ) + maxQ + minQ);
    }

    public static double qToK(LfGenerator generator, double q) {
        double minQ = generator.getMinQ();
        double maxQ = generator.getMaxQ();
        return (2.0 * q - maxQ - minQ) / (maxQ - minQ);
    }

    public String getId();

    public String getOriginalId();

    public LfBus getBus();

    public void setBus(LfBus var1);

    public boolean isFictitious();

    public boolean hasRemoteReactivePowerControl();

    public GeneratorControlType getGeneratorControlType();

    public void setGeneratorControlType(GeneratorControlType var1);

    public double getTargetV();

    public OptionalDouble getRemoteControlReactiveKey();

    public double getTargetQ();

    public double getInitialTargetP();

    public void setInitialTargetP(double var1);

    public void setInitialTargetPToTargetP();

    public double getTargetP();

    public void setTargetP(double var1);

    default public double getMinTargetP() {
        return this.getMinP();
    }

    default public double getMaxTargetP() {
        return this.getMaxP();
    }

    public double getMinP();

    public double getMaxP();

    public double getMinQ();

    public double getMaxQ();

    public double getRangeQ(ReactiveRangeMode var1);

    default public boolean isParticipating() {
        return false;
    }

    public void setParticipating(boolean var1);

    default public double getDroop() {
        return 0.0;
    }

    default public double getParticipationFactor() {
        return 0.0;
    }

    public double getCalculatedQ();

    public void setCalculatedQ(double var1);

    public void updateState(LfNetworkStateUpdateParameters var1);

    public LfBus getControlledBus();

    default public double getSlope() {
        return 0.0;
    }

    default public void setSlope(double slope) {
    }

    public LfBranch getControlledBranch();

    public TwoSides getControlledBranchSide();

    public double getRemoteTargetQ();

    default public boolean isDisabled() {
        return false;
    }

    public void setDisabled(boolean var1);

    public LfAsymGenerator getAsym();

    public void setAsym(LfAsymGenerator var1);

    public void reApplyActivePowerControlChecks(LfNetworkParameters var1, LfNetworkLoadingReport var2);

    public static enum ReactiveRangeMode {
        MIN,
        MAX,
        TARGET_P;

    }

    public static enum GeneratorControlType {
        OFF,
        REMOTE_REACTIVE_POWER,
        VOLTAGE,
        MONITORING_VOLTAGE;

    }
}

