/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.network.GeneratorVoltageControl;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfLoad;
import com.powsybl.openloadflow.network.LfNetworkListener;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.LfZeroImpedanceNetwork;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.TransformerVoltageControl;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LfNetworkListenerTracer
implements LfNetworkListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LfNetworkListenerTracer.class);
    private final LfNetworkListener delegate;

    protected LfNetworkListenerTracer(LfNetworkListener delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public static LfNetworkListener trace(LfNetworkListener listener) {
        Objects.requireNonNull(listener);
        if (LOGGER.isTraceEnabled()) {
            return new LfNetworkListenerTracer(listener);
        }
        return listener;
    }

    @Override
    public void onGeneratorVoltageControlChange(LfBus controllerBus, boolean newVoltageControllerEnabled) {
        LOGGER.trace("onGeneratorVoltageControlChange(controllerBusId='{}', newVoltageControllerEnabled={})", (Object)controllerBus.getId(), (Object)newVoltageControllerEnabled);
        this.delegate.onGeneratorVoltageControlChange(controllerBus, newVoltageControllerEnabled);
    }

    @Override
    public void onGeneratorVoltageControlTargetChange(GeneratorVoltageControl control, double newTargetVoltage) {
        LOGGER.trace("onGeneratorVoltageControlTargetChange(controlledBusId='{}', newTargetVoltage={})", (Object)control.getControlledBus(), (Object)newTargetVoltage);
        this.delegate.onGeneratorVoltageControlTargetChange(control, newTargetVoltage);
    }

    @Override
    public void onGeneratorReactivePowerControlChange(LfBus controllerBus, boolean newReactiveControllerEnabled) {
        LOGGER.trace("onGeneratorReactivePowerControlChange(controllerBusId='{}', newReactiveControllerEnabled={})", (Object)controllerBus.getId(), (Object)newReactiveControllerEnabled);
        this.delegate.onGeneratorReactivePowerControlChange(controllerBus, newReactiveControllerEnabled);
    }

    @Override
    public void onTransformerPhaseControlChange(LfBranch controllerBranch, boolean newPhaseControlEnabled) {
        LOGGER.trace("onTransformerPhaseControlChange(controllerBranchId='{}', newPhaseControlEnabled={})", (Object)controllerBranch.getId(), (Object)newPhaseControlEnabled);
        this.delegate.onTransformerPhaseControlChange(controllerBranch, newPhaseControlEnabled);
    }

    @Override
    public void onTransformerVoltageControlTargetChange(TransformerVoltageControl transformerVoltageControl, double newTargetVoltage) {
        LOGGER.trace("onTransformerVoltageControlTargetChange(controlledBusId='{}', newTargetVoltage={})", (Object)transformerVoltageControl.getControlledBus().getId(), (Object)newTargetVoltage);
        this.delegate.onTransformerVoltageControlTargetChange(transformerVoltageControl, newTargetVoltage);
    }

    @Override
    public void onTransformerVoltageControlChange(LfBranch controllerBranch, boolean newVoltageControllerEnabled) {
        LOGGER.trace("onTransformerVoltageControlChange(controllerBranchId='{}', newVoltageControllerEnabled={})", (Object)controllerBranch.getId(), (Object)newVoltageControllerEnabled);
        this.delegate.onTransformerVoltageControlChange(controllerBranch, newVoltageControllerEnabled);
    }

    @Override
    public void onShuntVoltageControlChange(LfShunt controllerShunt, boolean newVoltageControllerEnabled) {
        LOGGER.trace("onShuntVoltageControlChange(controllerShuntId={}, newVoltageControllerEnabled={})", (Object)controllerShunt.getId(), (Object)newVoltageControllerEnabled);
        this.delegate.onShuntVoltageControlChange(controllerShunt, newVoltageControllerEnabled);
    }

    @Override
    public void onLoadActivePowerTargetChange(LfLoad load, double oldTargetP, double newTargetP) {
        LOGGER.trace("onLoadActivePowerTargetChange(loadId='{}', oldTargetP={}, newTargetP={})", new Object[]{load.getId(), oldTargetP, newTargetP});
        this.delegate.onLoadActivePowerTargetChange(load, oldTargetP, newTargetP);
    }

    @Override
    public void onLoadReactivePowerTargetChange(LfLoad load, double oldTargetQ, double newTargetQ) {
        LOGGER.trace("onLoadReactivePowerTargetChange(busId='{}', oldTargetQ={}, newTargetQ={})", new Object[]{load.getId(), oldTargetQ, newTargetQ});
        this.delegate.onLoadReactivePowerTargetChange(load, oldTargetQ, newTargetQ);
    }

    @Override
    public void onGenerationActivePowerTargetChange(LfGenerator generator, double oldGenerationTargetP, double newGenerationTargetP) {
        LOGGER.trace("onGenerationActivePowerTargetChange(generatorId='{}', oldGenerationTargetP={}, newGenerationTargetP={})", new Object[]{generator.getId(), oldGenerationTargetP, newGenerationTargetP});
        this.delegate.onGenerationActivePowerTargetChange(generator, oldGenerationTargetP, newGenerationTargetP);
    }

    @Override
    public void onGenerationReactivePowerTargetChange(LfBus bus, double oldGenerationTargetQ, double newGenerationTargetQ) {
        LOGGER.trace("onGenerationReactivePowerTargetChange(busId='{}', oldGenerationTargetQ={}, newGenerationTargetQ={})", new Object[]{bus.getId(), oldGenerationTargetQ, newGenerationTargetQ});
        this.delegate.onGenerationReactivePowerTargetChange(bus, oldGenerationTargetQ, newGenerationTargetQ);
    }

    @Override
    public void onDisableChange(LfElement element, boolean disabled) {
        LOGGER.trace("onDisableChange(elementType={}, elementId='{}', disabled={})", new Object[]{element.getType(), element.getId(), disabled});
        this.delegate.onDisableChange(element, disabled);
    }

    @Override
    public void onTapPositionChange(LfBranch branch, int oldPosition, int newPosition) {
        LOGGER.trace("onTapPositionChange(branchId='{}', oldPosition={}, newPosition={})", new Object[]{branch.getId(), oldPosition, newPosition});
        this.delegate.onTapPositionChange(branch, oldPosition, newPosition);
    }

    @Override
    public void onShuntSusceptanceChange(LfShunt shunt, double b) {
        LOGGER.trace("onShuntSusceptanceChange(shuntId='{}', b={})", (Object)shunt.getId(), (Object)b);
        this.delegate.onShuntSusceptanceChange(shunt, b);
    }

    @Override
    public void onZeroImpedanceNetworkSpanningTreeChange(LfBranch branch, LoadFlowModel loadFlowModel, boolean spanningTree) {
        LOGGER.trace("onZeroImpedanceNetworkSpanningTreeChange(branchId='{}', loadFlowModel={}, spanningTree={})", new Object[]{branch, loadFlowModel, spanningTree});
        this.delegate.onZeroImpedanceNetworkSpanningTreeChange(branch, loadFlowModel, spanningTree);
    }

    @Override
    public void onZeroImpedanceNetworkSplit(LfZeroImpedanceNetwork initialNetwork, List<LfZeroImpedanceNetwork> splitNetworks, LoadFlowModel loadFlowModel) {
        LOGGER.trace("onZeroImpedanceNetworkSplit(initialNetwork={}, splitNetworks={}, loadFlowModel={})", new Object[]{initialNetwork, splitNetworks, loadFlowModel});
        this.delegate.onZeroImpedanceNetworkSplit(initialNetwork, splitNetworks, loadFlowModel);
    }

    @Override
    public void onZeroImpedanceNetworkMerge(LfZeroImpedanceNetwork network1, LfZeroImpedanceNetwork network2, LfZeroImpedanceNetwork mergedNetwork, LoadFlowModel loadFlowModel) {
        LOGGER.trace("onZeroImpedanceNetworkMerge(network1={}, network2={}, mergedNetwork={}, loadFlowModel={})", new Object[]{network1, network2, mergedNetwork, loadFlowModel});
        this.delegate.onZeroImpedanceNetworkMerge(network1, network2, mergedNetwork, loadFlowModel);
    }

    @Override
    public void onBranchConnectionStatusChange(LfBranch branch, TwoSides side, boolean connected) {
        LOGGER.trace("onBranchConnectionStatusChange(branch={}, side={}, connected={})", new Object[]{branch, side, connected});
        this.delegate.onBranchConnectionStatusChange(branch, side, connected);
    }

    @Override
    public void onSlackBusChange(LfBus bus, boolean slack) {
        LOGGER.trace("onSlackBusChange(bus={}, slack={})", (Object)bus, (Object)slack);
        this.delegate.onSlackBusChange(bus, slack);
    }

    @Override
    public void onReferenceBusChange(LfBus bus, boolean reference) {
        LOGGER.trace("onReferenceBusChange(bus={}, reference={})", (Object)bus, (Object)reference);
        this.delegate.onReferenceBusChange(bus, reference);
    }
}

