/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.GeneratorVoltageControl;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.VoltageControl;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LfSecondaryVoltageControl {
    private static final Logger LOGGER = LoggerFactory.getLogger(LfSecondaryVoltageControl.class);
    private final String zoneName;
    private final LfBus pilotBus;
    private final Set<String> participatingControlUnitIds;
    private final Set<GeneratorVoltageControl> generatorVoltageControls;
    private double targetValue;

    public LfSecondaryVoltageControl(String zoneName, LfBus pilotBus, double targetValue, Set<String> participatingControlUnitIds, Set<GeneratorVoltageControl> generatorVoltageControls) {
        this.zoneName = Objects.requireNonNull(zoneName);
        this.pilotBus = Objects.requireNonNull(pilotBus);
        this.targetValue = targetValue;
        this.participatingControlUnitIds = Objects.requireNonNull(participatingControlUnitIds);
        this.generatorVoltageControls = Objects.requireNonNull(generatorVoltageControls);
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public double getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(double targetValue) {
        if (this.targetValue != targetValue) {
            this.targetValue = targetValue;
            this.tryToReEnableHelpfulControllerBuses();
        }
    }

    public LfBus getPilotBus() {
        return this.pilotBus;
    }

    public void addParticipatingControlUnit(String id) {
        if (this.participatingControlUnitIds.add(id)) {
            this.tryToReEnableHelpfulControllerBuses();
        }
    }

    public void removeParticipatingControlUnit(String id) {
        if (this.participatingControlUnitIds.remove(id)) {
            this.tryToReEnableHelpfulControllerBuses();
        }
    }

    public Set<GeneratorVoltageControl> getGeneratorVoltageControls() {
        return this.generatorVoltageControls.stream().filter(this::hasAtLeastOneParticipatingControlUnit).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private boolean hasAtLeastOneParticipatingControlUnit(GeneratorVoltageControl vc) {
        for (LfBus controllerElement : vc.getMergedControllerElements()) {
            for (LfGenerator generator : controllerElement.getGenerators()) {
                if (!this.participatingControlUnitIds.contains(generator.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private static List<LfBus> findControllerBuses(LfBus controlledBus) {
        return controlledBus.getGeneratorVoltageControl().orElseThrow().getMergedControllerElements().stream().filter(controllerBus -> !controllerBus.isDisabled()).toList();
    }

    public List<LfBus> getControlledBuses() {
        return this.getGeneratorVoltageControls().stream().filter(voltageControl -> voltageControl.isVisible() && voltageControl.getMergeStatus() == VoltageControl.MergeStatus.MAIN).map(VoltageControl::getControlledBus).toList();
    }

    private static Optional<LfBus> findAnyControllerBusWithVoltageControlEnabled(LfBus controlledBus) {
        return LfSecondaryVoltageControl.findControllerBuses(controlledBus).stream().filter(LfBus::isGeneratorVoltageControlEnabled).findAny();
    }

    public Optional<LfBus> findAnyControlledBusWithAtLeastOneControllerBusWithVoltageControlEnabled() {
        return this.getControlledBuses().stream().flatMap(controlledBus -> LfSecondaryVoltageControl.findAnyControllerBusWithVoltageControlEnabled(controlledBus).stream()).findAny();
    }

    public List<LfBus> getControllerBuses() {
        return this.getControlledBuses().stream().flatMap(controlledBus -> LfSecondaryVoltageControl.findControllerBuses(controlledBus).stream()).toList();
    }

    public List<LfBus> getEnabledControllerBuses() {
        return this.getControllerBuses().stream().filter(LfBus::isGeneratorVoltageControlEnabled).toList();
    }

    public void tryToReEnableHelpfulControllerBuses() {
        ArrayList<LfBus> controllerBusesToMinQ = new ArrayList<LfBus>();
        ArrayList<LfBus> controllerBusesToMaxQ = new ArrayList<LfBus>();
        ArrayList<LfBus> allControllerBuses = new ArrayList<LfBus>();
        this.classifyControllerBuses(allControllerBuses, controllerBusesToMinQ, controllerBusesToMaxQ);
        ArrayList<LfBus> controllerBusesToLimit = new ArrayList<LfBus>(controllerBusesToMinQ.size() + controllerBusesToMaxQ.size());
        controllerBusesToLimit.addAll(controllerBusesToMinQ);
        controllerBusesToLimit.addAll(controllerBusesToMaxQ);
        if (!controllerBusesToLimit.isEmpty() && controllerBusesToLimit.size() < allControllerBuses.size()) {
            for (LfBus controllerBus : controllerBusesToLimit) {
                controllerBus.setGeneratorVoltageControlEnabled(true);
                controllerBus.setQLimitType(null);
            }
            LOGGER.debug("Secondary voltage control of zone '{}': controller buses {} have been re-enabled because might help to reach pilot bus target", (Object)this.getZoneName(), controllerBusesToLimit);
        }
    }

    private void classifyControllerBuses(List<LfBus> allControllerBuses, List<LfBus> controllerBusesToMinQ, List<LfBus> controllerBusesToMaxQ) {
        this.getControllerBuses().forEach(controllerBus -> {
            allControllerBuses.add((LfBus)controllerBus);
            controllerBus.getQLimitType().ifPresent(qLimitType -> {
                if (qLimitType == LfBus.QLimitType.MIN_Q) {
                    controllerBusesToMinQ.add((LfBus)controllerBus);
                } else {
                    controllerBusesToMaxQ.add((LfBus)controllerBus);
                }
            });
        });
    }
}

