/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.Control;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkListener;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.VoltageControl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.alg.interfaces.SpanningTreeAlgorithm;
import org.jgrapht.alg.spanning.KruskalMinimumSpanningTree;
import org.jgrapht.graph.AsSubgraph;
import org.jgrapht.graph.Pseudograph;

public class LfZeroImpedanceNetwork {
    private final LfNetwork network;
    private final LoadFlowModel loadFlowModel;
    private final Graph<LfBus, LfBranch> graph;
    private SpanningTreeAlgorithm.SpanningTree<LfBranch> spanningTree;

    public LfZeroImpedanceNetwork(LfNetwork network, LoadFlowModel loadFlowModel, Graph<LfBus, LfBranch> graph) {
        this.network = Objects.requireNonNull(network);
        this.loadFlowModel = Objects.requireNonNull(loadFlowModel);
        this.graph = Objects.requireNonNull(graph);
        for (LfBus bus : graph.vertexSet()) {
            bus.setZeroImpedanceNetwork(loadFlowModel, this);
        }
        this.updateSpanningTree();
        if (loadFlowModel == LoadFlowModel.AC) {
            this.updateVoltageControlMergeStatus();
            this.disableInvalidGeneratorVoltageControls();
        }
    }

    private static Graph<LfBus, LfBranch> createSubgraph(Graph<LfBus, LfBranch> graph, Set<LfBus> vertexSubset) {
        Pseudograph subGraph = new Pseudograph(LfBranch.class);
        Graphs.addGraph((Graph)subGraph, (Graph)new AsSubgraph(graph, vertexSubset));
        return subGraph;
    }

    public static Set<LfZeroImpedanceNetwork> create(LfNetwork network, LoadFlowModel loadFlowModel) {
        Objects.requireNonNull(network);
        LinkedHashSet<LfZeroImpedanceNetwork> zeroImpedanceNetworks = new LinkedHashSet<LfZeroImpedanceNetwork>();
        Graph<LfBus, LfBranch> graph = LfZeroImpedanceNetwork.createZeroImpedanceSubGraph(network, loadFlowModel);
        List connectedSets = new ConnectivityInspector(graph).connectedSets();
        for (Set connectedSet : connectedSets) {
            Graph<LfBus, LfBranch> subGraph = LfZeroImpedanceNetwork.createSubgraph(graph, connectedSet);
            zeroImpedanceNetworks.add(new LfZeroImpedanceNetwork(network, loadFlowModel, subGraph));
        }
        return zeroImpedanceNetworks;
    }

    private static Graph<LfBus, LfBranch> createZeroImpedanceSubGraph(LfNetwork network, LoadFlowModel loadFlowModel) {
        Pseudograph subGraph = new Pseudograph(LfBranch.class);
        for (LfBranch branch : network.getBranches()) {
            LfBus bus1 = branch.getBus1();
            LfBus bus2 = branch.getBus2();
            if (bus1 == null || bus2 == null || !branch.isZeroImpedance(loadFlowModel)) continue;
            if (!subGraph.containsVertex((Object)bus1)) {
                subGraph.addVertex((Object)bus1);
            }
            if (!subGraph.containsVertex((Object)bus2)) {
                subGraph.addVertex((Object)bus2);
            }
            if (branch.isDisabled()) continue;
            subGraph.addEdge((Object)bus1, (Object)bus2, (Object)branch);
        }
        return subGraph;
    }

    public LfNetwork getNetwork() {
        return this.network;
    }

    public LoadFlowModel getLoadFlowModel() {
        return this.loadFlowModel;
    }

    public Graph<LfBus, LfBranch> getGraph() {
        return this.graph;
    }

    public SpanningTreeAlgorithm.SpanningTree<LfBranch> getSpanningTree() {
        return this.spanningTree;
    }

    public void updateSpanningTree() {
        this.spanningTree = new KruskalMinimumSpanningTree(this.graph).getSpanningTree();
        Set spanningTreeEdges = this.spanningTree.getEdges();
        for (LfBranch branch : this.graph.edgeSet()) {
            branch.setSpanningTreeEdge(this.loadFlowModel, spanningTreeEdges.contains(branch));
        }
    }

    private static void linkVoltageControls(VoltageControl<?> mainVc, VoltageControl<?> vc) {
        mainVc.mergedDependentVoltageControls.add(vc);
        vc.mainMergedVoltageControl = mainVc;
    }

    private void updateVoltageControlMergeStatus() {
        EnumMap<VoltageControl.Type, List> voltageControlsByType = new EnumMap<VoltageControl.Type, List>(VoltageControl.Type.class);
        for (LfBus zb : this.graph.vertexSet()) {
            if (!zb.isVoltageControlled()) continue;
            for (VoltageControl<?> vc : zb.getVoltageControls()) {
                voltageControlsByType.computeIfAbsent(vc.getType(), k -> new ArrayList()).add(vc);
                vc.getMergedDependentVoltageControls().clear();
                vc.mainMergedVoltageControl = null;
                vc.disabled = false;
            }
        }
        for (List voltageControls : voltageControlsByType.values()) {
            if (voltageControls.size() > 1) {
                voltageControls.sort(Comparator.comparingDouble(Control::getTargetValue).reversed().thenComparing(o -> o.getControlledBus().getId()));
                VoltageControl mainVc = (VoltageControl)voltageControls.get(0);
                mainVc.mergeStatus = VoltageControl.MergeStatus.MAIN;
                for (int i = 1; i < voltageControls.size(); ++i) {
                    VoltageControl vc = (VoltageControl)voltageControls.get(i);
                    vc.mergeStatus = VoltageControl.MergeStatus.DEPENDENT;
                    LfZeroImpedanceNetwork.linkVoltageControls(mainVc, vc);
                }
                continue;
            }
            ((VoltageControl)voltageControls.get((int)0)).mergeStatus = VoltageControl.MergeStatus.MAIN;
        }
    }

    private void disableInvalidGeneratorVoltageControls() {
        ArrayList<LfBus> controlledBuses = new ArrayList<LfBus>(1);
        for (LfBus zb : this.graph.vertexSet()) {
            if (!zb.isGeneratorVoltageControlEnabled()) continue;
            controlledBuses.add(((VoltageControl)zb.getGeneratorVoltageControl().orElseThrow().getMainVoltageControl()).getControlledBus());
        }
        List<LfBus> uniqueControlledBusesSortedByMaxP = controlledBuses.stream().distinct().sorted(Comparator.comparingDouble(LfBus::getMaxP)).toList();
        if (uniqueControlledBusesSortedByMaxP.size() > 1) {
            for (int i = 1; i < uniqueControlledBusesSortedByMaxP.size(); ++i) {
                uniqueControlledBusesSortedByMaxP.get(i).getGeneratorVoltageControl().orElseThrow().setDisabled(true);
            }
        }
    }

    public void removeBranchAndTryToSplit(LfBranch disabledBranch) {
        this.graph.removeEdge((Object)disabledBranch);
        List connectedSets = new ConnectivityInspector(this.graph).connectedSets();
        if (connectedSets.size() > 1) {
            disabledBranch.setSpanningTreeEdge(this.loadFlowModel, false);
            Set<LfZeroImpedanceNetwork> zeroImpedanceNetworks = this.network.getZeroImpedanceNetworks(this.loadFlowModel);
            zeroImpedanceNetworks.remove(this);
            ArrayList<LfZeroImpedanceNetwork> splitZns = new ArrayList<LfZeroImpedanceNetwork>(2);
            for (Set connectedSet : connectedSets) {
                Graph<LfBus, LfBranch> subGraph = LfZeroImpedanceNetwork.createSubgraph(this.graph, connectedSet);
                splitZns.add(new LfZeroImpedanceNetwork(this.network, this.loadFlowModel, subGraph));
            }
            zeroImpedanceNetworks.addAll(splitZns);
            for (LfNetworkListener listener : this.network.getListeners()) {
                listener.onZeroImpedanceNetworkSplit(this, splitZns, this.loadFlowModel);
            }
        } else if (disabledBranch.isSpanningTreeEdge(this.loadFlowModel)) {
            disabledBranch.setSpanningTreeEdge(this.loadFlowModel, false);
            this.updateSpanningTree();
        }
    }

    public static void addBranchAndMerge(LfZeroImpedanceNetwork zn1, LfZeroImpedanceNetwork zn2, LfBranch enabledBranch) {
        Objects.requireNonNull(zn1);
        Objects.requireNonNull(zn2);
        Objects.requireNonNull(enabledBranch);
        LfNetwork network = zn1.getNetwork();
        LoadFlowModel loadFlowModel = zn1.getLoadFlowModel();
        Set<LfZeroImpedanceNetwork> zeroImpedanceNetworks = network.getZeroImpedanceNetworks(loadFlowModel);
        Pseudograph mergedGraph = new Pseudograph(LfBranch.class);
        Graphs.addGraph((Graph)mergedGraph, zn1.getGraph());
        Graphs.addGraph((Graph)mergedGraph, zn2.getGraph());
        mergedGraph.addEdge((Object)enabledBranch.getBus1(), (Object)enabledBranch.getBus2(), (Object)enabledBranch);
        zeroImpedanceNetworks.remove(zn1);
        zeroImpedanceNetworks.remove(zn2);
        LfZeroImpedanceNetwork mergedZn = new LfZeroImpedanceNetwork(network, loadFlowModel, (Graph<LfBus, LfBranch>)mergedGraph);
        zeroImpedanceNetworks.add(mergedZn);
        for (LfNetworkListener listener : network.getListeners()) {
            listener.onZeroImpedanceNetworkMerge(zn1, zn2, mergedZn, loadFlowModel);
        }
    }

    public void addBranch(LfBranch branch) {
        this.graph.addEdge((Object)branch.getBus1(), (Object)branch.getBus2(), (Object)branch);
    }

    public String toString() {
        return "LfZeroImpedanceNetwork(loadFlowModel=" + this.loadFlowModel + ", buses=" + this.graph.vertexSet() + ", branches=" + this.graph.edgeSet() + ")";
    }
}

