/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Country;
import com.powsybl.openloadflow.network.AbstractSlackBusSelector;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.MostMeshedSlackBusSelector;
import com.powsybl.openloadflow.network.SelectedSlackBus;
import com.powsybl.openloadflow.network.SlackBusSelector;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NameSlackBusSelector
extends AbstractSlackBusSelector {
    private static final String SELECTION_METHOD = "Parameter bus";
    private final List<String> busesOrVoltageLevelsIds;
    private final SlackBusSelector secondLevelSelector;

    public NameSlackBusSelector(List<String> busesOrVoltageLevelsIds, Set<Country> countries, SlackBusSelector secondLevelSelector) {
        super(countries);
        if (busesOrVoltageLevelsIds.isEmpty()) {
            throw new IllegalArgumentException("Empty bus or voltage level ID list");
        }
        this.busesOrVoltageLevelsIds = Objects.requireNonNull(busesOrVoltageLevelsIds);
        this.secondLevelSelector = Objects.requireNonNull(secondLevelSelector);
    }

    public NameSlackBusSelector(String ... busesOrVoltageLevelsIds) {
        this(List.of(busesOrVoltageLevelsIds), Collections.emptySet(), new MostMeshedSlackBusSelector());
    }

    @Override
    public SelectedSlackBus select(List<LfBus> buses, int limit) {
        Map busesById = buses.stream().collect(Collectors.toMap(LfElement::getId, Function.identity()));
        Map<String, List<LfBus>> busesByVoltageLevelId = buses.stream().collect(Collectors.groupingBy(LfBus::getVoltageLevelId));
        List<LfBus> slackBuses = this.busesOrVoltageLevelsIds.stream().flatMap(id -> {
            LfBus slackBus = (LfBus)busesById.get(id);
            if (slackBus != null) {
                return Stream.of(slackBus);
            }
            List slackBusCandidates = (List)busesByVoltageLevelId.get(id);
            if (slackBusCandidates != null) {
                return slackBusCandidates.stream();
            }
            return Stream.empty();
        }).filter(this::filterByCountry).collect(Collectors.toList());
        if (slackBuses.isEmpty()) {
            return this.secondLevelSelector.select(buses, limit);
        }
        if (slackBuses.size() <= limit) {
            return new SelectedSlackBus(slackBuses, SELECTION_METHOD);
        }
        SelectedSlackBus selectedSlackBus = this.secondLevelSelector.select(slackBuses, limit);
        return new SelectedSlackBus(selectedSlackBus.getBuses(), "Parameter bus + " + selectedSlackBus.getSelectionMethod());
    }
}

