/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.action.LoadAction;
import com.powsybl.iidm.network.Load;
import com.powsybl.openloadflow.network.impl.LfLoadImpl;
import java.util.Objects;

public class PowerShift {
    private double active;
    private double variableActive;
    private double reactive;

    public PowerShift() {
        this(0.0, 0.0, 0.0);
    }

    public PowerShift(double active, double variableActive, double reactive) {
        this.active = active;
        this.variableActive = variableActive;
        this.reactive = reactive;
    }

    public double getActive() {
        return this.active;
    }

    public double getVariableActive() {
        return this.variableActive;
    }

    public double getReactive() {
        return this.reactive;
    }

    public void add(PowerShift other) {
        Objects.requireNonNull(other);
        this.active += other.getActive();
        this.variableActive += other.getVariableActive();
        this.reactive += other.getReactive();
    }

    public String toString() {
        return "PowerShift(" + this.active + ", " + this.variableActive + ", " + this.reactive + ")";
    }

    public static PowerShift createPowerShift(Load load, boolean slackDistributionOnConformLoad) {
        double variableActivePower = Math.abs(LfLoadImpl.getAbsVariableTargetPPerUnit(load, slackDistributionOnConformLoad));
        return new PowerShift(load.getP0() / 100.0, variableActivePower, load.getQ0() / 100.0);
    }

    public static PowerShift createPowerShift(Load load, LoadAction loadAction) {
        double activePowerShift = loadAction.getActivePowerValue().stream().map(a -> loadAction.isRelativeValue() ? a : a - load.getP0()).findAny().orElse(0.0);
        double reactivePowerShift = loadAction.getReactivePowerValue().stream().map(r -> loadAction.isRelativeValue() ? r : r - load.getQ0()).findAny().orElse(0.0);
        double variableActivePower = LfLoadImpl.isLoadNotParticipating(load) ? 0.0 : activePowerShift;
        return new PowerShift(activePowerShift / 100.0, variableActivePower / 100.0, reactivePowerShift / 100.0);
    }
}

