/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfReferencePriorityInjection;
import com.powsybl.openloadflow.network.ReferenceBusFirstSlackSelector;
import com.powsybl.openloadflow.network.ReferenceBusSelector;
import com.powsybl.openloadflow.network.SelectedGeneratorReferenceBus;
import com.powsybl.openloadflow.network.SelectedReferenceBus;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceBusGeneratorPrioritySelector
implements ReferenceBusSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceBusGeneratorPrioritySelector.class);
    private static final String METHOD_NAME = "Generator Reference Priority";
    private static final ReferenceBusSelector FALLBACK_SELECTOR = new ReferenceBusFirstSlackSelector();

    @Override
    public SelectedReferenceBus select(LfNetwork lfNetwork) {
        Objects.requireNonNull(lfNetwork);
        List<LfGenerator> lfGenerators = lfNetwork.getBuses().stream().filter(bus -> !bus.isFictitious()).flatMap(bus -> bus.getGenerators().stream()).filter(g -> !g.isFictitious()).toList();
        List<LfGenerator> lfGeneratorsPrioritized = lfGenerators.stream().filter(g -> g.getReferencePriority() > 0).sorted(Comparator.comparingInt(LfReferencePriorityInjection::getReferencePriority)).toList();
        int priority = lfGeneratorsPrioritized.isEmpty() ? 0 : lfGeneratorsPrioritized.get(0).getReferencePriority();
        LOGGER.info("Network {}, will select reference generator among generators of priority {}", (Object)lfNetwork, (Object)priority);
        LfGenerator referenceGenerator = lfGenerators.stream().filter(g -> g.getReferencePriority() == priority).min(Comparator.comparingDouble(LfGenerator::getMaxTargetP).reversed().thenComparing(LfGenerator::getId)).orElse(null);
        if (referenceGenerator != null) {
            LfBus referenceBus = referenceGenerator.getBus();
            return new SelectedGeneratorReferenceBus(referenceBus, METHOD_NAME, referenceGenerator);
        }
        return FALLBACK_SELECTOR.select(lfNetwork);
    }
}

