/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.ReferenceBusFirstSlackSelector;
import com.powsybl.openloadflow.network.ReferenceBusGeneratorPrioritySelector;
import com.powsybl.openloadflow.network.ReferenceBusSelectionMode;
import com.powsybl.openloadflow.network.SelectedReferenceBus;
import java.util.Objects;

public interface ReferenceBusSelector {
    public static final ReferenceBusSelectionMode DEFAULT_MODE = ReferenceBusSelectionMode.FIRST_SLACK;
    public static final ReferenceBusSelector DEFAULT_SELECTOR = ReferenceBusSelector.fromMode(DEFAULT_MODE);

    public SelectedReferenceBus select(LfNetwork var1);

    public static ReferenceBusSelector fromMode(ReferenceBusSelectionMode mode) {
        Objects.requireNonNull(mode);
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case ReferenceBusSelectionMode.FIRST_SLACK -> new ReferenceBusFirstSlackSelector();
            case ReferenceBusSelectionMode.GENERATOR_REFERENCE_PRIORITY -> new ReferenceBusGeneratorPrioritySelector();
        };
    }
}

