/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.PiModelArray;
import java.util.Objects;

public class TapPositionChange {
    private final LfBranch branch;
    private final int value;
    private final boolean isRelative;

    public TapPositionChange(LfBranch branch, int value, boolean isRelative) {
        if (!(branch.getPiModel() instanceof PiModelArray)) {
            throw new IllegalStateException("A TapPositionChange can not be applied on a branch without PiModelArray");
        }
        this.branch = Objects.requireNonNull(branch);
        this.value = value;
        this.isRelative = isRelative;
    }

    public int getNewTapPosition() {
        int tapPosition = this.branch.getPiModel().getTapPosition();
        return this.isRelative ? tapPosition + this.value : this.value;
    }

    public PiModel getNewPiModel() {
        int newTapPosition = this.getNewTapPosition();
        return ((PiModelArray)this.branch.getPiModel()).getModel(newTapPosition);
    }

    public LfBranch getBranch() {
        return this.branch;
    }
}

