/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.network.Control;
import com.powsybl.openloadflow.network.LfBranch;
import java.util.Objects;

public class TransformerPhaseControl
extends Control {
    private final LfBranch controllerBranch;
    private final LfBranch controlledBranch;
    private final double targetDeadband;
    private final TwoSides controlledSide;
    private final Mode mode;
    private final Unit unit;

    public TransformerPhaseControl(LfBranch controllerBranch, LfBranch controlledBranch, TwoSides controlledSide, Mode mode, double targetValue, double targetDeadband, Unit unit) {
        super(targetValue);
        this.controllerBranch = Objects.requireNonNull(controllerBranch);
        this.controlledBranch = Objects.requireNonNull(controlledBranch);
        this.targetDeadband = targetDeadband;
        this.controlledSide = Objects.requireNonNull(controlledSide);
        this.mode = Objects.requireNonNull(mode);
        this.unit = Objects.requireNonNull(unit);
    }

    public TwoSides getControlledSide() {
        return this.controlledSide;
    }

    public double getTargetDeadband() {
        return this.targetDeadband;
    }

    public LfBranch getControllerBranch() {
        return this.controllerBranch;
    }

    public LfBranch getControlledBranch() {
        return this.controlledBranch;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public static enum Mode {
        CONTROLLER,
        LIMITER;

    }

    public static enum Unit {
        MW,
        A;

    }
}

