/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.action;

import com.powsybl.action.Action;
import com.powsybl.openloadflow.graph.GraphConnectivity;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfContingency;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.action.AbstractLfAction;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractLfBranchAction<A extends Action>
extends AbstractLfAction<A> {
    private LfBranch disabledBranch = null;
    private LfBranch enabledBranch = null;

    AbstractLfBranchAction(String id, A action, LfNetwork lfNetwork) {
        super(id, action);
        this.findEnabledDisabledBranches(lfNetwork);
    }

    protected void setDisabledBranch(LfBranch disabledBranch) {
        this.disabledBranch = disabledBranch;
    }

    protected void setEnabledBranch(LfBranch enabledBranch) {
        this.enabledBranch = enabledBranch;
    }

    public LfBranch getDisabledBranch() {
        return this.disabledBranch;
    }

    public LfBranch getEnabledBranch() {
        return this.enabledBranch;
    }

    abstract void findEnabledDisabledBranches(LfNetwork var1);

    @Override
    public boolean apply(LfNetwork network, LfContingency contingency, LfNetworkParameters networkParameters) {
        boolean found;
        boolean bl = found = this.disabledBranch != null || this.enabledBranch != null;
        if (!found) {
            return false;
        }
        GraphConnectivity<LfBus, LfBranch> connectivity = network.getConnectivity();
        connectivity.startTemporaryChanges();
        if (contingency != null) {
            contingency.getDisabledNetwork().getBranches().forEach(connectivity::removeEdge);
        }
        connectivity.startTemporaryChanges();
        this.updateConnectivity(connectivity);
        AbstractLfBranchAction.updateBusesAndBranchStatus(connectivity);
        connectivity.undoTemporaryChanges();
        connectivity.undoTemporaryChanges();
        return true;
    }

    public boolean applyOnConnectivity(GraphConnectivity<LfBus, LfBranch> connectivity) {
        boolean found = this.disabledBranch != null || this.enabledBranch != null;
        this.updateConnectivity(connectivity);
        return found;
    }

    private void updateConnectivity(GraphConnectivity<LfBus, LfBranch> connectivity) {
        if (this.disabledBranch != null && this.disabledBranch.getBus1() != null && this.disabledBranch.getBus2() != null) {
            connectivity.removeEdge(this.disabledBranch);
        }
        if (this.enabledBranch != null) {
            connectivity.addEdge(this.enabledBranch.getBus1(), this.enabledBranch.getBus2(), this.enabledBranch);
        }
    }

    public static void updateBusesAndBranchStatus(GraphConnectivity<LfBus, LfBranch> connectivity) {
        Set<LfBus> removedBuses = connectivity.getVerticesRemovedFromMainComponent();
        removedBuses.forEach(bus -> bus.setDisabled(true));
        HashSet<LfBranch> removedBranches = new HashSet<LfBranch>(connectivity.getEdgesRemovedFromMainComponent());
        for (LfBus bus2 : removedBuses) {
            bus2.getBranches().stream().filter(b -> !b.isConnectedAtBothSides()).forEach(removedBranches::add);
        }
        removedBranches.forEach(branch -> branch.setDisabled(true));
        Set<LfBus> addedBuses = connectivity.getVerticesAddedToMainComponent();
        addedBuses.forEach(bus -> bus.setDisabled(false));
        HashSet<LfBranch> addedBranches = new HashSet<LfBranch>(connectivity.getEdgesAddedToMainComponent());
        for (LfBus bus3 : addedBuses) {
            bus3.getBranches().stream().filter(b -> !b.isConnectedAtBothSides()).forEach(addedBranches::add);
        }
        addedBranches.forEach(branch -> branch.setDisabled(false));
    }
}

