/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.action;

import com.powsybl.action.AbstractTapChangerTapPositionAction;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.SimplePiModel;
import com.powsybl.openloadflow.network.TapPositionChange;
import com.powsybl.openloadflow.network.action.AbstractLfAction;
import com.powsybl.openloadflow.network.impl.LfLegBranch;

public abstract class AbstractLfTapChangerAction<A extends AbstractTapChangerTapPositionAction>
extends AbstractLfAction<A> {
    protected TapPositionChange change;
    protected LfBranch branch;

    AbstractLfTapChangerAction(String id, A action, LfNetwork network) {
        super(id, action);
        String branchId = action.getSide().map(side -> LfLegBranch.getId(side, action.getTransformerId())).orElseGet(() -> action.getTransformerId());
        this.branch = network.getBranchById(branchId);
        if (this.branch != null) {
            if (this.branch.getPiModel() instanceof SimplePiModel) {
                throw new UnsupportedOperationException("Tap position action: only one tap in branch " + this.branch.getId());
            }
            this.change = new TapPositionChange(this.branch, action.getTapPosition(), action.isRelativeValue());
        }
    }

    public TapPositionChange getChange() {
        return this.change;
    }
}

