/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.action;

import com.powsybl.action.Action;
import com.powsybl.action.AreaInterchangeTargetAction;
import com.powsybl.action.GeneratorAction;
import com.powsybl.action.HvdcAction;
import com.powsybl.action.LoadAction;
import com.powsybl.action.PhaseTapChangerTapPositionAction;
import com.powsybl.action.RatioTapChangerTapPositionAction;
import com.powsybl.action.ShuntCompensatorPositionAction;
import com.powsybl.action.SwitchAction;
import com.powsybl.action.TerminalsConnectionAction;
import com.powsybl.iidm.network.Network;
import com.powsybl.openloadflow.graph.GraphConnectivity;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfContingency;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.action.AbstractLfBranchAction;
import com.powsybl.openloadflow.network.action.LfAction;
import com.powsybl.openloadflow.network.action.LfAreaInterchangeTargetAction;
import com.powsybl.openloadflow.network.action.LfGeneratorAction;
import com.powsybl.openloadflow.network.action.LfHvdcAction;
import com.powsybl.openloadflow.network.action.LfLoadAction;
import com.powsybl.openloadflow.network.action.LfPhaseTapChangerAction;
import com.powsybl.openloadflow.network.action.LfRatioTapChangerAction;
import com.powsybl.openloadflow.network.action.LfShuntCompensatorPositionAction;
import com.powsybl.openloadflow.network.action.LfSwitchAction;
import com.powsybl.openloadflow.network.action.LfTerminalsConnectionAction;
import com.powsybl.openloadflow.util.Reports;
import java.util.List;
import java.util.Objects;

public final class LfActionUtils {
    private LfActionUtils() {
    }

    public static LfAction createLfAction(Action action, Network network, boolean breakers, LfNetwork lfNetwork) {
        Objects.requireNonNull(action);
        Objects.requireNonNull(network);
        return switch (action.getType()) {
            case "SWITCH" -> new LfSwitchAction(action.getId(), (SwitchAction)action, lfNetwork);
            case "TERMINALS_CONNECTION" -> new LfTerminalsConnectionAction(action.getId(), (TerminalsConnectionAction)action, lfNetwork);
            case "PHASE_TAP_CHANGER_TAP_POSITION" -> new LfPhaseTapChangerAction(action.getId(), (PhaseTapChangerTapPositionAction)action, lfNetwork);
            case "RATIO_TAP_CHANGER_TAP_POSITION" -> new LfRatioTapChangerAction(action.getId(), (RatioTapChangerTapPositionAction)action, lfNetwork);
            case "LOAD" -> new LfLoadAction(action.getId(), (LoadAction)action, network, breakers);
            case "GENERATOR" -> new LfGeneratorAction(action.getId(), (GeneratorAction)action, lfNetwork);
            case "HVDC" -> new LfHvdcAction(action.getId(), (HvdcAction)action);
            case "SHUNT_COMPENSATOR_POSITION" -> new LfShuntCompensatorPositionAction(action.getId(), (ShuntCompensatorPositionAction)action);
            case "AREA_INTERCHANGE_TARGET_ACTION" -> new LfAreaInterchangeTargetAction(action.getId(), (AreaInterchangeTargetAction)action);
            default -> throw new UnsupportedOperationException("Unsupported action type: " + action.getType());
        };
    }

    public static void applyListOfActions(List<LfAction> actions, LfNetwork network, LfContingency contingency, LfNetworkParameters networkParameters) {
        Objects.requireNonNull(actions);
        Objects.requireNonNull(network);
        List<LfAction> branchActions = actions.stream().filter(action -> action instanceof AbstractLfBranchAction).toList();
        LfActionUtils.updateConnectivity(branchActions, network, contingency);
        actions.stream().filter(action -> !(action instanceof AbstractLfBranchAction)).forEach(action -> {
            if (!action.apply(network, contingency, networkParameters)) {
                Reports.reportActionApplicationFailure(action.getId(), contingency.getId(), network.getReportNode());
            }
        });
    }

    private static void updateConnectivity(List<LfAction> branchActions, LfNetwork network, LfContingency contingency) {
        GraphConnectivity<LfBus, LfBranch> connectivity = network.getConnectivity();
        connectivity.startTemporaryChanges();
        contingency.getDisabledNetwork().getBranches().forEach(connectivity::removeEdge);
        connectivity.startTemporaryChanges();
        branchActions.forEach(action -> {
            if (!((AbstractLfBranchAction)action).applyOnConnectivity(connectivity)) {
                Reports.reportActionApplicationFailure(action.getId(), contingency.getId(), network.getReportNode());
            }
        });
        AbstractLfBranchAction.updateBusesAndBranchStatus(connectivity);
        connectivity.undoTemporaryChanges();
        connectivity.undoTemporaryChanges();
    }
}

