/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.action;

import com.powsybl.action.GeneratorAction;
import com.powsybl.openloadflow.network.LfContingency;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.action.AbstractLfAction;
import java.util.Optional;
import java.util.OptionalDouble;

public class LfGeneratorAction
extends AbstractLfAction<GeneratorAction> {
    private GeneratorChange generatorChange;

    public LfGeneratorAction(String id, GeneratorAction action, LfNetwork lfNetwork) {
        super(id, action);
        LfGenerator generator = lfNetwork.getGeneratorById(action.getGeneratorId());
        if (generator != null) {
            OptionalDouble activePowerValue = action.getActivePowerValue();
            Optional relativeValue = action.isActivePowerRelativeValue();
            if (relativeValue.isEmpty() || activePowerValue.isEmpty()) {
                throw new UnsupportedOperationException("Generator action on " + action.getGeneratorId() + " : configuration not supported yet.");
            }
            this.generatorChange = new GeneratorChange(activePowerValue.getAsDouble() / 100.0, (Boolean)relativeValue.get());
        }
    }

    @Override
    public boolean apply(LfNetwork network, LfContingency contingency, LfNetworkParameters networkParameters) {
        LfGenerator generator = network.getGeneratorById(((GeneratorAction)this.action).getGeneratorId());
        if (generator != null && !generator.isDisabled()) {
            double newTargetP = this.generatorChange.isRelative() ? generator.getTargetP() + this.generatorChange.change() : this.generatorChange.change();
            generator.setTargetP(newTargetP);
            generator.setInitialTargetP(newTargetP);
            generator.reApplyActivePowerControlChecks(networkParameters, null);
            return true;
        }
        return false;
    }

    private record GeneratorChange(double change, boolean isRelative) {
    }
}

