/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.action;

import com.powsybl.action.HvdcAction;
import com.powsybl.openloadflow.network.LfContingency;
import com.powsybl.openloadflow.network.LfHvdc;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.action.AbstractLfAction;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LfHvdcAction
extends AbstractLfAction<HvdcAction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LfHvdcAction.class);

    public LfHvdcAction(String id, HvdcAction action) {
        super(id, action);
        Optional acEmulationEnabled = action.isAcEmulationEnabled();
        if (acEmulationEnabled.isPresent() && ((Boolean)acEmulationEnabled.get()).equals(Boolean.TRUE)) {
            throw new UnsupportedOperationException("Hvdc action: enabling ac emulation mode through an action is not supported yet.");
        }
    }

    @Override
    public boolean apply(LfNetwork network, LfContingency contingency, LfNetworkParameters networkParameters) {
        LfHvdc lfHvdc = network.getHvdcById(((HvdcAction)this.action).getHvdcId());
        if (lfHvdc != null) {
            if (((HvdcAction)this.action).isAcEmulationEnabled().isEmpty()) {
                LOGGER.warn("Hvdc action {}: only explicitly disabling ac emulation is supported.", (Object)((HvdcAction)this.action).getId());
                return false;
            }
            lfHvdc.setAcEmulation(false);
            lfHvdc.setDisabled(true);
            lfHvdc.getConverterStation1().setTargetP(-lfHvdc.getP1().eval());
            lfHvdc.getConverterStation2().setTargetP(-lfHvdc.getP2().eval());
            return true;
        }
        LOGGER.warn("Hvdc action {}: hvdc line not found", (Object)((HvdcAction)this.action).getId());
        return false;
    }
}

