/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.action;

import com.powsybl.action.LoadAction;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.openloadflow.network.LfContingency;
import com.powsybl.openloadflow.network.LfLoad;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.PowerShift;
import com.powsybl.openloadflow.network.action.AbstractLfAction;
import com.powsybl.openloadflow.network.impl.Networks;

public class LfLoadAction
extends AbstractLfAction<LoadAction> {
    private final Network network;
    private final boolean breakers;

    public LfLoadAction(String id, LoadAction action, Network network, boolean breakers) {
        super(id, action);
        this.network = network;
        this.breakers = breakers;
    }

    @Override
    public boolean apply(LfNetwork lfNetwork, LfContingency contingency, LfNetworkParameters networkParameters) {
        LfLoad lfLoad;
        Load load = this.network.getLoad(((LoadAction)this.action).getLoadId());
        Terminal terminal = load.getTerminal();
        Bus bus = Networks.getBus(terminal, this.breakers);
        if (bus != null && (lfLoad = lfNetwork.getLoadById(load.getId())) != null) {
            PowerShift powerShift = PowerShift.createPowerShift(load, (LoadAction)this.action);
            if (!lfLoad.isOriginalLoadDisabled(load.getId())) {
                lfLoad.setTargetP(lfLoad.getTargetP() + powerShift.getActive());
                lfLoad.setTargetQ(lfLoad.getTargetQ() + powerShift.getReactive());
                lfLoad.setAbsVariableTargetP(lfLoad.getAbsVariableTargetP() + Math.signum(powerShift.getActive()) * Math.abs(powerShift.getVariableActive()));
                return true;
            }
        }
        return false;
    }
}

