/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.action;

import com.powsybl.action.ShuntCompensatorPositionAction;
import com.powsybl.openloadflow.network.LfContingency;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.action.AbstractLfAction;
import com.powsybl.openloadflow.network.impl.LfShuntImpl;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LfShuntCompensatorPositionAction
extends AbstractLfAction<ShuntCompensatorPositionAction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LfShuntCompensatorPositionAction.class);

    public LfShuntCompensatorPositionAction(String id, ShuntCompensatorPositionAction action) {
        super(id, action);
    }

    @Override
    public boolean apply(LfNetwork network, LfContingency contingency, LfNetworkParameters networkParameters) {
        LfShunt shunt = network.getShuntById(((ShuntCompensatorPositionAction)this.action).getShuntCompensatorId());
        if (shunt instanceof LfShuntImpl) {
            Optional<LfShunt.Controller> controllerOpt;
            if (shunt.getVoltageControl().isPresent()) {
                LOGGER.warn("Shunt compensator position action: voltage control is present on the shunt, section could be overridden.");
            }
            if ((controllerOpt = shunt.getControllers().stream().filter(controller -> controller.getId().equals(((ShuntCompensatorPositionAction)this.action).getShuntCompensatorId())).findAny()).isPresent()) {
                controllerOpt.get().updateSectionB(((ShuntCompensatorPositionAction)this.action).getSectionCount());
                return true;
            }
            LOGGER.warn("No section change: shunt {} not present", (Object)((ShuntCompensatorPositionAction)this.action).getShuntCompensatorId());
            return false;
        }
        return false;
    }
}

