/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.action;

import com.powsybl.action.TerminalsConnectionAction;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.action.AbstractLfBranchAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LfTerminalsConnectionAction
extends AbstractLfBranchAction<TerminalsConnectionAction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LfTerminalsConnectionAction.class);

    public LfTerminalsConnectionAction(String id, TerminalsConnectionAction action, LfNetwork lfNetwork) {
        super(id, action, lfNetwork);
        if (action.getSide().isPresent()) {
            throw new UnsupportedOperationException("Terminals connection action: only open or close branch at both sides is supported yet.");
        }
    }

    @Override
    void findEnabledDisabledBranches(LfNetwork lfNetwork) {
        LfBranch branch = lfNetwork.getBranchById(((TerminalsConnectionAction)this.action).getElementId());
        if (branch != null && branch.getBus1() != null && branch.getBus2() != null) {
            if (((TerminalsConnectionAction)this.action).isOpen()) {
                this.setDisabledBranch(branch);
            } else {
                this.setEnabledBranch(branch);
            }
        } else {
            LOGGER.warn("TerminalsConnectionAction action {}: branch matching element id {} not found", (Object)((TerminalsConnectionAction)this.action).getId(), (Object)((TerminalsConnectionAction)this.action).getElementId());
        }
    }
}

