/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.network.AbstractElement;
import com.powsybl.openloadflow.network.ElementType;
import com.powsybl.openloadflow.network.GeneratorReactivePowerControl;
import com.powsybl.openloadflow.network.LfAsymLine;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkListener;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfZeroImpedanceNetwork;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.TransformerPhaseControl;
import com.powsybl.openloadflow.network.TransformerReactivePowerControl;
import com.powsybl.openloadflow.network.TransformerVoltageControl;
import com.powsybl.openloadflow.network.impl.Transformers;
import com.powsybl.openloadflow.sa.LimitReductionManager;
import com.powsybl.openloadflow.util.Evaluable;
import com.powsybl.openloadflow.util.PerUnit;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.jafama.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLfBranch
extends AbstractElement
implements LfBranch {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLfBranch.class);
    protected final LfBus bus1;
    protected final LfBus bus2;
    private List<LfBranch.LfLimit> currentLimits1;
    private List<LfBranch.LfLimit> activePowerLimits1;
    private List<LfBranch.LfLimit> apparentPowerLimits1;
    private List<LfBranch.LfLimit> currentLimits2;
    private List<LfBranch.LfLimit> activePowerLimits2;
    private List<LfBranch.LfLimit> apparentPowerLimits2;
    protected final PiModel piModel;
    protected TransformerPhaseControl phaseControl;
    protected boolean phaseControlEnabled = false;
    protected TransformerVoltageControl voltageControl;
    protected boolean voltageControlEnabled = false;
    protected TransformerReactivePowerControl transformerReactivePowerControl;
    protected final Map<LoadFlowModel, ZeroImpedanceContext> zeroImpedanceContextByModel = new EnumMap<LoadFlowModel, ZeroImpedanceContext>(LoadFlowModel.class);
    protected Evaluable a1;
    private GeneratorReactivePowerControl generatorReactivePowerControl;
    protected LfAsymLine asymLine;
    private static final String LIMIT_TYPE_UNSUPPORTED_TEMPLATE = "Getting %s limits is not supported.";

    protected AbstractLfBranch(LfNetwork network, LfBus bus1, LfBus bus2, PiModel piModel, LfNetworkParameters parameters) {
        super(network);
        this.bus1 = bus1;
        this.bus2 = bus2;
        this.piModel = Objects.requireNonNull(piModel);
        this.piModel.setBranch(this);
        for (LoadFlowModel loadFlowModel : LoadFlowModel.values()) {
            this.zeroImpedanceContextByModel.put(loadFlowModel, new ZeroImpedanceContext());
        }
        if (!parameters.isMinImpedance()) {
            for (LoadFlowModel loadFlowModel : LoadFlowModel.values()) {
                this.zeroImpedanceContextByModel.get((Object)((Object)loadFlowModel)).zeroImpedance = AbstractLfBranch.isZeroImpedanceBranch(piModel, loadFlowModel, parameters.getLowImpedanceThreshold());
            }
        }
    }

    @Override
    public Optional<ThreeSides> getOriginalSide() {
        return Optional.empty();
    }

    protected static List<LfBranch.LfLimit> createSortedLimitsList(LoadingLimits loadingLimits, LfBus bus, double[] limitReductions) {
        ArrayList<LfBranch.LfLimit> sortedLimits = new ArrayList<LfBranch.LfLimit>(3);
        if (loadingLimits != null) {
            double toPerUnit = AbstractLfBranch.getScaleForLimitType(loadingLimits.getLimitType(), bus);
            int i = 0;
            for (LoadingLimits.TemporaryLimit temporaryLimit : loadingLimits.getTemporaryLimits()) {
                if (temporaryLimit.getAcceptableDuration() != 0) {
                    double reduction = limitReductions.length == 0 ? 1.0 : limitReductions[i + 1];
                    double originalValuePerUnit = temporaryLimit.getValue() * toPerUnit;
                    sortedLimits.add(0, LfBranch.LfLimit.createTemporaryLimit(temporaryLimit.getName(), temporaryLimit.getAcceptableDuration(), originalValuePerUnit, reduction));
                }
                ++i;
            }
            double reduction = limitReductions.length == 0 ? 1.0 : limitReductions[0];
            sortedLimits.add(LfBranch.LfLimit.createPermanentLimit(loadingLimits.getPermanentLimit() * toPerUnit, reduction));
        }
        if (sortedLimits.size() > 1) {
            for (int i = sortedLimits.size() - 1; i > 0; --i) {
                ((LfBranch.LfLimit)sortedLimits.get(i)).setAcceptableDuration(((LfBranch.LfLimit)sortedLimits.get(i - 1)).getAcceptableDuration());
            }
            ((LfBranch.LfLimit)sortedLimits.get(0)).setAcceptableDuration(0);
        }
        return sortedLimits;
    }

    @Override
    public ElementType getType() {
        return ElementType.BRANCH;
    }

    @Override
    public LfBus getBus1() {
        return this.bus1;
    }

    @Override
    public LfBus getBus2() {
        return this.bus2;
    }

    private List<LfBranch.LfLimit> getLimits1(LimitType type) {
        switch (type) {
            case ACTIVE_POWER: {
                return this.activePowerLimits1;
            }
            case APPARENT_POWER: {
                return this.apparentPowerLimits1;
            }
            case CURRENT: {
                return this.currentLimits1;
            }
        }
        throw new UnsupportedOperationException(String.format(LIMIT_TYPE_UNSUPPORTED_TEMPLATE, type.name()));
    }

    private void setLimits1(LimitType type, List<LfBranch.LfLimit> limits) {
        switch (type) {
            case ACTIVE_POWER: {
                this.activePowerLimits1 = limits;
                break;
            }
            case APPARENT_POWER: {
                this.apparentPowerLimits1 = limits;
                break;
            }
            case CURRENT: {
                this.currentLimits1 = limits;
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format(LIMIT_TYPE_UNSUPPORTED_TEMPLATE, type.name()));
            }
        }
    }

    public <T extends LoadingLimits> List<LfBranch.LfLimit> getLimits1(LimitType type, Supplier<Optional<T>> loadingLimitsSupplier, LimitReductionManager limitReductionManager) {
        List<LfBranch.LfLimit> limits = this.getLimits1(type);
        if (limits == null) {
            LoadingLimits loadingLimits = loadingLimitsSupplier.get().orElse(null);
            limits = AbstractLfBranch.createSortedLimitsList(loadingLimits, this.bus1, this.getLimitReductions(TwoSides.ONE, limitReductionManager, loadingLimits));
            this.setLimits1(type, limits);
        }
        return limits;
    }

    private List<LfBranch.LfLimit> getLimits2(LimitType type) {
        switch (type) {
            case ACTIVE_POWER: {
                return this.activePowerLimits2;
            }
            case APPARENT_POWER: {
                return this.apparentPowerLimits2;
            }
            case CURRENT: {
                return this.currentLimits2;
            }
        }
        throw new UnsupportedOperationException(String.format(LIMIT_TYPE_UNSUPPORTED_TEMPLATE, type.name()));
    }

    private void setLimits2(LimitType type, List<LfBranch.LfLimit> limits) {
        switch (type) {
            case ACTIVE_POWER: {
                this.activePowerLimits2 = limits;
                break;
            }
            case APPARENT_POWER: {
                this.apparentPowerLimits2 = limits;
                break;
            }
            case CURRENT: {
                this.currentLimits2 = limits;
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format(LIMIT_TYPE_UNSUPPORTED_TEMPLATE, type.name()));
            }
        }
    }

    public <T extends LoadingLimits> List<LfBranch.LfLimit> getLimits2(LimitType type, Supplier<Optional<T>> loadingLimitsSupplier, LimitReductionManager limitReductionManager) {
        List<LfBranch.LfLimit> limits = this.getLimits2(type);
        if (limits == null) {
            LoadingLimits loadingLimits = loadingLimitsSupplier.get().orElse(null);
            limits = AbstractLfBranch.createSortedLimitsList(loadingLimits, this.bus2, this.getLimitReductions(TwoSides.TWO, limitReductionManager, loadingLimits));
            this.setLimits2(type, limits);
        }
        return limits;
    }

    @Override
    public PiModel getPiModel() {
        return this.piModel;
    }

    @Override
    public Optional<TransformerPhaseControl> getPhaseControl() {
        return Optional.ofNullable(this.phaseControl);
    }

    @Override
    public void setPhaseControl(TransformerPhaseControl phaseControl) {
        this.phaseControl = phaseControl;
    }

    @Override
    public boolean isPhaseController() {
        return this.phaseControl != null && this.phaseControl.getControllerBranch() == this;
    }

    @Override
    public boolean isPhaseControlled() {
        return this.phaseControl != null && this.phaseControl.getControlledBranch() == this;
    }

    @Override
    public boolean isPhaseControlEnabled() {
        return this.phaseControlEnabled;
    }

    @Override
    public void setPhaseControlEnabled(boolean phaseControlEnabled) {
        if (this.phaseControlEnabled != phaseControlEnabled) {
            this.phaseControlEnabled = phaseControlEnabled;
            for (LfNetworkListener listener : this.network.getListeners()) {
                listener.onTransformerPhaseControlChange(this, phaseControlEnabled);
            }
        }
    }

    protected void updateSolvedTapPosition(PhaseTapChanger ptc) {
        int tapPosition = Transformers.findTapPosition(ptc, Math.toDegrees(this.getPiModel().getA1()));
        ptc.setSolvedTapPosition(tapPosition);
    }

    protected void updateSolvedTapPosition(RatioTapChanger rtc, double ptcRho, double rho) {
        Transformers.findTapPosition(rtc, ptcRho, rho).ifPresent(arg_0 -> ((RatioTapChanger)rtc).setSolvedTapPosition(arg_0));
    }

    protected static double getScaleForLimitType(LimitType type, LfBus bus) {
        switch (type) {
            case ACTIVE_POWER: 
            case APPARENT_POWER: {
                return 0.01;
            }
            case CURRENT: {
                return 1.0 / PerUnit.ib(bus.getNominalV());
            }
        }
        throw new UnsupportedOperationException(String.format("Getting scale for limit type %s is not supported.", type));
    }

    @Override
    public Optional<TransformerVoltageControl> getVoltageControl() {
        return Optional.ofNullable(this.voltageControl);
    }

    @Override
    public boolean isVoltageController() {
        return this.voltageControl != null;
    }

    @Override
    public void setVoltageControl(TransformerVoltageControl transformerVoltageControl) {
        this.voltageControl = transformerVoltageControl;
    }

    @Override
    public boolean isVoltageControlEnabled() {
        return this.voltageControlEnabled;
    }

    @Override
    public void setVoltageControlEnabled(boolean voltageControlEnabled) {
        if (this.voltageControlEnabled != voltageControlEnabled) {
            this.voltageControlEnabled = voltageControlEnabled;
            for (LfNetworkListener listener : this.network.getListeners()) {
                listener.onTransformerVoltageControlChange(this, voltageControlEnabled);
            }
        }
    }

    @Override
    public Optional<TransformerReactivePowerControl> getTransformerReactivePowerControl() {
        return Optional.ofNullable(this.transformerReactivePowerControl);
    }

    @Override
    public void setTransformerReactivePowerControl(TransformerReactivePowerControl transformerReactivePowerControl) {
        this.transformerReactivePowerControl = transformerReactivePowerControl;
    }

    @Override
    public boolean isTransformerReactivePowerController() {
        return this.transformerReactivePowerControl != null && this.transformerReactivePowerControl.getControllerBranch() == this;
    }

    @Override
    public boolean isTransformerReactivePowerControlled() {
        return this.transformerReactivePowerControl != null && this.transformerReactivePowerControl.getControlledBranch() == this;
    }

    @Override
    public double computeApparentPower1() {
        double p = this.getP1().eval();
        double q = this.getQ1().eval();
        return FastMath.sqrt((double)(p * p + q * q));
    }

    @Override
    public double computeApparentPower2() {
        double p = this.getP2().eval();
        double q = this.getQ2().eval();
        return FastMath.sqrt((double)(p * p + q * q));
    }

    @Override
    public boolean isZeroImpedance(LoadFlowModel loadFlowModel) {
        return this.zeroImpedanceContextByModel.get((Object)((Object)loadFlowModel)).zeroImpedance;
    }

    @Override
    public void setSpanningTreeEdge(LoadFlowModel loadFlowModel, boolean spanningTreeEdge) {
        ZeroImpedanceContext context = this.zeroImpedanceContextByModel.get((Object)loadFlowModel);
        if (spanningTreeEdge != context.spanningTreeEdge) {
            context.spanningTreeEdge = spanningTreeEdge;
            for (LfNetworkListener listener : this.network.getListeners()) {
                listener.onZeroImpedanceNetworkSpanningTreeChange(this, loadFlowModel, spanningTreeEdge);
            }
        }
    }

    @Override
    public boolean isSpanningTreeEdge(LoadFlowModel loadFlowModel) {
        this.network.updateZeroImpedanceCache(loadFlowModel);
        return this.zeroImpedanceContextByModel.get((Object)((Object)loadFlowModel)).spanningTreeEdge;
    }

    @Override
    public Evaluable getA1() {
        return this.a1;
    }

    @Override
    public void setA1(Evaluable a1) {
        this.a1 = a1;
    }

    @Override
    public Optional<GeneratorReactivePowerControl> getGeneratorReactivePowerControl() {
        return Optional.ofNullable(this.generatorReactivePowerControl);
    }

    @Override
    public void setGeneratorReactivePowerControl(GeneratorReactivePowerControl pGeneratorReactivePowerControl) {
        this.generatorReactivePowerControl = Objects.requireNonNull(pGeneratorReactivePowerControl);
    }

    @Override
    public boolean isConnectedAtBothSides() {
        return this.isConnectedSide1() && this.isConnectedSide2();
    }

    @Override
    public void setMinZ(double lowImpedanceThreshold) {
        for (LoadFlowModel loadFlowModel : List.of(LoadFlowModel.AC, LoadFlowModel.DC)) {
            if (!this.piModel.setMinZ(lowImpedanceThreshold, loadFlowModel) && (!LoadFlowModel.DC.equals((Object)loadFlowModel) || !this.isZeroImpedance(loadFlowModel))) continue;
            LOGGER.trace("Branch {} has a low impedance in {}, set to min {}", new Object[]{this.getId(), loadFlowModel, lowImpedanceThreshold});
            this.zeroImpedanceContextByModel.get((Object)((Object)loadFlowModel)).zeroImpedance = false;
        }
    }

    private static boolean isZeroImpedanceBranch(PiModel piModel, LoadFlowModel loadFlowModel, double lowImpedanceThreshold) {
        if (loadFlowModel == LoadFlowModel.DC) {
            return FastMath.abs((double)piModel.getX()) < lowImpedanceThreshold;
        }
        return piModel.getZ() < lowImpedanceThreshold;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateZeroImpedanceNetworks(boolean disabled, LoadFlowModel loadFlowModel) {
        if (!this.isZeroImpedance(loadFlowModel)) return;
        LfZeroImpedanceNetwork zn1 = this.bus1.getZeroImpedanceNetwork(loadFlowModel);
        LfZeroImpedanceNetwork zn2 = this.bus2.getZeroImpedanceNetwork(loadFlowModel);
        if (zn1 == null || zn2 == null) return;
        if (disabled) {
            if (zn1 != zn2) throw new IllegalStateException("Should not happen");
            zn1.removeBranchAndTryToSplit(this);
            return;
        } else if (zn1 != zn2) {
            LfZeroImpedanceNetwork.addBranchAndMerge(zn1, zn2, this);
            return;
        } else {
            zn1.addBranch(this);
        }
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (disabled != this.disabled) {
            this.disabled = disabled;
            this.notifyDisable();
            if (this.bus1 != null && this.bus2 != null) {
                this.updateZeroImpedanceNetworks(disabled, LoadFlowModel.AC);
                this.updateZeroImpedanceNetworks(disabled, LoadFlowModel.DC);
            }
        }
    }

    @Override
    public LfAsymLine getAsymLine() {
        return this.asymLine;
    }

    @Override
    public void setAsymLine(LfAsymLine asymLine) {
        this.asymLine = asymLine;
    }

    @Override
    public boolean isAsymmetric() {
        if (this.asymLine != null) {
            return this.asymLine.getAdmittanceMatrix().isCoupled();
        }
        return false;
    }

    static class ZeroImpedanceContext {
        boolean spanningTreeEdge = false;
        boolean zeroImpedance = false;

        ZeroImpedanceContext() {
        }
    }
}

