/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.ExponentialLoadModel;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadModel;
import com.powsybl.iidm.network.LoadModelType;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.ZipLoadModel;
import com.powsybl.openloadflow.network.AbstractElement;
import com.powsybl.openloadflow.network.ElementType;
import com.powsybl.openloadflow.network.GeneratorReactivePowerControl;
import com.powsybl.openloadflow.network.GeneratorVoltageControl;
import com.powsybl.openloadflow.network.LfArea;
import com.powsybl.openloadflow.network.LfAsymBus;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfHvdc;
import com.powsybl.openloadflow.network.LfLoad;
import com.powsybl.openloadflow.network.LfLoadModel;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkListener;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.LfStandbyAutomatonShunt;
import com.powsybl.openloadflow.network.LfTopoConfig;
import com.powsybl.openloadflow.network.LfZeroImpedanceNetwork;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.ReactivePowerDispatchMode;
import com.powsybl.openloadflow.network.ShuntVoltageControl;
import com.powsybl.openloadflow.network.TransformerVoltageControl;
import com.powsybl.openloadflow.network.VoltageControl;
import com.powsybl.openloadflow.network.impl.HvdcConverterStations;
import com.powsybl.openloadflow.network.impl.LfBatteryImpl;
import com.powsybl.openloadflow.network.impl.LfGeneratorImpl;
import com.powsybl.openloadflow.network.impl.LfLoadImpl;
import com.powsybl.openloadflow.network.impl.LfNetworkLoadingReport;
import com.powsybl.openloadflow.network.impl.LfShuntImpl;
import com.powsybl.openloadflow.network.impl.LfStaticVarCompensatorImpl;
import com.powsybl.openloadflow.network.impl.LfVscConverterStationImpl;
import com.powsybl.openloadflow.util.Evaluable;
import com.powsybl.openloadflow.util.EvaluableConstants;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.ToDoubleFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLfBus
extends AbstractElement
implements LfBus {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractLfBus.class);
    private static final double Q_DISPATCH_EPSILON = 0.001;
    private static final double PLAUSIBLE_REACTIVE_LIMITS = 10.0;
    protected boolean slack = false;
    protected boolean reference = false;
    protected double v;
    protected Evaluable calculatedV = EvaluableConstants.NAN;
    protected double angle;
    private boolean hasGeneratorsWithSlope;
    protected boolean generatorVoltageControlEnabled = false;
    protected boolean generatorReactivePowerControlEnabled = false;
    protected Double generationTargetP;
    protected double generationTargetQ = 0.0;
    protected LfBus.QLimitType qLimitType;
    protected final List<LfGenerator> generators = new ArrayList<LfGenerator>();
    protected LfShunt shunt;
    protected LfShunt controllerShunt;
    protected LfShunt svcShunt;
    protected boolean distributedOnConformLoad;
    protected final List<LfLoad> loads = new ArrayList<LfLoad>();
    protected Double loadTargetP;
    protected Double loadTargetQ;
    protected final List<LfBranch> branches = new ArrayList<LfBranch>();
    protected final List<LfHvdc> hvdcs = new ArrayList<LfHvdc>();
    private GeneratorVoltageControl generatorVoltageControl;
    private GeneratorReactivePowerControl generatorReactivePowerControl;
    protected TransformerVoltageControl transformerVoltageControl;
    protected ShuntVoltageControl shuntVoltageControl;
    protected Evaluable p = EvaluableConstants.NAN;
    protected Evaluable q = EvaluableConstants.NAN;
    protected double remoteControlReactivePercent = Double.NaN;
    protected final Map<LoadFlowModel, LfZeroImpedanceNetwork> zeroImpedanceNetwork = new EnumMap<LoadFlowModel, LfZeroImpedanceNetwork>(LoadFlowModel.class);
    protected LfAsymBus asym;
    private LfArea area = null;

    protected AbstractLfBus(LfNetwork network, double v, double angle, boolean distributedOnConformLoad) {
        super(network);
        this.v = v;
        this.angle = angle;
        this.distributedOnConformLoad = distributedOnConformLoad;
    }

    @Override
    public ElementType getType() {
        return ElementType.BUS;
    }

    @Override
    public boolean isSlack() {
        this.network.updateSlackBusesAndReferenceBus();
        return this.slack;
    }

    @Override
    public void setSlack(boolean slack) {
        if (slack != this.slack) {
            this.slack = slack;
            for (LfNetworkListener listener : this.network.getListeners()) {
                listener.onSlackBusChange(this, slack);
            }
        }
    }

    @Override
    public boolean isReference() {
        this.network.updateSlackBusesAndReferenceBus();
        return this.reference;
    }

    @Override
    public void setReference(boolean reference) {
        if (reference != this.reference) {
            this.reference = reference;
            for (LfNetworkListener listener : this.network.getListeners()) {
                listener.onReferenceBusChange(this, reference);
            }
        }
    }

    @Override
    public double getTargetP() {
        return this.getGenerationTargetP() - this.getLoadTargetP();
    }

    @Override
    public double getTargetQ() {
        return this.getGenerationTargetQ() - this.getLoadTargetQ();
    }

    @Override
    public List<VoltageControl<?>> getVoltageControls() {
        ArrayList voltageControls = new ArrayList(3);
        this.getGeneratorVoltageControl().ifPresent(voltageControls::add);
        this.getTransformerVoltageControl().ifPresent(voltageControls::add);
        this.getShuntVoltageControl().ifPresent(voltageControls::add);
        return voltageControls;
    }

    @Override
    public boolean isVoltageControlled() {
        return this.isGeneratorVoltageControlled() || this.isShuntVoltageControlled() || this.isTransformerVoltageControlled();
    }

    @Override
    public boolean isVoltageControlled(VoltageControl.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case VoltageControl.Type.GENERATOR -> this.isGeneratorVoltageControlled();
            case VoltageControl.Type.TRANSFORMER -> this.isTransformerVoltageControlled();
            case VoltageControl.Type.SHUNT -> this.isShuntVoltageControlled();
        };
    }

    @Override
    public Optional<VoltageControl<?>> getVoltageControl(VoltageControl.Type type) {
        return this.getVoltageControls().stream().filter(vc -> vc.getType() == type).findAny();
    }

    @Override
    public OptionalDouble getHighestPriorityTargetV() {
        return VoltageControl.getHighestPriorityTargetV(this);
    }

    @Override
    public Optional<GeneratorVoltageControl> getGeneratorVoltageControl() {
        return Optional.ofNullable(this.generatorVoltageControl);
    }

    @Override
    public void setGeneratorVoltageControl(GeneratorVoltageControl generatorVoltageControl) {
        this.generatorVoltageControl = generatorVoltageControl;
        if (generatorVoltageControl != null) {
            if (this.hasGeneratorVoltageControllerCapability()) {
                this.generatorVoltageControlEnabled = true;
            } else if (!this.isGeneratorVoltageControlled()) {
                throw new PowsyblException("Setting inconsistent voltage control to bus " + this.getId());
            }
        } else {
            this.generatorVoltageControlEnabled = false;
        }
    }

    private boolean hasGeneratorVoltageControllerCapability() {
        return this.generatorVoltageControl != null && this.generatorVoltageControl.getControllerElements().contains(this);
    }

    @Override
    public Optional<GeneratorReactivePowerControl> getGeneratorReactivePowerControl() {
        return Optional.ofNullable(this.generatorReactivePowerControl);
    }

    @Override
    public void setGeneratorReactivePowerControl(GeneratorReactivePowerControl generatorReactivePowerControl) {
        this.generatorReactivePowerControl = Objects.requireNonNull(generatorReactivePowerControl);
    }

    @Override
    public boolean hasGeneratorReactivePowerControl() {
        return this.generatorReactivePowerControl != null;
    }

    @Override
    public boolean isGeneratorReactivePowerControlEnabled() {
        return this.generatorReactivePowerControlEnabled;
    }

    @Override
    public void setGeneratorReactivePowerControlEnabled(boolean generatorReactivePowerControlEnabled) {
        if (this.generatorReactivePowerControlEnabled != generatorReactivePowerControlEnabled) {
            this.generatorReactivePowerControlEnabled = generatorReactivePowerControlEnabled;
            for (LfNetworkListener listener : this.network.getListeners()) {
                listener.onGeneratorReactivePowerControlChange(this, generatorReactivePowerControlEnabled);
            }
        }
    }

    @Override
    public boolean isGeneratorVoltageControlled() {
        return this.generatorVoltageControl != null && this.generatorVoltageControl.getControlledBus() == this;
    }

    @Override
    public List<LfGenerator> getGeneratorsControllingVoltageWithSlope() {
        return this.generators.stream().filter(gen -> gen.getGeneratorControlType() == LfGenerator.GeneratorControlType.VOLTAGE && gen.getSlope() != 0.0).toList();
    }

    @Override
    public boolean hasGeneratorsWithSlope() {
        return this.hasGeneratorsWithSlope;
    }

    @Override
    public void removeGeneratorSlopes() {
        this.hasGeneratorsWithSlope = false;
        this.generators.forEach(g -> g.setSlope(0.0));
    }

    @Override
    public boolean isGeneratorVoltageControlEnabled() {
        return this.generatorVoltageControlEnabled;
    }

    @Override
    public void setGeneratorVoltageControlEnabled(boolean generatorVoltageControlEnabled) {
        if (this.generatorVoltageControlEnabled != generatorVoltageControlEnabled) {
            this.generatorVoltageControlEnabled = generatorVoltageControlEnabled;
            for (LfNetworkListener listener : this.network.getListeners()) {
                listener.onGeneratorVoltageControlChange(this, generatorVoltageControlEnabled);
            }
        }
    }

    private static LfLoadModel createLfLoadModel(LoadModel loadModel, LfNetworkParameters parameters) {
        if (!parameters.isUseLoadModel() || loadModel == null) {
            return null;
        }
        if (loadModel.getType() == LoadModelType.ZIP) {
            ZipLoadModel zipLoadModel = (ZipLoadModel)loadModel;
            return new LfLoadModel(List.of(new LfLoadModel.ExpTerm(zipLoadModel.getC0p(), 0.0), new LfLoadModel.ExpTerm(zipLoadModel.getC1p(), 1.0), new LfLoadModel.ExpTerm(zipLoadModel.getC2p(), 2.0)), List.of(new LfLoadModel.ExpTerm(zipLoadModel.getC0q(), 0.0), new LfLoadModel.ExpTerm(zipLoadModel.getC1q(), 1.0), new LfLoadModel.ExpTerm(zipLoadModel.getC2q(), 2.0)));
        }
        if (loadModel.getType() == LoadModelType.EXPONENTIAL) {
            ExponentialLoadModel expoLoadModel = (ExponentialLoadModel)loadModel;
            return new LfLoadModel(List.of(new LfLoadModel.ExpTerm(1.0, expoLoadModel.getNp())), List.of(new LfLoadModel.ExpTerm(1.0, expoLoadModel.getNq())));
        }
        throw new PowsyblException("Unsupported load model: " + loadModel.getType());
    }

    protected LfLoadImpl getOrCreateLfLoad(LoadModel loadModel, LfNetworkParameters parameters) {
        LfLoadModel lfLoadModel = AbstractLfBus.createLfLoadModel(loadModel, parameters);
        return (LfLoadImpl)this.loads.stream().filter(l -> Objects.equals(l.getLoadModel().orElse(null), lfLoadModel)).findFirst().orElseGet(() -> {
            LfLoadImpl l = new LfLoadImpl(this, this.distributedOnConformLoad, lfLoadModel);
            this.loads.add(l);
            return l;
        });
    }

    void addLoad(Load load, LfNetworkParameters parameters) {
        this.getOrCreateLfLoad(load.getModel().orElse(null), parameters).add(load, parameters);
    }

    void addLccConverterStation(LccConverterStation lccCs, LfNetworkParameters parameters) {
        if (!HvdcConverterStations.isHvdcDanglingInIidm(lccCs)) {
            this.getOrCreateLfLoad(null, parameters).add(lccCs, parameters);
        }
    }

    protected void add(LfGenerator generator) {
        this.generators.add(generator);
        generator.setBus(this);
        if (generator.getGeneratorControlType() != LfGenerator.GeneratorControlType.VOLTAGE && !Double.isNaN(generator.getTargetQ())) {
            this.generationTargetQ += generator.getTargetQ();
        }
    }

    void addGenerator(Generator generator, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        this.add(LfGeneratorImpl.create(generator, this.network, parameters, report));
    }

    void addStaticVarCompensator(StaticVarCompensator staticVarCompensator, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        LfStaticVarCompensatorImpl lfSvc = LfStaticVarCompensatorImpl.create(staticVarCompensator, this.network, this, parameters, report);
        this.add(lfSvc);
        if (lfSvc.getSlope() != 0.0) {
            this.hasGeneratorsWithSlope = true;
        }
        if (lfSvc.getB0() != 0.0) {
            this.svcShunt = LfStandbyAutomatonShunt.create(lfSvc);
            lfSvc.setStandByAutomatonShunt(this.svcShunt);
        }
    }

    void addVscConverterStation(VscConverterStation vscCs, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        this.add(LfVscConverterStationImpl.create(vscCs, this.network, parameters, report));
    }

    void addBattery(Battery generator, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        this.add(LfBatteryImpl.create(generator, this.network, parameters, report));
    }

    void setShuntCompensators(List<ShuntCompensator> shuntCompensators, LfNetworkParameters parameters, LfTopoConfig topoConfig, LfNetworkLoadingReport report) {
        if (!parameters.isShuntVoltageControl() && !shuntCompensators.isEmpty()) {
            this.shunt = new LfShuntImpl(shuntCompensators, this.network, this, false, parameters, topoConfig);
        } else {
            ArrayList<ShuntCompensator> controllerShuntCompensators = new ArrayList<ShuntCompensator>();
            ArrayList<ShuntCompensator> fixedShuntCompensators = new ArrayList<ShuntCompensator>();
            shuntCompensators.forEach(sc -> {
                if (AbstractLfBus.checkVoltageControl(sc, parameters, report)) {
                    controllerShuntCompensators.add((ShuntCompensator)sc);
                } else {
                    fixedShuntCompensators.add((ShuntCompensator)sc);
                }
            });
            if (!controllerShuntCompensators.isEmpty()) {
                this.controllerShunt = new LfShuntImpl(controllerShuntCompensators, this.network, this, true, parameters, topoConfig);
            }
            if (!fixedShuntCompensators.isEmpty()) {
                this.shunt = new LfShuntImpl(fixedShuntCompensators, this.network, this, false, parameters, topoConfig);
            }
        }
    }

    static boolean checkVoltageControl(ShuntCompensator shuntCompensator, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        double nominalV = shuntCompensator.getRegulatingTerminal().getVoltageLevel().getNominalV();
        double targetV = shuntCompensator.getTargetV();
        if (!shuntCompensator.isVoltageRegulatorOn()) {
            return false;
        }
        if (!VoltageControl.checkTargetV(targetV / nominalV, nominalV, parameters)) {
            LOGGER.trace("Shunt compensator '{}' has an inconsistent target voltage: {} pu: shunt voltage control discarded", (Object)shuntCompensator.getId(), (Object)targetV);
            if (report != null) {
                ++report.shuntsWithInconsistentTargetVoltage;
            }
            return false;
        }
        return true;
    }

    @Override
    public void invalidateGenerationTargetP() {
        this.generationTargetP = null;
    }

    @Override
    public double getGenerationTargetP() {
        if (this.generationTargetP == null) {
            this.generationTargetP = 0.0;
            for (LfGenerator generator : this.generators) {
                this.generationTargetP = this.generationTargetP + generator.getTargetP();
            }
        }
        return this.generationTargetP;
    }

    @Override
    public double getGenerationTargetQ() {
        return this.generationTargetQ;
    }

    @Override
    public void setGenerationTargetQ(double generationTargetQ) {
        if (generationTargetQ != this.generationTargetQ) {
            double oldGenerationTargetQ = this.generationTargetQ;
            this.generationTargetQ = generationTargetQ;
            for (LfNetworkListener listener : this.network.getListeners()) {
                listener.onGenerationReactivePowerTargetChange(this, oldGenerationTargetQ, generationTargetQ);
            }
        }
    }

    @Override
    public void invalidateLoadTargetP() {
        this.loadTargetP = null;
    }

    @Override
    public double getLoadTargetP() {
        if (this.loadTargetP == null) {
            this.loadTargetP = 0.0;
            for (LfLoad load : this.loads) {
                this.loadTargetP = this.loadTargetP + load.getTargetP() * load.getLoadModel().flatMap(lm -> lm.getExpTermP(0.0).map(LfLoadModel.ExpTerm::c)).orElse(1.0);
            }
        }
        return this.loadTargetP;
    }

    @Override
    public double getNonFictitiousLoadTargetP() {
        return this.loads.stream().mapToDouble(load -> load.getNonFictitiousLoadTargetP() * load.getLoadModel().flatMap(lm -> lm.getExpTermP(0.0).map(LfLoadModel.ExpTerm::c)).orElse(1.0)).sum();
    }

    @Override
    public void invalidateLoadTargetQ() {
        this.loadTargetQ = null;
    }

    @Override
    public double getLoadTargetQ() {
        if (this.loadTargetQ == null) {
            double sum = 0.0;
            for (LfLoad load : this.loads) {
                sum += load.getTargetQ() * load.getLoadModel().flatMap(lm -> lm.getExpTermQ(0.0).map(LfLoadModel.ExpTerm::c)).orElse(1.0);
            }
            this.loadTargetQ = sum;
        }
        return this.loadTargetQ;
    }

    @Override
    public double getMaxP() {
        return this.generators.stream().mapToDouble(LfGenerator::getMaxTargetP).sum();
    }

    private double getLimitQ(ToDoubleFunction<LfGenerator> limitQ) {
        return this.generators.stream().filter(g -> !g.isDisabled()).mapToDouble(generator -> generator.getGeneratorControlType() == LfGenerator.GeneratorControlType.VOLTAGE || generator.getGeneratorControlType() == LfGenerator.GeneratorControlType.REMOTE_REACTIVE_POWER ? limitQ.applyAsDouble((LfGenerator)generator) : generator.getTargetQ()).sum();
    }

    @Override
    public double getMinQ() {
        return this.getLimitQ(LfGenerator::getMinQ);
    }

    @Override
    public double getMaxQ() {
        return this.getLimitQ(LfGenerator::getMaxQ);
    }

    @Override
    public Optional<LfBus.QLimitType> getQLimitType() {
        return Optional.ofNullable(this.qLimitType);
    }

    @Override
    public void setQLimitType(LfBus.QLimitType qLimitType) {
        this.qLimitType = qLimitType;
    }

    @Override
    public double getV() {
        return this.v / this.getNominalV();
    }

    @Override
    public void setV(double v) {
        this.v = v * this.getNominalV();
    }

    @Override
    public Evaluable getCalculatedV() {
        return this.calculatedV;
    }

    @Override
    public void setCalculatedV(Evaluable calculatedV) {
        this.calculatedV = Objects.requireNonNull(calculatedV);
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Override
    public void setAngle(double angle) {
        this.angle = angle;
    }

    @Override
    public Optional<LfShunt> getShunt() {
        return Optional.ofNullable(this.shunt);
    }

    @Override
    public Optional<LfShunt> getControllerShunt() {
        return Optional.ofNullable(this.controllerShunt);
    }

    @Override
    public Optional<LfShunt> getSvcShunt() {
        return Optional.ofNullable(this.svcShunt);
    }

    @Override
    public List<LfGenerator> getGenerators() {
        return this.generators;
    }

    @Override
    public List<LfLoad> getLoads() {
        return this.loads;
    }

    @Override
    public List<LfBranch> getBranches() {
        return this.branches;
    }

    @Override
    public void addBranch(LfBranch branch) {
        this.branches.add(Objects.requireNonNull(branch));
    }

    @Override
    public List<LfHvdc> getHvdcs() {
        return this.hvdcs;
    }

    @Override
    public void addHvdc(LfHvdc hvdc) {
        this.hvdcs.add(Objects.requireNonNull(hvdc));
    }

    private static ToDoubleFunction<String> splitDispatchQ(List<LfGenerator> generatorsWithControl, double qToDispatch) {
        return AbstractLfBus.splitDispatchQWithReactiveKeys(generatorsWithControl, qToDispatch).orElse(AbstractLfBus.splitDispatchQFromMaxReactivePowerRange(generatorsWithControl, qToDispatch).orElse(AbstractLfBus.splitDispatchQEqually(generatorsWithControl, qToDispatch)));
    }

    private static ToDoubleFunction<String> splitDispatchQEqually(List<LfGenerator> generatorsWithControl, double qToDispatch) {
        int size = generatorsWithControl.size();
        return id -> qToDispatch / (double)size;
    }

    private static ToDoubleFunction<String> splitDispatchQWithEqualProportionOfK(List<LfGenerator> generatorsWithControl, double qToDispatch) {
        double k = 2.0 * qToDispatch;
        double denom = 0.0;
        for (LfGenerator generator : generatorsWithControl) {
            k -= generator.getMaxQ() + generator.getMinQ();
            denom += generator.getMaxQ() - generator.getMinQ();
        }
        if (denom != 0.0) {
            k /= denom;
        }
        HashMap<String, Double> qToDispatchByGeneratorId = new HashMap<String, Double>(generatorsWithControl.size());
        for (LfGenerator generator : generatorsWithControl) {
            qToDispatchByGeneratorId.put(generator.getId(), LfGenerator.kToQ(k, generator));
        }
        return qToDispatchByGeneratorId::get;
    }

    private static Optional<ToDoubleFunction<String>> splitDispatchQWithReactiveKeys(List<LfGenerator> generatorsWithControl, double qToDispatch) {
        double sumQkeys = 0.0;
        for (LfGenerator generator : generatorsWithControl) {
            double qKey = generator.getRemoteControlReactiveKey().orElse(Double.NaN);
            sumQkeys += qKey;
        }
        if (Double.isNaN(sumQkeys) || sumQkeys == 0.0) {
            return Optional.empty();
        }
        HashMap<String, Double> qToDispatchByGeneratorId = new HashMap<String, Double>(generatorsWithControl.size());
        for (LfGenerator generator : generatorsWithControl) {
            double qKey = generator.getRemoteControlReactiveKey().orElseThrow();
            qToDispatchByGeneratorId.put(generator.getId(), qKey / sumQkeys * qToDispatch);
        }
        return Optional.of(qToDispatchByGeneratorId::get);
    }

    private static Optional<ToDoubleFunction<String>> splitDispatchQFromMaxReactivePowerRange(List<LfGenerator> generatorsWithControl, double qToDispatch) {
        double sumMaxRanges = 0.0;
        for (LfGenerator generator : generatorsWithControl) {
            if (!AbstractLfBus.generatorHasPlausibleReactiveLimits(generator)) {
                return Optional.empty();
            }
            double maxRangeQ = generator.getRangeQ(LfGenerator.ReactiveRangeMode.MAX);
            sumMaxRanges += maxRangeQ;
        }
        if (sumMaxRanges == 0.0) {
            return Optional.empty();
        }
        HashMap<String, Double> qToDispatchByGeneratorId = new HashMap<String, Double>(generatorsWithControl.size());
        for (LfGenerator generator : generatorsWithControl) {
            double maxRangeQ = generator.getRangeQ(LfGenerator.ReactiveRangeMode.MAX);
            qToDispatchByGeneratorId.put(generator.getId(), maxRangeQ / sumMaxRanges * qToDispatch);
        }
        return Optional.of(qToDispatchByGeneratorId::get);
    }

    private static boolean generatorHasPlausibleReactiveLimits(LfGenerator generator) {
        double minQ = generator.getMinQ();
        double maxQ = generator.getMaxQ();
        double rangeQ = maxQ - minQ;
        return Math.abs(minQ) < 10.0 && Math.abs(maxQ) < 10.0 && rangeQ > 0.01 && rangeQ < 100.0;
    }

    private static boolean allGeneratorsHavePlausibleReactiveLimits(List<LfGenerator> generators) {
        return generators.stream().allMatch(AbstractLfBus::generatorHasPlausibleReactiveLimits);
    }

    protected static double dispatchQ(List<LfGenerator> generatorsWithControl, boolean reactiveLimits, ReactivePowerDispatchMode reactivePowerDispatchMode, double qToDispatch) {
        double residueQ = 0.0;
        if (generatorsWithControl.isEmpty()) {
            throw new IllegalArgumentException("the generator list to dispatch Q can not be empty");
        }
        ToDoubleFunction<String> qToDispatchByGeneratorId = switch (reactivePowerDispatchMode) {
            default -> throw new IncompatibleClassChangeError();
            case ReactivePowerDispatchMode.Q_EQUAL_PROPORTION -> AbstractLfBus.splitDispatchQ(generatorsWithControl, qToDispatch);
            case ReactivePowerDispatchMode.K_EQUAL_PROPORTION -> AbstractLfBus.allGeneratorsHavePlausibleReactiveLimits(generatorsWithControl) ? AbstractLfBus.splitDispatchQWithEqualProportionOfK(generatorsWithControl, qToDispatch) : AbstractLfBus.splitDispatchQEqually(generatorsWithControl, qToDispatch);
        };
        Iterator<LfGenerator> itG = generatorsWithControl.iterator();
        while (itG.hasNext()) {
            LfGenerator generator = itG.next();
            double generatorAlreadyCalculatedQ = generator.getCalculatedQ();
            double qToDispatchForThisGenerator = qToDispatchByGeneratorId.applyAsDouble(generator.getId());
            if (reactiveLimits && qToDispatchForThisGenerator + generatorAlreadyCalculatedQ < generator.getMinQ()) {
                residueQ += qToDispatchForThisGenerator + generatorAlreadyCalculatedQ - generator.getMinQ();
                generator.setCalculatedQ(generator.getMinQ());
                itG.remove();
                continue;
            }
            if (reactiveLimits && qToDispatchForThisGenerator + generatorAlreadyCalculatedQ > generator.getMaxQ()) {
                residueQ += qToDispatchForThisGenerator + generatorAlreadyCalculatedQ - generator.getMaxQ();
                generator.setCalculatedQ(generator.getMaxQ());
                itG.remove();
                continue;
            }
            generator.setCalculatedQ(generatorAlreadyCalculatedQ + qToDispatchForThisGenerator);
        }
        return residueQ;
    }

    void updateGeneratorsState(double generationQ, boolean reactiveLimits, ReactivePowerDispatchMode reactivePowerDispatchMode) {
        double qToDispatch = generationQ;
        LinkedList<LfGenerator> generatorsThatControlVoltage = new LinkedList<LfGenerator>();
        LinkedList<LfGenerator> generatorsThatControlReactivePower = new LinkedList<LfGenerator>();
        for (LfGenerator generator : this.generators) {
            if (generator.getGeneratorControlType() == LfGenerator.GeneratorControlType.VOLTAGE) {
                generatorsThatControlVoltage.add(generator);
                continue;
            }
            if (generator.getGeneratorControlType() == LfGenerator.GeneratorControlType.REMOTE_REACTIVE_POWER) {
                generatorsThatControlReactivePower.add(generator);
                continue;
            }
            qToDispatch -= generator.getTargetQ();
        }
        LinkedList<LfGenerator> initialGeneratorsThatControlVoltage = new LinkedList<LfGenerator>(generatorsThatControlVoltage);
        for (LfGenerator generator : generatorsThatControlVoltage) {
            generator.setCalculatedQ(0.0);
        }
        while (!generatorsThatControlVoltage.isEmpty() && Math.abs(qToDispatch) > 0.001) {
            qToDispatch = AbstractLfBus.dispatchQ(generatorsThatControlVoltage, reactiveLimits, reactivePowerDispatchMode, qToDispatch);
        }
        if (!initialGeneratorsThatControlVoltage.isEmpty() && Math.abs(qToDispatch) > 0.001) {
            AbstractLfBus.dispatchQ(initialGeneratorsThatControlVoltage, false, reactivePowerDispatchMode, qToDispatch);
        }
        for (LfGenerator generator : generatorsThatControlReactivePower) {
            generator.setCalculatedQ(0.0);
        }
        while (!generatorsThatControlReactivePower.isEmpty() && Math.abs(qToDispatch) > 0.001) {
            qToDispatch = AbstractLfBus.dispatchQ(generatorsThatControlReactivePower, reactiveLimits, reactivePowerDispatchMode, qToDispatch);
        }
    }

    @Override
    public void updateState(LfNetworkStateUpdateParameters parameters) {
        this.updateGeneratorsState(this.generatorVoltageControlEnabled || this.generatorReactivePowerControlEnabled ? this.q.eval() + this.getLoadTargetQ() : this.generationTargetQ, parameters.isReactiveLimits(), parameters.getReactivePowerDispatchMode());
        for (LfLoad load : this.loads) {
            load.updateState(parameters.isLoadPowerFactorConstant(), parameters.isBreakers());
        }
    }

    @Override
    public Optional<TransformerVoltageControl> getTransformerVoltageControl() {
        return Optional.ofNullable(this.transformerVoltageControl);
    }

    @Override
    public boolean isTransformerVoltageControlled() {
        return this.transformerVoltageControl != null && this.transformerVoltageControl.getControlledBus() == this;
    }

    @Override
    public void setTransformerVoltageControl(TransformerVoltageControl transformerVoltageControl) {
        this.transformerVoltageControl = transformerVoltageControl;
    }

    @Override
    public Optional<ShuntVoltageControl> getShuntVoltageControl() {
        return Optional.ofNullable(this.shuntVoltageControl);
    }

    @Override
    public boolean isShuntVoltageControlled() {
        return this.shuntVoltageControl != null && this.shuntVoltageControl.getControlledBus() == this;
    }

    @Override
    public void setShuntVoltageControl(ShuntVoltageControl shuntVoltageControl) {
        this.shuntVoltageControl = shuntVoltageControl;
    }

    @Override
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        if (this.shunt != null) {
            this.shunt.setDisabled(disabled);
        }
        if (this.controllerShunt != null) {
            this.controllerShunt.setDisabled(disabled);
        }
        for (LfHvdc hvdc : this.hvdcs) {
            if (disabled) {
                hvdc.setDisabled(true);
                continue;
            }
            if (hvdc.getOtherBus(this).isDisabled()) continue;
            hvdc.setDisabled(false);
        }
    }

    @Override
    public void setP(Evaluable p) {
        this.p = Objects.requireNonNull(p);
    }

    @Override
    public Evaluable getP() {
        return this.p;
    }

    @Override
    public void setQ(Evaluable q) {
        this.q = Objects.requireNonNull(q);
    }

    @Override
    public Evaluable getQ() {
        return this.q;
    }

    @Override
    public Map<LfBus, List<LfBranch>> findNeighbors() {
        LinkedHashMap<LfBus, List<LfBranch>> neighbors = new LinkedHashMap<LfBus, List<LfBranch>>(this.branches.size());
        for (LfBranch branch : this.branches) {
            if (!branch.isConnectedAtBothSides()) continue;
            LfBus otherBus = branch.getBus1() == this ? branch.getBus2() : branch.getBus1();
            neighbors.computeIfAbsent(otherBus, k -> new ArrayList()).add(branch);
        }
        return neighbors;
    }

    @Override
    public double getRemoteControlReactivePercent() {
        return this.remoteControlReactivePercent;
    }

    @Override
    public void setRemoteControlReactivePercent(double remoteControlReactivePercent) {
        this.remoteControlReactivePercent = remoteControlReactivePercent;
    }

    @Override
    public double getMismatchP() {
        return this.p.eval() - this.getTargetP();
    }

    @Override
    public void setZeroImpedanceNetwork(LoadFlowModel loadFlowModel, LfZeroImpedanceNetwork zeroImpedanceNetwork) {
        Objects.requireNonNull(zeroImpedanceNetwork);
        this.zeroImpedanceNetwork.put(loadFlowModel, zeroImpedanceNetwork);
    }

    @Override
    public LfZeroImpedanceNetwork getZeroImpedanceNetwork(LoadFlowModel loadFlowModel) {
        return this.zeroImpedanceNetwork.get((Object)loadFlowModel);
    }

    @Override
    public LfAsymBus getAsym() {
        return this.asym;
    }

    @Override
    public void setAsym(LfAsymBus asym) {
        this.asym = asym;
        asym.setBus(this);
    }

    @Override
    public Optional<LfArea> getArea() {
        return Optional.ofNullable(this.area);
    }

    @Override
    public void setArea(LfArea area) {
        this.area = area;
    }
}

