/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.math.graph.TraverseResult;
import com.powsybl.openloadflow.network.impl.NodeBreakerTraverser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ContingencyTripping {
    private static final ContingencyTripping NO_OP_TRIPPING = new ContingencyTripping(Collections.emptyList(), (s, tt, nt, nbv) -> null);
    private final List<? extends Terminal> terminals;
    private final NodeBreakerTraverserFactory nodeBreakerTraverserFactory;

    public ContingencyTripping(List<? extends Terminal> terminals, NodeBreakerTraverserFactory nodeBreakerTraverserFactory) {
        this.terminals = terminals;
        this.nodeBreakerTraverserFactory = nodeBreakerTraverserFactory;
    }

    public ContingencyTripping(Terminal terminal, NodeBreakerTraverserFactory nodeBreakerTraverserFactory) {
        this(List.of(terminal), nodeBreakerTraverserFactory);
    }

    public static ContingencyTripping createBranchTripping(Network network, Branch<?> branch) {
        return ContingencyTripping.createBranchTripping(network, branch, null);
    }

    public static ContingencyTripping createBranchTripping(Network network, Branch<?> branch, String voltageLevelId) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(branch);
        if (voltageLevelId != null) {
            if (voltageLevelId.equals(branch.getTerminal1().getVoltageLevel().getId())) {
                return new ContingencyTripping(branch.getTerminal1(), NodeBreakerTraverser::new);
            }
            if (voltageLevelId.equals(branch.getTerminal2().getVoltageLevel().getId())) {
                return new ContingencyTripping(branch.getTerminal2(), NodeBreakerTraverser::new);
            }
            throw new PowsyblException("VoltageLevel '" + voltageLevelId + "' not connected to branch '" + branch.getId() + "'");
        }
        return new ContingencyTripping(List.of(branch.getTerminal1(), branch.getTerminal2()), NodeBreakerTraverser::new);
    }

    public static ContingencyTripping createInjectionTripping(Network network, Injection<?> injection) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(injection);
        return new ContingencyTripping(injection.getTerminal(), NodeBreakerTraverser::new);
    }

    public static ContingencyTripping createThreeWindingsTransformerTripping(Network network, ThreeWindingsTransformer twt) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(twt);
        return new ContingencyTripping(twt.getTerminals(), NodeBreakerTraverser::new);
    }

    public static ContingencyTripping createBusbarSectionMinimalTripping(Network network, BusbarSection bbs) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(bbs);
        NodeBreakerTraverserFactory minimalTraverserFactory = (stoppingSwitches, traversedTerminals, neighbourTerminals, nbv) -> (nodeBefore, sw, nodeAfter) -> {
            if (sw != null) {
                if (!sw.isOpen()) {
                    stoppingSwitches.add(sw);
                }
                return TraverseResult.TERMINATE_PATH;
            }
            nbv.getOptionalTerminal(nodeAfter).ifPresent(traversedTerminals::add);
            return TraverseResult.CONTINUE;
        };
        return new ContingencyTripping(bbs.getTerminal(), minimalTraverserFactory);
    }

    public static ContingencyTripping createContingencyTripping(Network network, Identifiable<?> identifiable) {
        switch (identifiable.getType()) {
            case LINE: 
            case TWO_WINDINGS_TRANSFORMER: 
            case TIE_LINE: {
                return ContingencyTripping.createBranchTripping(network, (Branch)identifiable);
            }
            case DANGLING_LINE: 
            case GENERATOR: 
            case LOAD: 
            case SHUNT_COMPENSATOR: 
            case STATIC_VAR_COMPENSATOR: 
            case BUSBAR_SECTION: 
            case BATTERY: {
                return ContingencyTripping.createInjectionTripping(network, (Injection)identifiable);
            }
            case THREE_WINDINGS_TRANSFORMER: {
                return ContingencyTripping.createThreeWindingsTransformerTripping(network, (ThreeWindingsTransformer)identifiable);
            }
            case HVDC_LINE: 
            case SWITCH: {
                return NO_OP_TRIPPING;
            }
        }
        throw new UnsupportedOperationException("Unsupported contingency element type: " + identifiable.getType());
    }

    public void traverse(Set<Switch> switchesToOpen, Set<Terminal> terminalsToDisconnect) {
        HashSet traversedTerminals = new HashSet();
        this.terminals.forEach(t -> this.traverseFromTerminal((Terminal)t, switchesToOpen, traversedTerminals));
        terminalsToDisconnect.addAll(traversedTerminals);
    }

    private void traverseFromTerminal(Terminal terminal, Set<Switch> switchesToOpen, Set<Terminal> traversedTerminals) {
        Objects.requireNonNull(terminal);
        Objects.requireNonNull(switchesToOpen);
        Objects.requireNonNull(traversedTerminals);
        if (traversedTerminals.contains(terminal)) {
            return;
        }
        if (terminal.getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER) {
            traversedTerminals.add(terminal);
            List<Terminal> neighbourTerminals = this.traverseNodeBreakerVoltageLevelsFromTerminal(terminal, switchesToOpen, traversedTerminals);
            neighbourTerminals.forEach(t -> this.traverseFromTerminal((Terminal)t, switchesToOpen, traversedTerminals));
        } else if (terminal.isConnected()) {
            traversedTerminals.add(terminal);
        }
    }

    private List<Terminal> traverseNodeBreakerVoltageLevelsFromTerminal(Terminal terminal, Set<Switch> switchesToOpen, Set<Terminal> traversedTerminals) {
        int initNode = terminal.getNodeBreakerView().getNode();
        VoltageLevel.NodeBreakerView nodeBreakerView = terminal.getVoltageLevel().getNodeBreakerView();
        ArrayList<Terminal> neighbourTerminals = new ArrayList<Terminal>();
        VoltageLevel.NodeBreakerView.TopologyTraverser traverser = this.nodeBreakerTraverserFactory.create(switchesToOpen, traversedTerminals, neighbourTerminals, nodeBreakerView);
        nodeBreakerView.traverse(initNode, traverser);
        return neighbourTerminals;
    }

    @FunctionalInterface
    private static interface NodeBreakerTraverserFactory {
        public VoltageLevel.NodeBreakerView.TopologyTraverser create(Set<Switch> var1, Set<Terminal> var2, List<Terminal> var3, VoltageLevel.NodeBreakerView var4);
    }
}

