/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.util.HvdcUtils;
import com.powsybl.openloadflow.network.impl.LfLoadImpl;
import java.util.Objects;
import java.util.Optional;

public final class HvdcConverterStations {
    private HvdcConverterStations() {
    }

    public static double getActivePowerSetpointMultiplier(HvdcConverterStation<?> station) {
        boolean isConverterStationRectifier = HvdcUtils.isRectifier(station);
        Optional otherStation = station.getOtherConverterStation();
        if (otherStation.isPresent()) {
            if (isConverterStationRectifier) {
                return -1.0;
            }
            return 1.0f - (station.getLossFactor() + ((HvdcConverterStation)otherStation.get()).getLossFactor()) / 100.0f;
        }
        return 0.0;
    }

    public static boolean isVsc(Identifiable<?> identifiable) {
        Objects.requireNonNull(identifiable);
        return identifiable.getType() == IdentifiableType.HVDC_CONVERTER_STATION && ((HvdcConverterStation)identifiable).getHvdcType() == HvdcConverterStation.HvdcType.VSC;
    }

    public static boolean isHvdcDanglingInIidm(HvdcConverterStation<?> station) {
        if (HvdcConverterStations.isIsolated(station.getTerminal())) {
            return true;
        }
        return station.getOtherConverterStation().map(otherConverterStation -> {
            Terminal otherTerminal = otherConverterStation.getTerminal();
            return HvdcConverterStations.isIsolated(otherTerminal);
        }).orElse(true);
    }

    private static boolean isIsolated(Terminal terminal) {
        Bus bus = terminal.getBusView().getBus();
        if (bus == null) {
            return true;
        }
        return bus.getConnectedTerminalStream().map(Terminal::getConnectable).noneMatch(c -> !(c instanceof HvdcConverterStation) && !(c instanceof BusbarSection) && !HvdcConverterStations.isFictitiousLoad(c));
    }

    private static boolean isFictitiousLoad(Connectable<?> c) {
        Load load;
        return c instanceof Load && LfLoadImpl.isLoadFictitious(load = (Load)c);
    }
}

