/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.util.SV;
import com.powsybl.openloadflow.network.AbstractElement;
import com.powsybl.openloadflow.network.ElementType;
import com.powsybl.openloadflow.network.LfArea;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.impl.LfTieLineBranch;
import com.powsybl.openloadflow.network.impl.Ref;
import java.util.Objects;
import java.util.Set;

public class LfAreaImpl
extends AbstractElement
implements LfArea {
    private final Ref<Area> areaRef;
    private double interchangeTarget;
    private final Set<LfBus> buses;
    private final Set<LfArea.Boundary> boundaries;

    protected LfAreaImpl(Area area, Set<LfBus> buses, Set<LfArea.Boundary> boundaries, LfNetwork lfNetwork, LfNetworkParameters parameters) {
        super(lfNetwork);
        this.areaRef = Ref.create(area, parameters.isCacheEnabled());
        this.interchangeTarget = area.getInterchangeTarget().orElse(0.0) / 100.0;
        this.buses = buses;
        this.boundaries = boundaries;
    }

    public static LfAreaImpl create(Area area, Set<LfBus> buses, Set<LfArea.Boundary> boundaries, LfNetwork network, LfNetworkParameters parameters) {
        LfAreaImpl lfArea = new LfAreaImpl(area, buses, boundaries, network, parameters);
        lfArea.getBuses().forEach(bus -> bus.setArea(lfArea));
        return lfArea;
    }

    private Area getArea() {
        return this.areaRef.get();
    }

    @Override
    public String getId() {
        return this.getArea().getId();
    }

    @Override
    public ElementType getType() {
        return ElementType.AREA;
    }

    @Override
    public double getInterchangeTarget() {
        return this.interchangeTarget;
    }

    @Override
    public void setInterchangeTarget(double interchangeTarget) {
        this.interchangeTarget = interchangeTarget;
    }

    @Override
    public double getInterchange() {
        return this.boundaries.stream().mapToDouble(LfArea.Boundary::getP).sum();
    }

    @Override
    public Set<LfBus> getBuses() {
        return this.buses;
    }

    @Override
    public Set<LfArea.Boundary> getBoundaries() {
        return this.boundaries;
    }

    public static class BoundaryImpl
    implements LfArea.Boundary {
        private final LfBranch branch;
        private final TwoSides side;

        public BoundaryImpl(LfBranch branch, TwoSides side) {
            this.branch = Objects.requireNonNull(branch);
            this.side = Objects.requireNonNull(side);
        }

        @Override
        public LfBranch getBranch() {
            return this.branch;
        }

        @Override
        public double getP() {
            if (this.branch.isDisabled()) {
                return 0.0;
            }
            LfBranch lfBranch = this.branch;
            if (lfBranch instanceof LfTieLineBranch) {
                LfTieLineBranch lfTieLineBranch = (LfTieLineBranch)lfBranch;
                if (this.side == TwoSides.ONE) {
                    DanglingLine danglingLine1 = lfTieLineBranch.getHalf1();
                    double nominalV1 = danglingLine1.getTerminal().getVoltageLevel().getNominalV();
                    return new SV(lfTieLineBranch.getP1().eval() * 100.0, lfTieLineBranch.getQ1().eval() * 100.0, lfTieLineBranch.getV1() * nominalV1, Math.toDegrees(lfTieLineBranch.getAngle1()), this.side).otherSideP(danglingLine1, false) / 100.0;
                }
                if (this.side == TwoSides.TWO) {
                    DanglingLine danglingLine = lfTieLineBranch.getHalf2();
                    double nominalV2 = danglingLine.getTerminal().getVoltageLevel().getNominalV();
                    return new SV(lfTieLineBranch.getP2().eval() * 100.0, lfTieLineBranch.getQ2().eval() * 100.0, lfTieLineBranch.getV2() * nominalV2, Math.toDegrees(lfTieLineBranch.getAngle2()), this.side).otherSideP(danglingLine, false) / 100.0;
                }
            }
            return switch (this.side) {
                default -> throw new IncompatibleClassChangeError();
                case TwoSides.ONE -> this.branch.getP1().eval();
                case TwoSides.TWO -> this.branch.getP2().eval();
            };
        }
    }
}

