/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.extensions.LineFortescue;
import com.powsybl.openloadflow.network.LfAsymLine;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.LfNetworkUpdateReport;
import com.powsybl.openloadflow.network.LfTopoConfig;
import com.powsybl.openloadflow.network.LinePerUnitMode;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.PiModelArray;
import com.powsybl.openloadflow.network.SimplePiModel;
import com.powsybl.openloadflow.network.impl.AbstractImpedantLfBranch;
import com.powsybl.openloadflow.network.impl.OlfBranchResult;
import com.powsybl.openloadflow.network.impl.Ref;
import com.powsybl.openloadflow.network.impl.Transformers;
import com.powsybl.openloadflow.sa.LimitReductionManager;
import com.powsybl.openloadflow.util.PerUnit;
import com.powsybl.security.results.BranchResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LfBranchImpl
extends AbstractImpedantLfBranch {
    private static final Logger LOGGER = LoggerFactory.getLogger(LfBranchImpl.class);
    private final Ref<Branch<?>> branchRef;

    protected LfBranchImpl(LfNetwork network, LfBus bus1, LfBus bus2, PiModel piModel, Branch<?> branch, LfNetworkParameters parameters) {
        super(network, bus1, bus2, piModel, parameters);
        this.branchRef = Ref.create(branch, parameters.isCacheEnabled());
    }

    private static void createLineAsym(Line line, double zb, PiModel piModel, LfBranchImpl lfBranch) {
        LineFortescue extension = (LineFortescue)line.getExtension(LineFortescue.class);
        if (extension != null) {
            boolean openPhaseA = extension.isOpenPhaseA();
            boolean openPhaseB = extension.isOpenPhaseB();
            boolean openPhaseC = extension.isOpenPhaseC();
            double rz = extension.getRz();
            double xz = extension.getXz();
            SimplePiModel piZeroComponent = new SimplePiModel().setR(rz / zb).setX(xz / zb);
            SimplePiModel piPositiveComponent = new SimplePiModel().setR(piModel.getR()).setX(piModel.getX());
            SimplePiModel piNegativeComponent = new SimplePiModel().setR(piModel.getR()).setX(piModel.getX());
            lfBranch.setAsymLine(new LfAsymLine(piZeroComponent, piPositiveComponent, piNegativeComponent, openPhaseA, openPhaseB, openPhaseC));
        }
    }

    private static LfBranchImpl createLine(Line line, LfNetwork network, LfBus bus1, LfBus bus2, LfNetworkParameters parameters) {
        double b2;
        double b1;
        double g2;
        double g1;
        double x;
        double r;
        double r1;
        double zb;
        if (parameters.getLinePerUnitMode() == LinePerUnitMode.RATIO) {
            double nominalV2 = line.getTerminal2().getVoltageLevel().getNominalV();
            zb = PerUnit.zb(nominalV2);
            r1 = 1.0 / Transformers.getRatioPerUnitBase(line);
            r = line.getR() / zb;
            x = line.getX() / zb;
            g1 = line.getG1() * zb;
            g2 = line.getG2() * zb;
            b1 = line.getB1() * zb;
            b2 = line.getB2() * zb;
        } else {
            r1 = 1.0;
            double zSquare = line.getR() * line.getR() + line.getX() * line.getX();
            if (zSquare == 0.0) {
                r = 0.0;
                x = 0.0;
                g1 = 0.0;
                b1 = 0.0;
                g2 = 0.0;
                b2 = 0.0;
                zb = 0.0;
            } else {
                double nominalV1 = line.getTerminal1().getVoltageLevel().getNominalV();
                double nominalV2 = line.getTerminal2().getVoltageLevel().getNominalV();
                double g = line.getR() / zSquare;
                double b = -line.getX() / zSquare;
                zb = nominalV1 * nominalV2 / 100.0;
                r = line.getR() / zb;
                x = line.getX() / zb;
                g1 = (line.getG1() * nominalV1 * nominalV1 + g * nominalV1 * (nominalV1 - nominalV2)) / 100.0;
                b1 = (line.getB1() * nominalV1 * nominalV1 + b * nominalV1 * (nominalV1 - nominalV2)) / 100.0;
                g2 = (line.getG2() * nominalV2 * nominalV2 + g * nominalV2 * (nominalV2 - nominalV1)) / 100.0;
                b2 = (line.getB2() * nominalV2 * nominalV2 + b * nominalV2 * (nominalV2 - nominalV1)) / 100.0;
            }
        }
        SimplePiModel piModel = new SimplePiModel().setR1(r1).setR(r).setX(x).setG1(g1).setG2(g2).setB1(b1).setB2(b2);
        LfBranchImpl lfBranch = new LfBranchImpl(network, bus1, bus2, piModel, (Branch<?>)line, parameters);
        if (parameters.isAsymmetrical()) {
            LfBranchImpl.createLineAsym(line, zb, piModel, lfBranch);
        }
        return lfBranch;
    }

    private static LfBranchImpl createTransformer(TwoWindingsTransformer twt, LfNetwork network, LfBus bus1, LfBus bus2, boolean retainPtc, boolean retainRtc, LfNetworkParameters parameters) {
        RatioTapChanger rtc;
        PiModel piModel = null;
        double baseRatio = Transformers.getRatioPerUnitBase(twt);
        double nominalV2 = twt.getTerminal2().getVoltageLevel().getNominalV();
        double zb = PerUnit.zb(nominalV2);
        PhaseTapChanger ptc = twt.getPhaseTapChanger();
        if (ptc != null && (ptc.isRegulating() || retainPtc)) {
            Integer rtcPosition = Transformers.getCurrentPosition(twt.getRatioTapChanger());
            ArrayList<PiModel> models = new ArrayList<PiModel>();
            for (int ptcPosition = ptc.getLowTapPosition(); ptcPosition <= ptc.getHighTapPosition(); ++ptcPosition) {
                Transformers.TapCharacteristics tapCharacteristics = Transformers.getTapCharacteristics(twt, rtcPosition, ptcPosition);
                models.add(Transformers.createPiModel(tapCharacteristics, zb, baseRatio, parameters.isTwtSplitShuntAdmittance()));
            }
            piModel = new PiModelArray(models, ptc.getLowTapPosition(), ptc.getTapPosition());
        }
        if ((rtc = twt.getRatioTapChanger()) != null && (rtc.isRegulating() && rtc.hasLoadTapChangingCapabilities() || retainRtc)) {
            if (piModel == null) {
                Integer ptcPosition = Transformers.getCurrentPosition(twt.getPhaseTapChanger());
                ArrayList<PiModel> models = new ArrayList<PiModel>();
                for (int rtcPosition = rtc.getLowTapPosition(); rtcPosition <= rtc.getHighTapPosition(); ++rtcPosition) {
                    Transformers.TapCharacteristics tapCharacteristics = Transformers.getTapCharacteristics(twt, rtcPosition, ptcPosition);
                    models.add(Transformers.createPiModel(tapCharacteristics, zb, baseRatio, parameters.isTwtSplitShuntAdmittance()));
                }
                piModel = new PiModelArray(models, rtc.getLowTapPosition(), rtc.getTapPosition());
            } else {
                throw new PowsyblException("Voltage and phase control on same branch '" + twt.getId() + "' is not yet supported");
            }
        }
        if (piModel == null) {
            Transformers.TapCharacteristics tapCharacteristics = Transformers.getTapCharacteristics(twt);
            piModel = Transformers.createPiModel(tapCharacteristics, zb, baseRatio, parameters.isTwtSplitShuntAdmittance());
        }
        return new LfBranchImpl(network, bus1, bus2, piModel, (Branch<?>)twt, parameters);
    }

    public static LfBranchImpl create(Branch<?> branch, LfNetwork network, LfBus bus1, LfBus bus2, LfTopoConfig topoConfig, LfNetworkParameters parameters) {
        LfBranchImpl lfBranch;
        Objects.requireNonNull(branch);
        Objects.requireNonNull(network);
        Objects.requireNonNull(topoConfig);
        Objects.requireNonNull(parameters);
        if (branch instanceof Line) {
            Line line = (Line)branch;
            lfBranch = LfBranchImpl.createLine(line, network, bus1, bus2, parameters);
        } else if (branch instanceof TwoWindingsTransformer) {
            TwoWindingsTransformer twt = (TwoWindingsTransformer)branch;
            lfBranch = LfBranchImpl.createTransformer(twt, network, bus1, bus2, topoConfig.isRetainedPtc(twt.getId()), topoConfig.isRetainedRtc(twt.getId()), parameters);
        } else {
            throw new PowsyblException("Unsupported type of branch for flow equations of branch: " + branch.getId());
        }
        if (bus1 != null && topoConfig.getBranchIdsOpenableSide1().contains(lfBranch.getId())) {
            lfBranch.setDisconnectionAllowedSide1(true);
        }
        if (bus2 != null && topoConfig.getBranchIdsOpenableSide2().contains(lfBranch.getId())) {
            lfBranch.setDisconnectionAllowedSide2(true);
        }
        return lfBranch;
    }

    private Branch<?> getBranch() {
        return this.branchRef.get();
    }

    @Override
    public String getId() {
        return this.getBranch().getId();
    }

    @Override
    public LfBranch.BranchType getBranchType() {
        return this.getBranch() instanceof Line ? LfBranch.BranchType.LINE : LfBranch.BranchType.TRANSFO_2;
    }

    @Override
    public boolean hasPhaseControllerCapability() {
        Branch<?> branch = this.getBranch();
        return branch.getType() == IdentifiableType.TWO_WINDINGS_TRANSFORMER && ((TwoWindingsTransformer)branch).getPhaseTapChanger() != null;
    }

    @Override
    public List<BranchResult> createBranchResult(double preContingencyBranchP1, double preContingencyBranchOfContingencyP1, boolean createExtension) {
        Branch<?> branch = this.getBranch();
        double flowTransfer = Double.NaN;
        if (!Double.isNaN(preContingencyBranchP1) && !Double.isNaN(preContingencyBranchOfContingencyP1)) {
            flowTransfer = (this.p1.eval() * 100.0 - preContingencyBranchP1) / preContingencyBranchOfContingencyP1;
        }
        double currentScale1 = PerUnit.ib(branch.getTerminal1().getVoltageLevel().getNominalV());
        double currentScale2 = PerUnit.ib(branch.getTerminal2().getVoltageLevel().getNominalV());
        BranchResult branchResult = new BranchResult(this.getId(), this.p1.eval() * 100.0, this.q1.eval() * 100.0, currentScale1 * this.i1.eval(), this.p2.eval() * 100.0, this.q2.eval() * 100.0, currentScale2 * this.i2.eval(), flowTransfer);
        if (createExtension) {
            branchResult.addExtension(OlfBranchResult.class, (Extension)new OlfBranchResult(this.piModel.getR1(), this.piModel.getContinuousR1(), this.getV1() * branch.getTerminal1().getVoltageLevel().getNominalV(), this.getV2() * branch.getTerminal2().getVoltageLevel().getNominalV(), Math.toDegrees(this.getAngle1()), Math.toDegrees(this.getAngle2())));
        }
        return List.of(branchResult);
    }

    @Override
    public List<LfBranch.LfLimit> getLimits1(LimitType type, LimitReductionManager limitReductionManager) {
        switch (type) {
            case ACTIVE_POWER: {
                return this.getLimits1(type, () -> this.getBranch().getActivePowerLimits1(), limitReductionManager);
            }
            case APPARENT_POWER: {
                return this.getLimits1(type, () -> this.getBranch().getApparentPowerLimits1(), limitReductionManager);
            }
            case CURRENT: {
                return this.getLimits1(type, () -> this.getBranch().getCurrentLimits1(), limitReductionManager);
            }
        }
        throw new UnsupportedOperationException(String.format("Getting %s limits is not supported.", type.name()));
    }

    @Override
    public List<LfBranch.LfLimit> getLimits2(LimitType type, LimitReductionManager limitReductionManager) {
        switch (type) {
            case ACTIVE_POWER: {
                return this.getLimits2(type, () -> this.getBranch().getActivePowerLimits2(), limitReductionManager);
            }
            case APPARENT_POWER: {
                return this.getLimits2(type, () -> this.getBranch().getApparentPowerLimits2(), limitReductionManager);
            }
            case CURRENT: {
                return this.getLimits2(type, () -> this.getBranch().getCurrentLimits2(), limitReductionManager);
            }
        }
        throw new UnsupportedOperationException(String.format("Getting %s limits is not supported.", type.name()));
    }

    @Override
    public double[] getLimitReductions(TwoSides side, LimitReductionManager limitReductionManager, LoadingLimits limits) {
        if (limits == null) {
            return new double[0];
        }
        if (limits.getLimitType() != LimitType.CURRENT) {
            return new double[0];
        }
        if (limitReductionManager == null || limitReductionManager.isEmpty()) {
            return new double[0];
        }
        double[] limitReductions = new double[limits.getTemporaryLimits().size() + 1];
        Arrays.fill(limitReductions, 1.0);
        double nominalV = this.branchRef.get().getTerminal(side).getVoltageLevel().getNominalV();
        for (LimitReductionManager.TerminalLimitReduction terminalLimitReduction : limitReductionManager.getTerminalLimitReductions()) {
            if (!terminalLimitReduction.nominalV().contains((Object)nominalV)) continue;
            if (terminalLimitReduction.isPermanent()) {
                limitReductions[0] = terminalLimitReduction.reduction();
            }
            if (terminalLimitReduction.acceptableDuration() == null) continue;
            int i = 1;
            for (LoadingLimits.TemporaryLimit temporaryLimit : limits.getTemporaryLimits()) {
                if (terminalLimitReduction.acceptableDuration().contains((Object)temporaryLimit.getAcceptableDuration())) {
                    limitReductions[i] = terminalLimitReduction.reduction();
                }
                ++i;
            }
        }
        return limitReductions;
    }

    @Override
    public void updateState(LfNetworkStateUpdateParameters parameters, LfNetworkUpdateReport updateReport) {
        Branch<?> branch = this.getBranch();
        if (this.isDisabled()) {
            this.updateFlows(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        } else {
            this.updateFlows(this.p1.eval(), this.q1.eval(), this.p2.eval(), this.q2.eval());
        }
        if (parameters.isSimulateAutomationSystems()) {
            boolean connectedSide2After;
            boolean connectedSide1Before = branch.getTerminal1().isConnected();
            boolean connectedSide2Before = branch.getTerminal2().isConnected();
            boolean connectedSide1After = !this.isDisabled() && this.isConnectedSide1();
            boolean bl = connectedSide2After = !this.isDisabled() && this.isConnectedSide2();
            if (connectedSide1Before && !connectedSide1After) {
                LOGGER.warn("Disconnect terminal 1 of branch '{}'", (Object)branch.getId());
                branch.getTerminal1().disconnect();
                ++updateReport.disconnectedBranchSide1Count;
            }
            if (!connectedSide1Before && connectedSide1After) {
                LOGGER.warn("Connect terminal 1 of branch '{}'", (Object)branch.getId());
                branch.getTerminal1().connect();
                ++updateReport.connectedBranchSide1Count;
            }
            if (connectedSide2Before && !connectedSide2After) {
                LOGGER.warn("Disconnect terminal 2 of branch '{}'", (Object)branch.getId());
                branch.getTerminal2().disconnect();
                ++updateReport.disconnectedBranchSide2Count;
            }
            if (!connectedSide2Before && connectedSide2After) {
                LOGGER.warn("Connect terminal 2 of branch '{}'", (Object)branch.getId());
                branch.getTerminal2().connect();
                ++updateReport.connectedBranchSide2Count;
            }
        }
        if (branch instanceof TwoWindingsTransformer) {
            TwoWindingsTransformer twt = (TwoWindingsTransformer)branch;
            if (twt.hasPhaseTapChanger()) {
                PhaseTapChanger ptc = twt.getPhaseTapChanger();
                if (this.isDisabled()) {
                    ptc.unsetSolvedTapPosition();
                } else if (parameters.isPhaseShifterRegulationOn() && this.isPhaseController()) {
                    this.updateSolvedTapPosition(ptc);
                } else {
                    ptc.setSolvedTapPosition(ptc.getTapPosition());
                }
            }
            if (twt.hasRatioTapChanger()) {
                RatioTapChanger rtc = twt.getRatioTapChanger();
                if (this.isDisabled()) {
                    rtc.unsetSolvedTapPosition();
                } else if (parameters.isTransformerVoltageControlOn() && this.isVoltageController() || parameters.isTransformerReactivePowerControlOn() && this.isTransformerReactivePowerController()) {
                    double baseRatio = Transformers.getRatioPerUnitBase(twt);
                    double rho = this.getPiModel().getR1() * twt.getRatedU1() / twt.getRatedU2() * baseRatio;
                    double ptcRho = twt.getPhaseTapChanger() != null ? ((PhaseTapChangerStep)twt.getPhaseTapChanger().getCurrentStep()).getRho() : 1.0;
                    this.updateSolvedTapPosition(rtc, ptcRho, rho);
                } else {
                    rtc.setSolvedTapPosition(rtc.getTapPosition());
                }
            }
        }
    }

    @Override
    public void updateFlows(double p1, double q1, double p2, double q2) {
        Branch<?> branch = this.getBranch();
        branch.getTerminal1().setP(p1 * 100.0).setQ(q1 * 100.0);
        branch.getTerminal2().setP(p2 * 100.0).setQ(q2 * 100.0);
    }
}

