/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.LoadAsymmetrical;
import com.powsybl.iidm.network.extensions.ReferenceTerminals;
import com.powsybl.iidm.network.extensions.SlackTerminal;
import com.powsybl.openloadflow.network.LfAsymBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.ReferenceBusSelectionMode;
import com.powsybl.openloadflow.network.impl.AbstractLfBus;
import com.powsybl.openloadflow.network.impl.Ref;
import com.powsybl.security.BusBreakerViolationLocation;
import com.powsybl.security.NodeBreakerViolationLocation;
import com.powsybl.security.ViolationLocation;
import com.powsybl.security.results.BusResult;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class LfBusImpl
extends AbstractLfBus {
    private final Ref<Bus> busRef;
    private final double nominalV;
    private final double lowVoltageLimit;
    private final double highVoltageLimit;
    private final boolean participating;
    private final boolean breakers;
    private final Country country;
    private final List<String> bbsIds;
    private ViolationLocation violationLocation = null;

    protected LfBusImpl(Bus bus, LfNetwork network, double v, double angle, LfNetworkParameters parameters, boolean participating) {
        super(network, v, angle, parameters.isDistributedOnConformLoad());
        this.busRef = Ref.create(bus, parameters.isCacheEnabled());
        this.nominalV = bus.getVoltageLevel().getNominalV();
        this.lowVoltageLimit = bus.getVoltageLevel().getLowVoltageLimit();
        this.highVoltageLimit = bus.getVoltageLevel().getHighVoltageLimit();
        this.participating = participating;
        this.breakers = parameters.isBreakers();
        this.country = bus.getVoltageLevel().getSubstation().flatMap(Substation::getCountry).orElse(null);
        this.bbsIds = bus.getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER ? bus.getConnectedTerminalStream().map(Terminal::getConnectable).filter(BusbarSection.class::isInstance).map(Identifiable::getId).toList() : Collections.emptyList();
    }

    private static void createAsym(Bus bus, LfBusImpl lfBus) {
        double totalDeltaPa = 0.0;
        double totalDeltaQa = 0.0;
        double totalDeltaPb = 0.0;
        double totalDeltaQb = 0.0;
        double totalDeltaPc = 0.0;
        double totalDeltaQc = 0.0;
        for (Load load : bus.getLoads()) {
            LoadAsymmetrical extension = (LoadAsymmetrical)load.getExtension(LoadAsymmetrical.class);
            if (extension == null) continue;
            totalDeltaPa += extension.getDeltaPa() / 100.0;
            totalDeltaQa += extension.getDeltaQa() / 100.0;
            totalDeltaPb += extension.getDeltaPb() / 100.0;
            totalDeltaQb += extension.getDeltaQb() / 100.0;
            totalDeltaPc += extension.getDeltaPc() / 100.0;
            totalDeltaQc += extension.getDeltaQc() / 100.0;
        }
        lfBus.setAsym(new LfAsymBus(totalDeltaPa, totalDeltaQa, totalDeltaPb, totalDeltaQb, totalDeltaPc, totalDeltaQc));
    }

    public static LfBusImpl create(Bus bus, LfNetwork network, LfNetworkParameters parameters, boolean participating) {
        Objects.requireNonNull(bus);
        Objects.requireNonNull(parameters);
        LfBusImpl lfBus = new LfBusImpl(bus, network, bus.getV(), Math.toRadians(bus.getAngle()), parameters, participating);
        if (parameters.isAsymmetrical()) {
            LfBusImpl.createAsym(bus, lfBus);
        }
        return lfBus;
    }

    private Bus getBus() {
        return this.busRef.get();
    }

    @Override
    public String getId() {
        return this.getBus().getId();
    }

    @Override
    public String getVoltageLevelId() {
        return this.getBus().getVoltageLevel().getId();
    }

    @Override
    public boolean isFictitious() {
        return false;
    }

    @Override
    public double getNominalV() {
        return this.nominalV;
    }

    @Override
    public double getLowVoltageLimit() {
        return this.lowVoltageLimit / this.nominalV;
    }

    @Override
    public double getHighVoltageLimit() {
        return this.highVoltageLimit / this.nominalV;
    }

    @Override
    public void updateState(LfNetworkStateUpdateParameters parameters) {
        Bus bus = this.getBus();
        bus.setV(Math.max(this.v, 0.0)).setAngle(Math.toDegrees(this.angle));
        if (this.slack && parameters.isWriteSlackBus()) {
            SlackTerminal.attach((Bus)bus);
        }
        if (this.reference && parameters.isWriteReferenceTerminals() && parameters.getReferenceBusSelectionMode() == ReferenceBusSelectionMode.FIRST_SLACK) {
            bus.getConnectedTerminalStream().findFirst().ifPresent(ReferenceTerminals::addTerminal);
        }
        super.updateState(parameters);
    }

    @Override
    public boolean isParticipating() {
        return this.participating;
    }

    @Override
    public List<BusResult> createBusResults() {
        Bus bus = this.getBus();
        if (this.breakers) {
            if (this.bbsIds.isEmpty()) {
                return List.of(new BusResult(this.getVoltageLevelId(), bus.getId(), this.v, Math.toDegrees(this.angle)));
            }
            return this.bbsIds.stream().map(bbsId -> new BusResult(this.getVoltageLevelId(), bbsId, this.v, Math.toDegrees(this.angle))).collect(Collectors.toList());
        }
        return bus.getVoltageLevel().getBusBreakerView().getBusesFromBusViewBusId(bus.getId()).stream().map(b -> new BusResult(this.getVoltageLevelId(), b.getId(), this.v, Math.toDegrees(this.angle))).collect(Collectors.toList());
    }

    @Override
    public Optional<Country> getCountry() {
        return Optional.ofNullable(this.country);
    }

    @Override
    public double getTargetP() {
        if (this.asym != null) {
            return this.getGenerationTargetP();
        }
        return super.getTargetP();
    }

    @Override
    public double getTargetQ() {
        if (this.asym != null) {
            return this.getGenerationTargetQ();
        }
        return super.getTargetQ();
    }

    @Override
    public ViolationLocation getViolationLocation() {
        TopologyKind topologyKind = this.getBus().getVoltageLevel().getTopologyKind();
        if (this.violationLocation == null) {
            this.violationLocation = switch (topologyKind) {
                default -> throw new IncompatibleClassChangeError();
                case TopologyKind.NODE_BREAKER -> {
                    List<Integer> nodes = this.getBus().getConnectedTerminalStream().map(t -> t.getNodeBreakerView().getNode()).toList();
                    if (nodes.isEmpty()) {
                        yield null;
                    }
                    yield new NodeBreakerViolationLocation(this.getVoltageLevelId(), nodes);
                }
                case TopologyKind.BUS_BREAKER -> {
                    VoltageLevel.BusBreakerView busBreakerView = this.getBus().getVoltageLevel().getBusBreakerView();
                    if (this.getBus() == busBreakerView.getBus(this.getBus().getId())) {
                        yield new BusBreakerViolationLocation(List.of(this.getBus().getId()));
                    }
                    List<String> busIds = busBreakerView.getBusStreamFromBusViewBusId(this.getBus().getId()).map(Identifiable::getId).sorted().toList();
                    if (busIds.isEmpty()) {
                        yield null;
                    }
                    yield new BusBreakerViolationLocation(busIds);
                }
            };
        }
        return this.violationLocation;
    }
}

