/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.LfNetworkUpdateReport;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.SimplePiModel;
import com.powsybl.openloadflow.network.impl.AbstractImpedantLfBranch;
import com.powsybl.openloadflow.network.impl.Ref;
import com.powsybl.openloadflow.sa.LimitReductionManager;
import com.powsybl.openloadflow.util.PerUnit;
import com.powsybl.security.results.BranchResult;
import java.util.List;
import java.util.Objects;

public class LfDanglingLineBranch
extends AbstractImpedantLfBranch {
    private final Ref<DanglingLine> danglingLineRef;

    protected LfDanglingLineBranch(LfNetwork network, LfBus bus1, LfBus bus2, PiModel piModel, DanglingLine danglingLine, LfNetworkParameters parameters) {
        super(network, bus1, bus2, piModel, parameters);
        this.danglingLineRef = Ref.create(danglingLine, parameters.isCacheEnabled());
    }

    public static LfDanglingLineBranch create(DanglingLine danglingLine, LfNetwork network, LfBus bus1, LfBus bus2, LfNetworkParameters parameters) {
        Objects.requireNonNull(danglingLine);
        Objects.requireNonNull(bus1);
        Objects.requireNonNull(bus2);
        Objects.requireNonNull(parameters);
        double zb = PerUnit.zb(danglingLine.getTerminal().getVoltageLevel().getNominalV());
        SimplePiModel piModel = new SimplePiModel().setR(danglingLine.getR() / zb).setX(danglingLine.getX() / zb).setG1(danglingLine.getG() * zb).setG2(0.0).setB1(danglingLine.getB() * zb).setB2(0.0);
        return new LfDanglingLineBranch(network, bus1, bus2, piModel, danglingLine, parameters);
    }

    private DanglingLine getDanglingLine() {
        return this.danglingLineRef.get();
    }

    @Override
    public String getId() {
        return this.getDanglingLine().getId();
    }

    @Override
    public LfBranch.BranchType getBranchType() {
        return LfBranch.BranchType.DANGLING_LINE;
    }

    @Override
    public boolean hasPhaseControllerCapability() {
        return false;
    }

    @Override
    public List<BranchResult> createBranchResult(double preContingencyBranchP1, double preContingencyBranchOfContingencyP1, boolean createExtension) {
        double currentScale = PerUnit.ib(this.getDanglingLine().getTerminal().getVoltageLevel().getNominalV());
        return List.of(new BranchResult(this.getId(), this.p1.eval() * 100.0, this.q1.eval() * 100.0, currentScale * this.i1.eval(), this.p2.eval() * 100.0, this.q2.eval() * 100.0, currentScale * this.i2.eval(), Double.NaN));
    }

    @Override
    public List<LfBranch.LfLimit> getLimits1(LimitType type, LimitReductionManager limitReductionManager) {
        switch (type) {
            case ACTIVE_POWER: {
                return this.getLimits1(type, () -> this.getDanglingLine().getActivePowerLimits(), limitReductionManager);
            }
            case APPARENT_POWER: {
                return this.getLimits1(type, () -> this.getDanglingLine().getApparentPowerLimits(), limitReductionManager);
            }
            case CURRENT: {
                return this.getLimits1(type, () -> this.getDanglingLine().getCurrentLimits(), limitReductionManager);
            }
        }
        throw new UnsupportedOperationException(String.format("Getting %s limits is not supported.", type.name()));
    }

    @Override
    public double[] getLimitReductions(TwoSides side, LimitReductionManager limitReductionManager, LoadingLimits limits) {
        return new double[0];
    }

    @Override
    public void updateState(LfNetworkStateUpdateParameters parameters, LfNetworkUpdateReport updateReport) {
        this.updateFlows(this.p1.eval(), this.q1.eval(), Double.NaN, Double.NaN);
    }

    @Override
    public void updateFlows(double p1, double q1, double p2, double q2) {
        this.getDanglingLine().getTerminal().setP(p1 * 100.0).setQ(q1 * 100.0);
    }
}

