/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.extensions.HvdcAngleDroopActivePowerControl;
import com.powsybl.iidm.network.extensions.HvdcOperatorActivePowerRange;
import com.powsybl.openloadflow.network.AbstractElement;
import com.powsybl.openloadflow.network.ElementType;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfHvdc;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfVscConverterStation;
import com.powsybl.openloadflow.network.impl.LfVscConverterStationImpl;
import com.powsybl.openloadflow.util.Evaluable;
import com.powsybl.openloadflow.util.EvaluableConstants;
import com.powsybl.openloadflow.util.PerUnit;
import java.util.Objects;

public class LfHvdcImpl
extends AbstractElement
implements LfHvdc {
    private final String id;
    private final LfBus bus1;
    private final LfBus bus2;
    private Evaluable p1 = EvaluableConstants.NAN;
    private Evaluable p2 = EvaluableConstants.NAN;
    private double droop = Double.NaN;
    private double p0 = Double.NaN;
    private double r = Double.NaN;
    private double nominalV = Double.NaN;
    private LfVscConverterStation converterStation1;
    private LfVscConverterStation converterStation2;
    private boolean acEmulation;
    private final double pMaxFromCS1toCS2;
    private final double pMaxFromCS2toCS1;

    public LfHvdcImpl(String id, LfBus bus1, LfBus bus2, LfNetwork network, HvdcLine hvdcLine, boolean acEmulation) {
        super(network);
        HvdcOperatorActivePowerRange powerRange;
        this.id = Objects.requireNonNull(id);
        this.bus1 = bus1;
        this.bus2 = bus2;
        this.nominalV = hvdcLine.getNominalV();
        this.r = hvdcLine.getR();
        HvdcAngleDroopActivePowerControl droopControl = (HvdcAngleDroopActivePowerControl)hvdcLine.getExtension(HvdcAngleDroopActivePowerControl.class);
        boolean bl = this.acEmulation = acEmulation && droopControl != null && droopControl.isEnabled();
        if (this.acEmulation) {
            this.droop = droopControl.getDroop();
            this.p0 = droopControl.getP0();
        }
        if ((powerRange = (HvdcOperatorActivePowerRange)hvdcLine.getExtension(HvdcOperatorActivePowerRange.class)) != null) {
            this.pMaxFromCS1toCS2 = powerRange.getOprFromCS1toCS2();
            this.pMaxFromCS2toCS1 = powerRange.getOprFromCS2toCS1();
        } else {
            this.pMaxFromCS2toCS1 = hvdcLine.getMaxP();
            this.pMaxFromCS1toCS2 = hvdcLine.getMaxP();
        }
    }

    @Override
    public ElementType getType() {
        return ElementType.HVDC;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public LfBus getBus1() {
        return this.bus1;
    }

    @Override
    public LfBus getBus2() {
        return this.bus2;
    }

    @Override
    public LfBus getOtherBus(LfBus bus) {
        return bus.equals(this.bus1) ? this.bus2 : this.bus1;
    }

    @Override
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        if (!this.acEmulation && !disabled) {
            this.converterStation1.setTargetP(this.converterStation1.getInitialTargetP());
            this.converterStation2.setTargetP(this.converterStation2.getInitialTargetP());
        }
    }

    @Override
    public void setP1(Evaluable p1) {
        this.p1 = Objects.requireNonNull(p1);
    }

    @Override
    public Evaluable getP1() {
        return this.p1;
    }

    @Override
    public void setP2(Evaluable p2) {
        this.p2 = Objects.requireNonNull(p2);
    }

    @Override
    public Evaluable getP2() {
        return this.p2;
    }

    @Override
    public double getDroop() {
        return this.droop / 100.0;
    }

    @Override
    public double getR() {
        return this.r / PerUnit.zb(this.nominalV);
    }

    @Override
    public double getP0() {
        return this.p0 / 100.0;
    }

    @Override
    public boolean isAcEmulation() {
        return this.acEmulation;
    }

    @Override
    public void setAcEmulation(boolean acEmulation) {
        this.acEmulation = acEmulation;
    }

    @Override
    public LfVscConverterStation getConverterStation1() {
        return this.converterStation1;
    }

    @Override
    public LfVscConverterStation getConverterStation2() {
        return this.converterStation2;
    }

    @Override
    public void setConverterStation1(LfVscConverterStation converterStation1) {
        this.converterStation1 = Objects.requireNonNull(converterStation1);
        converterStation1.setHvdc(this);
    }

    @Override
    public void setConverterStation2(LfVscConverterStation converterStation2) {
        this.converterStation2 = Objects.requireNonNull(converterStation2);
        converterStation2.setHvdc(this);
    }

    @Override
    public void updateState() {
        if (this.acEmulation) {
            ((LfVscConverterStationImpl)this.converterStation1).getStation().getTerminal().setP(this.p1.eval() * 100.0);
            ((LfVscConverterStationImpl)this.converterStation2).getStation().getTerminal().setP(this.p2.eval() * 100.0);
        }
    }

    @Override
    public double getPMaxFromCS1toCS2() {
        return Double.isNaN(this.pMaxFromCS1toCS2) ? Double.MAX_VALUE : this.pMaxFromCS1toCS2 / 100.0;
    }

    @Override
    public double getPMaxFromCS2toCS1() {
        return Double.isNaN(this.pMaxFromCS1toCS2) ? Double.MAX_VALUE : this.pMaxFromCS2toCS1 / 100.0;
    }
}

