/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorLinearModel;
import com.powsybl.iidm.network.ShuntCompensatorModel;
import com.powsybl.iidm.network.ShuntCompensatorNonLinearModel;
import com.powsybl.openloadflow.network.AbstractLfShunt;
import com.powsybl.openloadflow.network.AllowedDirection;
import com.powsybl.openloadflow.network.Direction;
import com.powsybl.openloadflow.network.ElementType;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkListener;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.LfTopoConfig;
import com.powsybl.openloadflow.network.ShuntVoltageControl;
import com.powsybl.openloadflow.network.impl.Ref;
import com.powsybl.openloadflow.util.PerUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class LfShuntImpl
extends AbstractLfShunt {
    private final List<Ref<ShuntCompensator>> shuntCompensatorsRefs;
    private final LfBus bus;
    private ShuntVoltageControl voltageControl;
    private boolean voltageControlCapability;
    private boolean voltageControlEnabled = false;
    private final List<LfShunt.Controller> controllers = new ArrayList<LfShunt.Controller>();
    private double b;
    private final double zb;
    private double g;

    public LfShuntImpl(List<ShuntCompensator> shuntCompensators, LfNetwork network, LfBus bus, boolean voltageControlCapability, LfNetworkParameters parameters, LfTopoConfig topoConfig) {
        super(network);
        this.shuntCompensatorsRefs = Objects.requireNonNull(shuntCompensators).stream().map(sc -> Ref.create(sc, parameters.isCacheEnabled())).collect(Collectors.toList());
        if (shuntCompensators.isEmpty()) {
            throw new IllegalArgumentException("Empty shunt compensator list");
        }
        this.bus = Objects.requireNonNull(bus);
        this.voltageControlCapability = voltageControlCapability;
        double nominalV = shuntCompensators.get(0).getTerminal().getVoltageLevel().getNominalV();
        this.zb = PerUnit.zb(nominalV);
        this.b = LfShuntImpl.computeB(shuntCompensators, this.zb);
        this.g = LfShuntImpl.computeG(shuntCompensators, this.zb);
        boolean keepSections = shuntCompensators.stream().map(Identifiable::getId).anyMatch(id -> topoConfig.isOperatedShunt((String)id));
        if (voltageControlCapability || keepSections) {
            this.shuntCompensatorsRefs.forEach(shuntCompensatorRef -> {
                ShuntCompensator shuntCompensator = (ShuntCompensator)shuntCompensatorRef.get();
                ArrayList<Double> sectionsB = new ArrayList<Double>(1);
                ArrayList<Double> sectionsG = new ArrayList<Double>(1);
                sectionsB.add(0.0);
                sectionsG.add(0.0);
                ShuntCompensatorModel model = shuntCompensator.getModel();
                switch (shuntCompensator.getModelType()) {
                    case LINEAR: {
                        ShuntCompensatorLinearModel linearModel = (ShuntCompensatorLinearModel)model;
                        for (int section = 1; section <= shuntCompensator.getMaximumSectionCount(); ++section) {
                            sectionsB.add(linearModel.getBPerSection() * (double)section * this.zb);
                            sectionsG.add(linearModel.getGPerSection() * (double)section * this.zb);
                        }
                        break;
                    }
                    case NON_LINEAR: {
                        ShuntCompensatorNonLinearModel nonLinearModel = (ShuntCompensatorNonLinearModel)model;
                        for (int section = 0; section < shuntCompensator.getMaximumSectionCount(); ++section) {
                            sectionsB.add(((ShuntCompensatorNonLinearModel.Section)nonLinearModel.getAllSections().get(section)).getB() * this.zb);
                            sectionsG.add(((ShuntCompensatorNonLinearModel.Section)nonLinearModel.getAllSections().get(section)).getG() * this.zb);
                        }
                        break;
                    }
                }
                this.controllers.add(new ControllerImpl((Ref<ShuntCompensator>)shuntCompensatorRef, (List<Double>)sectionsB, (List<Double>)sectionsG, shuntCompensator.getSectionCount()));
            });
            this.controllers.sort(Comparator.comparingDouble(LfShunt.Controller::getBMagnitude).reversed());
        }
    }

    private static double computeG(List<ShuntCompensator> shuntCompensators, double zb) {
        return zb * shuntCompensators.stream().mapToDouble(ShuntCompensator::getG).sum();
    }

    private static double computeB(List<ShuntCompensator> shuntCompensators, double zb) {
        return zb * shuntCompensators.stream().mapToDouble(ShuntCompensator::getB).sum();
    }

    @Override
    public ElementType getType() {
        return ElementType.SHUNT_COMPENSATOR;
    }

    @Override
    public String getId() {
        return this.controllers.isEmpty() ? this.bus.getId() + "_shunt_compensators" : this.bus.getId() + "_controller_shunt_compensators";
    }

    @Override
    public List<String> getOriginalIds() {
        return this.shuntCompensatorsRefs.stream().map(scRef -> ((ShuntCompensator)scRef.get()).getId()).collect(Collectors.toList());
    }

    @Override
    public double getB() {
        return this.b;
    }

    @Override
    public void setB(double b) {
        if (b != this.b) {
            this.b = b;
            for (LfNetworkListener listener : this.getNetwork().getListeners()) {
                listener.onShuntSusceptanceChange(this, b);
            }
        }
    }

    @Override
    public double getG() {
        return this.g;
    }

    @Override
    public void setG(double g) {
        this.g = g;
    }

    @Override
    public boolean hasVoltageControlCapability() {
        return this.voltageControlCapability;
    }

    @Override
    public void setVoltageControlCapability(boolean voltageControlCapability) {
        this.voltageControlCapability = voltageControlCapability;
    }

    @Override
    public boolean isVoltageControlEnabled() {
        return this.voltageControlEnabled;
    }

    @Override
    public void setVoltageControlEnabled(boolean voltageControlEnabled) {
        if (this.voltageControlEnabled != voltageControlEnabled) {
            this.voltageControlEnabled = voltageControlEnabled;
            for (LfNetworkListener listener : this.network.getListeners()) {
                listener.onShuntVoltageControlChange(this, voltageControlEnabled);
            }
        }
    }

    @Override
    public Optional<ShuntVoltageControl> getVoltageControl() {
        return Optional.ofNullable(this.voltageControl);
    }

    @Override
    public void setVoltageControl(ShuntVoltageControl voltageControl) {
        this.voltageControl = voltageControl;
    }

    @Override
    public List<LfShunt.Controller> getControllers() {
        return this.controllers;
    }

    private void roundBToClosestSection(double b, LfShunt.Controller controller) {
        List<Double> sections = controller.getSectionsB();
        double smallestDistance = Math.abs(b - sections.get(controller.getPosition()));
        for (int s = 0; s < sections.size(); ++s) {
            double distance = Math.abs(b - sections.get(s));
            if (!(distance < smallestDistance)) continue;
            controller.setPosition(s);
            smallestDistance = distance;
        }
        LOGGER.trace("Round B shift of shunt '{}': {} -> {}", new Object[]{controller.getId(), b * this.zb, controller.getB() * this.zb});
    }

    @Override
    public double dispatchB() {
        double residueB = this.b;
        int remainingControllers = this.controllers.size();
        for (LfShunt.Controller controller : this.controllers) {
            double bToDispatchByController = residueB / (double)remainingControllers--;
            this.roundBToClosestSection(bToDispatchByController, controller);
            residueB -= controller.getB();
        }
        this.b = this.controllers.stream().mapToDouble(LfShunt.Controller::getB).sum();
        return residueB;
    }

    @Override
    public void updateState(LfNetworkStateUpdateParameters parameters) {
        if (parameters.isDc()) {
            for (Ref<ShuntCompensator> scRef : this.shuntCompensatorsRefs) {
                ShuntCompensator sc = scRef.get();
                sc.getTerminal().setP(0.0);
                sc.setSolvedSectionCount(sc.getSectionCount());
            }
        } else {
            double vSquare = this.bus.getV() * this.bus.getV() * this.bus.getNominalV() * this.bus.getNominalV();
            if (!this.voltageControlCapability) {
                for (Ref<ShuntCompensator> scRef : this.shuntCompensatorsRefs) {
                    ShuntCompensator sc = scRef.get();
                    sc.getTerminal().setP(sc.getG() * vSquare);
                    sc.getTerminal().setQ(-sc.getB() * vSquare);
                    sc.setSolvedSectionCount(sc.getSectionCount());
                }
            } else {
                for (LfShunt.Controller controller : this.controllers) {
                    ShuntCompensator sc = ((ControllerImpl)controller).getShuntCompensatorRef().get();
                    sc.getTerminal().setP(controller.getG() * vSquare / this.zb);
                    sc.getTerminal().setQ(-controller.getB() * vSquare / this.zb);
                    sc.setSolvedSectionCount(controller.getPosition());
                }
            }
        }
    }

    @Override
    public void reInit() {
        if (this.voltageControlCapability) {
            throw new PowsyblException("Cannot re-init a shunt compensator with voltage control capabilities");
        }
        List<ShuntCompensator> shuntCompensators = this.shuntCompensatorsRefs.stream().map(Ref::get).collect(Collectors.toList());
        this.setB(LfShuntImpl.computeB(shuntCompensators, this.zb));
        this.setG(LfShuntImpl.computeG(shuntCompensators, this.zb));
    }

    private final class ControllerImpl
    extends LfShunt.Controller {
        private final Ref<ShuntCompensator> shuntCompensatorRef;

        private ControllerImpl(Ref<ShuntCompensator> shuntCompensatorRef, List<Double> sectionsB, List<Double> sectionsG, int position) {
            super(shuntCompensatorRef.get().getId(), sectionsB, sectionsG, position);
            this.shuntCompensatorRef = shuntCompensatorRef;
        }

        private Ref<ShuntCompensator> getShuntCompensatorRef() {
            return this.shuntCompensatorRef;
        }

        @Override
        public Optional<Direction> updateSectionB(double deltaB, int maxSectionShift, AllowedDirection allowedDirection) {
            Optional<Direction> direction = super.updateSectionB(deltaB, maxSectionShift, allowedDirection);
            if (direction.isPresent()) {
                LfShuntImpl.this.setG(LfShuntImpl.this.controllers.stream().mapToDouble(LfShunt.Controller::getG).sum());
                LfShuntImpl.this.setB(LfShuntImpl.this.controllers.stream().mapToDouble(LfShunt.Controller::getB).sum());
            }
            return direction;
        }

        @Override
        public void updateSectionB(int newPosition) {
            super.updateSectionB(newPosition);
            LfShuntImpl.this.setG(LfShuntImpl.this.controllers.stream().mapToDouble(LfShunt.Controller::getG).sum());
            LfShuntImpl.this.setB(LfShuntImpl.this.controllers.stream().mapToDouble(LfShunt.Controller::getB).sum());
        }
    }
}

