/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.impl.AbstractLfBus;
import com.powsybl.openloadflow.network.impl.Networks;
import com.powsybl.openloadflow.network.impl.Ref;
import com.powsybl.security.ViolationLocation;
import java.util.List;

public class LfStarBus
extends AbstractLfBus {
    private final Ref<ThreeWindingsTransformer> t3wtRef;
    private final double nominalV;

    public LfStarBus(LfNetwork network, ThreeWindingsTransformer t3wt, LfNetworkParameters parameters) {
        super(network, Networks.getPropertyV(t3wt), Math.toRadians(Networks.getPropertyAngle(t3wt)), false);
        this.t3wtRef = Ref.create(t3wt, parameters.isCacheEnabled());
        this.nominalV = t3wt.getRatedU0();
    }

    private ThreeWindingsTransformer getT3wt() {
        return this.t3wtRef.get();
    }

    public static String getId(String id) {
        return id + "_BUS0";
    }

    @Override
    public String getId() {
        return LfStarBus.getId(this.getT3wt().getId());
    }

    @Override
    public List<String> getOriginalIds() {
        return List.of(this.getT3wt().getId());
    }

    @Override
    public String getVoltageLevelId() {
        return this.getT3wt().getLeg1().getTerminal().getVoltageLevel().getId();
    }

    @Override
    public boolean isFictitious() {
        return true;
    }

    @Override
    public double getNominalV() {
        return this.nominalV;
    }

    @Override
    public void updateState(LfNetworkStateUpdateParameters parameters) {
        ThreeWindingsTransformer t3wt = this.getT3wt();
        Networks.setPropertyV(t3wt, this.v);
        Networks.setPropertyAngle(t3wt, Math.toDegrees(this.angle));
        super.updateState(parameters);
    }

    @Override
    public ViolationLocation getViolationLocation() {
        return null;
    }
}

