/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.LfNetworkUpdateReport;
import com.powsybl.openloadflow.network.SimplePiModel;
import com.powsybl.openloadflow.network.impl.AbstractLfBranch;
import com.powsybl.openloadflow.network.impl.Ref;
import com.powsybl.openloadflow.sa.LimitReductionManager;
import com.powsybl.openloadflow.util.Evaluable;
import com.powsybl.openloadflow.util.EvaluableConstants;
import com.powsybl.security.results.BranchResult;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LfSwitch
extends AbstractLfBranch {
    private static final Logger LOGGER = LoggerFactory.getLogger(LfSwitch.class);
    private final Ref<Switch> switchRef;

    public LfSwitch(LfNetwork network, LfBus bus1, LfBus bus2, Switch aSwitch, LfNetworkParameters parameters) {
        super(network, Objects.requireNonNull(bus1), Objects.requireNonNull(bus2), new SimplePiModel(), parameters);
        this.switchRef = Ref.create(aSwitch, parameters.isCacheEnabled());
    }

    private Switch getSwitch() {
        return this.switchRef.get();
    }

    @Override
    public String getId() {
        return this.getSwitch().getId();
    }

    @Override
    public LfBranch.BranchType getBranchType() {
        return LfBranch.BranchType.SWITCH;
    }

    @Override
    public boolean hasPhaseControllerCapability() {
        return false;
    }

    @Override
    public boolean isConnectedSide1() {
        return true;
    }

    @Override
    public void setConnectedSide1(boolean connectedSide1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isConnectedSide2() {
        return true;
    }

    @Override
    public void setConnectedSide2(boolean connectedSide2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDisconnectionAllowedSide1() {
        return false;
    }

    @Override
    public void setDisconnectionAllowedSide1(boolean disconnectionAllowedSide1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDisconnectionAllowedSide2() {
        return false;
    }

    @Override
    public void setDisconnectionAllowedSide2(boolean disconnectionAllowedSide2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setP1(Evaluable p1) {
    }

    @Override
    public Evaluable getP1() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setP2(Evaluable p2) {
    }

    @Override
    public Evaluable getP2() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setQ1(Evaluable q1) {
    }

    @Override
    public Evaluable getQ1() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setQ2(Evaluable q2) {
    }

    @Override
    public Evaluable getQ2() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setI1(Evaluable i1) {
    }

    @Override
    public Evaluable getI1() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setI2(Evaluable i2) {
    }

    @Override
    public Evaluable getI2() {
        return EvaluableConstants.NAN;
    }

    @Override
    public Evaluable getOpenP1() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setOpenP1(Evaluable openP1) {
    }

    @Override
    public Evaluable getOpenQ1() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setOpenQ1(Evaluable openQ1) {
    }

    @Override
    public Evaluable getOpenI1() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setOpenI1(Evaluable openI1) {
    }

    @Override
    public Evaluable getOpenP2() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setOpenP2(Evaluable openP2) {
    }

    @Override
    public Evaluable getOpenQ2() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setOpenQ2(Evaluable openQ2) {
    }

    @Override
    public Evaluable getOpenI2() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setOpenI2(Evaluable openI2) {
    }

    @Override
    public Evaluable getClosedP1() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setClosedP1(Evaluable closedP1) {
    }

    @Override
    public Evaluable getClosedQ1() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setClosedQ1(Evaluable closedQ1) {
    }

    @Override
    public Evaluable getClosedI1() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setClosedI1(Evaluable closedI1) {
    }

    @Override
    public Evaluable getClosedP2() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setClosedP2(Evaluable closedP2) {
    }

    @Override
    public Evaluable getClosedQ2() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setClosedQ2(Evaluable closedQ2) {
    }

    @Override
    public Evaluable getClosedI2() {
        return EvaluableConstants.NAN;
    }

    @Override
    public void setClosedI2(Evaluable closedI2) {
    }

    @Override
    public void addAdditionalOpenP1(Evaluable openP1) {
    }

    @Override
    public List<Evaluable> getAdditionalOpenP1() {
        return Collections.emptyList();
    }

    @Override
    public void addAdditionalClosedP1(Evaluable closedP1) {
    }

    @Override
    public List<Evaluable> getAdditionalClosedP1() {
        return Collections.emptyList();
    }

    @Override
    public void addAdditionalOpenQ1(Evaluable openQ1) {
    }

    @Override
    public List<Evaluable> getAdditionalOpenQ1() {
        return Collections.emptyList();
    }

    @Override
    public void addAdditionalClosedQ1(Evaluable closedQ1) {
    }

    @Override
    public List<Evaluable> getAdditionalClosedQ1() {
        return Collections.emptyList();
    }

    @Override
    public void addAdditionalOpenP2(Evaluable openP2) {
    }

    @Override
    public List<Evaluable> getAdditionalOpenP2() {
        return Collections.emptyList();
    }

    @Override
    public void addAdditionalClosedP2(Evaluable closedP2) {
    }

    @Override
    public List<Evaluable> getAdditionalClosedP2() {
        return Collections.emptyList();
    }

    @Override
    public void addAdditionalOpenQ2(Evaluable openQ2) {
    }

    @Override
    public List<Evaluable> getAdditionalOpenQ2() {
        return Collections.emptyList();
    }

    @Override
    public void addAdditionalClosedQ2(Evaluable closedQ2) {
    }

    @Override
    public List<Evaluable> getAdditionalClosedQ2() {
        return Collections.emptyList();
    }

    @Override
    public List<BranchResult> createBranchResult(double preContingencyBranchP1, double preContingencyBranchOfContingencyP1, boolean createExtension) {
        throw new PowsyblException("Unsupported type of branch for branch result: " + this.getSwitch().getId());
    }

    @Override
    public List<LfBranch.LfLimit> getLimits1(LimitType type, LimitReductionManager limitReductionManager) {
        return Collections.emptyList();
    }

    @Override
    public double[] getLimitReductions(TwoSides side, LimitReductionManager limitReductionManager, LoadingLimits limits) {
        return new double[0];
    }

    @Override
    public void updateState(LfNetworkStateUpdateParameters parameters, LfNetworkUpdateReport updateReport) {
        if (parameters.isSimulateAutomationSystems()) {
            if (this.isDisabled() && !this.switchRef.get().isOpen()) {
                LOGGER.trace("Open switch '{}'", (Object)this.switchRef.get().getId());
                ++updateReport.openedSwitchCount;
                this.switchRef.get().setOpen(true);
            }
            if (!this.isDisabled() && this.switchRef.get().isOpen()) {
                LOGGER.trace("Close switch '{}'", (Object)this.switchRef.get().getId());
                ++updateReport.closedSwitchCount;
                this.switchRef.get().setOpen(false);
            }
        }
    }

    @Override
    public void updateFlows(double p1, double q1, double p2, double q2) {
    }
}

