/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.ReactiveLimits;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.util.HvdcUtils;
import com.powsybl.openloadflow.network.LfHvdc;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.LfVscConverterStation;
import com.powsybl.openloadflow.network.impl.AbstractLfGenerator;
import com.powsybl.openloadflow.network.impl.HvdcConverterStations;
import com.powsybl.openloadflow.network.impl.LfNetworkLoadingReport;
import com.powsybl.openloadflow.network.impl.Networks;
import com.powsybl.openloadflow.network.impl.Ref;
import java.util.Objects;
import java.util.Optional;

public class LfVscConverterStationImpl
extends AbstractLfGenerator
implements LfVscConverterStation {
    private final Ref<VscConverterStation> stationRef;
    private final double lossFactor;
    private LfHvdc hvdc;
    private final boolean hvdcDandlingInIidm;

    public LfVscConverterStationImpl(VscConverterStation station, LfNetwork network, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        super(network, HvdcUtils.getConverterStationTargetP((HvdcConverterStation)station) / 100.0, parameters);
        this.hvdcDandlingInIidm = HvdcConverterStations.isHvdcDanglingInIidm(station);
        this.stationRef = Ref.create(station, parameters.isCacheEnabled());
        this.lossFactor = station.getLossFactor();
        if (station.isVoltageRegulatorOn()) {
            this.setVoltageControl(station.getVoltageSetpoint(), station.getTerminal(), station.getRegulatingTerminal(), parameters, report);
        }
    }

    public static LfVscConverterStationImpl create(VscConverterStation station, LfNetwork network, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        Objects.requireNonNull(station);
        Objects.requireNonNull(network);
        Objects.requireNonNull(parameters);
        return new LfVscConverterStationImpl(station, network, parameters, report);
    }

    VscConverterStation getStation() {
        return this.stationRef.get();
    }

    @Override
    public void setHvdc(LfHvdc hvdc) {
        this.hvdc = hvdc;
    }

    @Override
    public double getTargetP() {
        if (this.hvdc == null) {
            return this.hvdcDandlingInIidm ? 0.0 : super.getTargetP();
        }
        return this.hvdc.isAcEmulation() ? 0.0 : super.getTargetP();
    }

    @Override
    public void setInitialTargetP(double initialTargetP) {
    }

    @Override
    public void setInitialTargetPToTargetP() {
    }

    @Override
    public double getLossFactor() {
        return this.lossFactor;
    }

    @Override
    public String getId() {
        return this.getStation().getId();
    }

    @Override
    public double getTargetQ() {
        return Networks.zeroIfNan(this.getStation().getReactivePowerSetpoint()) / 100.0;
    }

    @Override
    public double getMinP() {
        HvdcLine hvdcLine = this.getStation().getHvdcLine();
        return hvdcLine != null ? -hvdcLine.getMaxP() / 100.0 : -1.7976931348623157E308;
    }

    @Override
    public double getMaxP() {
        HvdcLine hvdcLine = this.getStation().getHvdcLine();
        return hvdcLine != null ? hvdcLine.getMaxP() / 100.0 : Double.MAX_VALUE;
    }

    @Override
    protected Optional<ReactiveLimits> getReactiveLimits() {
        return Optional.of(this.getStation().getReactiveLimits());
    }

    @Override
    public void updateState(LfNetworkStateUpdateParameters parameters) {
        VscConverterStation station = this.getStation();
        station.getTerminal().setQ(Double.isNaN(this.calculatedQ) ? -this.getTargetQ() * 100.0 : -this.calculatedQ * 100.0);
        if (this.hvdc == null || !this.hvdc.isAcEmulation()) {
            station.getTerminal().setP(-this.getTargetP() * 100.0);
        }
    }

    @Override
    public int getReferencePriority() {
        return -1;
    }
}

