/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.OverloadManagementSystem;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.openloadflow.graph.GraphConnectivity;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfHvdc;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfTopoConfig;
import com.powsybl.openloadflow.network.SlackBusSelector;
import com.powsybl.openloadflow.network.impl.LfGeneratorImpl;
import com.powsybl.openloadflow.network.impl.LfNetworkList;
import com.powsybl.openloadflow.network.impl.LfNetworkLoaderImpl;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public final class Networks {
    private static final String PROPERTY_V = "v";
    private static final String PROPERTY_ANGLE = "angle";

    private Networks() {
    }

    private static <T extends Injection<T>> void resetInjectionsState(Iterable<T> injections) {
        for (Injection injection : injections) {
            injection.getTerminal().setP(Double.NaN).setQ(Double.NaN);
        }
    }

    public static void resetState(Network network) {
        for (Bus b : network.getBusView().getBuses()) {
            b.setV(Double.NaN).setAngle(Double.NaN);
        }
        for (Bus b : network.getBranches()) {
            b.getTerminal1().setP(Double.NaN).setQ(Double.NaN);
            b.getTerminal2().setP(Double.NaN).setQ(Double.NaN);
        }
        for (ThreeWindingsTransformer twt : network.getThreeWindingsTransformers()) {
            twt.getLeg1().getTerminal().setP(Double.NaN).setQ(Double.NaN);
            twt.getLeg2().getTerminal().setP(Double.NaN).setQ(Double.NaN);
            twt.getLeg3().getTerminal().setP(Double.NaN).setQ(Double.NaN);
        }
        for (ShuntCompensator sc : network.getShuntCompensators()) {
            sc.getTerminal().setP(Double.NaN).setQ(Double.NaN);
        }
        Networks.resetInjectionsState(network.getGenerators());
        Networks.resetInjectionsState(network.getStaticVarCompensators());
        Networks.resetInjectionsState(network.getVscConverterStations());
        Networks.resetInjectionsState(network.getLoads());
        Networks.resetInjectionsState(network.getLccConverterStations());
        Networks.resetInjectionsState(network.getBatteries());
        Networks.resetInjectionsState(network.getDanglingLines());
    }

    private static double getDoubleProperty(Identifiable<?> identifiable, String name) {
        Objects.requireNonNull(identifiable);
        String value = identifiable.getProperty(name);
        return value != null ? Double.parseDouble(value) : Double.NaN;
    }

    private static void setDoubleProperty(Identifiable<?> identifiable, String name, double value) {
        Objects.requireNonNull(identifiable);
        if (Double.isNaN(value)) {
            identifiable.removeProperty(name);
        } else {
            identifiable.setProperty(name, Double.toString(value));
        }
    }

    public static double getPropertyV(Identifiable<?> identifiable) {
        return Networks.getDoubleProperty(identifiable, PROPERTY_V);
    }

    public static void setPropertyV(Identifiable<?> identifiable, double v) {
        Networks.setDoubleProperty(identifiable, PROPERTY_V, v);
    }

    public static double getPropertyAngle(Identifiable<?> identifiable) {
        return Networks.getDoubleProperty(identifiable, PROPERTY_ANGLE);
    }

    public static void setPropertyAngle(Identifiable<?> identifiable, double angle) {
        Networks.setDoubleProperty(identifiable, PROPERTY_ANGLE, angle);
    }

    public static double zeroIfNan(double value) {
        return Double.isNaN(value) ? 0.0 : value;
    }

    public static List<LfNetwork> load(Network network, SlackBusSelector slackBusSelector) {
        return LfNetwork.load(network, new LfNetworkLoaderImpl(), slackBusSelector);
    }

    public static List<LfNetwork> load(Network network, LfNetworkParameters parameters) {
        return LfNetwork.load(network, new LfNetworkLoaderImpl(), parameters);
    }

    public static List<LfNetwork> load(Network network, LfNetworkParameters parameters, ReportNode reportNode) {
        return LfNetwork.load(network, new LfNetworkLoaderImpl(), parameters, reportNode);
    }

    public static List<LfNetwork> load(Network network, LfTopoConfig topoConfig, LfNetworkParameters parameters, ReportNode reportNode) {
        return LfNetwork.load(network, new LfNetworkLoaderImpl(), topoConfig, parameters, reportNode);
    }

    private static void retainAndCloseNecessarySwitches(Network network, LfTopoConfig topoConfig) {
        network.getSwitchStream().filter(sw -> sw.getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER).forEach(sw -> sw.setRetained(false));
        topoConfig.getSwitchesToOpen().stream().filter(sw -> sw.getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER).forEach(sw -> sw.setRetained(true));
        topoConfig.getSwitchesToClose().stream().filter(sw -> sw.getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER).forEach(sw -> sw.setRetained(true));
        topoConfig.getSwitchesToClose().forEach(sw -> sw.setOpen(false));
        topoConfig.getBranchIdsToClose().stream().map(arg_0 -> ((Network)network).getBranch(arg_0)).forEach(branch -> {
            branch.getTerminal1().connect();
            branch.getTerminal2().connect();
        });
    }

    private static void restoreInitialTopology(LfNetwork network, Set<String> switchAndBranchIdsToClose) {
        GraphConnectivity<LfBus, LfBranch> connectivity = network.getConnectivity();
        connectivity.startTemporaryChanges();
        HashSet toRemove = new HashSet();
        switchAndBranchIdsToClose.forEach(id -> {
            LfBranch branch = network.getBranchById((String)id);
            if (branch != null) {
                connectivity.removeEdge(branch);
                toRemove.add(id);
            }
        });
        switchAndBranchIdsToClose.removeAll(toRemove);
        Set<LfBus> removedBuses = connectivity.getVerticesRemovedFromMainComponent();
        removedBuses.forEach(bus -> bus.setDisabled(true));
        HashSet<LfBranch> removedBranches = new HashSet<LfBranch>(connectivity.getEdgesRemovedFromMainComponent());
        for (LfBus bus2 : removedBuses) {
            bus2.getBranches().stream().filter(b -> !b.isConnectedAtBothSides()).forEach(removedBranches::add);
        }
        removedBranches.forEach(branch -> branch.setDisabled(true));
        for (LfHvdc hvdc : network.getHvdcs()) {
            if (!Networks.isIsolatedBusForHvdc(hvdc.getBus1(), connectivity) && !Networks.isIsolatedBusForHvdc(hvdc.getBus2(), connectivity)) continue;
            hvdc.setDisabled(true);
            hvdc.getConverterStation1().setTargetP(0.0);
            hvdc.getConverterStation2().setTargetP(0.0);
        }
    }

    private static void addSwitchToOperateByAutomationSystem(Network network, LfTopoConfig topoConfig, OverloadManagementSystem.SwitchTripping tripping) {
        Switch aSwitch = network.getSwitch(tripping.getSwitchToOperateId());
        if (aSwitch != null) {
            if (tripping.isOpenAction()) {
                topoConfig.getSwitchesToOpen().add(aSwitch);
            } else {
                topoConfig.getSwitchesToClose().add(aSwitch);
            }
        }
    }

    private static void addBranchToOperateByAutomationSystem(Network network, LfTopoConfig topoConfig, OverloadManagementSystem.BranchTripping tripping) {
        Branch branch = network.getBranch(tripping.getBranchToOperateId());
        if (!(branch == null || tripping.isOpenAction() || branch.getTerminal1().isConnected() || branch.getTerminal2().isConnected())) {
            topoConfig.getBranchIdsToClose().add(branch.getId());
        }
    }

    private static void addElementsToOperateByAutomationSystem(Network network, LfTopoConfig topoConfig) {
        for (Substation substation : network.getSubstations()) {
            for (OverloadManagementSystem system : substation.getOverloadManagementSystems()) {
                system.getTrippings().forEach(tripping -> {
                    if (tripping.getType() == OverloadManagementSystem.Tripping.Type.SWITCH_TRIPPING) {
                        Networks.addSwitchToOperateByAutomationSystem(network, topoConfig, (OverloadManagementSystem.SwitchTripping)tripping);
                    } else if (tripping.getType() == OverloadManagementSystem.Tripping.Type.BRANCH_TRIPPING) {
                        Networks.addBranchToOperateByAutomationSystem(network, topoConfig, (OverloadManagementSystem.BranchTripping)tripping);
                    } else if (tripping.getType() == OverloadManagementSystem.Tripping.Type.THREE_WINDINGS_TRANSFORMER_TRIPPING) {
                        // empty if block
                    }
                });
            }
        }
    }

    public static LfNetworkList load(Network network, LfNetworkParameters networkParameters, LfTopoConfig topoConfig, ReportNode reportNode) {
        return Networks.load(network, networkParameters, topoConfig, LfNetworkList.DefaultVariantCleaner::new, reportNode);
    }

    public static LfNetworkList load(Network network, LfNetworkParameters networkParameters, LfTopoConfig topoConfig, LfNetworkList.VariantCleanerFactory variantCleanerFactory, ReportNode reportNode) {
        LfTopoConfig modifiedTopoConfig;
        if (networkParameters.isSimulateAutomationSystems()) {
            modifiedTopoConfig = new LfTopoConfig(topoConfig);
            Networks.addElementsToOperateByAutomationSystem(network, modifiedTopoConfig);
            if (modifiedTopoConfig.isBreaker()) {
                networkParameters.setBreakers(true);
            }
        } else {
            modifiedTopoConfig = topoConfig;
        }
        if (!modifiedTopoConfig.isBreaker() && modifiedTopoConfig.getBranchIdsToClose().isEmpty()) {
            return new LfNetworkList(Networks.load(network, topoConfig, networkParameters, reportNode));
        }
        if (!networkParameters.isBreakers() && modifiedTopoConfig.isBreaker()) {
            throw new PowsyblException("LF networks have to be built from bus/breaker view");
        }
        String tmpVariantId = "olf-tmp-" + UUID.randomUUID();
        String workingVariantId = network.getVariantManager().getWorkingVariantId();
        network.getVariantManager().cloneVariant(network.getVariantManager().getWorkingVariantId(), tmpVariantId);
        network.getVariantManager().setWorkingVariant(tmpVariantId);
        Networks.retainAndCloseNecessarySwitches(network, modifiedTopoConfig);
        List<LfNetwork> lfNetworks = Networks.load(network, topoConfig, networkParameters, reportNode);
        if (!modifiedTopoConfig.getSwitchesToClose().isEmpty() || !modifiedTopoConfig.getBranchIdsToClose().isEmpty()) {
            Set<String> switchAndBranchIdsLeftToClose = modifiedTopoConfig.getSwitchesToClose().stream().filter(Objects::nonNull).map(Identifiable::getId).collect(Collectors.toSet());
            switchAndBranchIdsLeftToClose.addAll(modifiedTopoConfig.getBranchIdsToClose());
            for (LfNetwork lfNetwork : lfNetworks) {
                if (switchAndBranchIdsLeftToClose.isEmpty()) break;
                Networks.restoreInitialTopology(lfNetwork, switchAndBranchIdsLeftToClose);
            }
        }
        return new LfNetworkList(lfNetworks, variantCleanerFactory.create(network, workingVariantId, tmpVariantId));
    }

    public static Iterable<Bus> getBuses(Network network, boolean breaker) {
        return breaker ? network.getBusBreakerView().getBuses() : network.getBusView().getBuses();
    }

    public static Bus getBus(Terminal terminal, boolean breakers) {
        return breakers ? terminal.getBusBreakerView().getBus() : terminal.getBusView().getBus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isIsolatedBusForHvdc(LfBus bus, GraphConnectivity<LfBus, LfBranch> connectivity) {
        if (connectivity.getConnectedComponent(bus).size() != 1) return false;
        if (bus.getNonFictitiousLoadTargetP() != 0.0) return false;
        if (!bus.getGenerators().stream().noneMatch(LfGeneratorImpl.class::isInstance)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isIsolatedBusForHvdc(LfBus bus, Set<LfBus> disabledBuses) {
        if (!disabledBuses.contains(bus)) return false;
        if (bus.getNonFictitiousLoadTargetP() != 0.0) return false;
        if (!bus.getGenerators().stream().noneMatch(LfGeneratorImpl.class::isInstance)) return false;
        return true;
    }

    public static Optional<Terminal> getEquipmentRegulatingTerminal(Network network, String equipmentId) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(equipmentId);
        Identifiable identifiable = network.getIdentifiable(equipmentId);
        if (identifiable != null) {
            return Networks.getEquipmentRegulatingTerminal(identifiable);
        }
        return Optional.empty();
    }

    public static Optional<Terminal> getEquipmentRegulatingTerminal(Identifiable<?> identifiable) {
        Objects.requireNonNull(identifiable);
        return switch (identifiable.getType()) {
            case IdentifiableType.TWO_WINDINGS_TRANSFORMER -> {
                RatioTapChanger rtc = ((TwoWindingsTransformer)identifiable).getRatioTapChanger();
                if (rtc != null) {
                    yield Optional.of(rtc.getRegulationTerminal());
                }
                yield Optional.empty();
            }
            case IdentifiableType.THREE_WINDINGS_TRANSFORMER -> {
                for (ThreeWindingsTransformer.Leg leg : ((ThreeWindingsTransformer)identifiable).getLegs()) {
                    RatioTapChanger rtc = leg.getRatioTapChanger();
                    if (rtc == null || !rtc.isRegulating()) continue;
                    yield Optional.of(rtc.getRegulationTerminal());
                }
                yield Optional.empty();
            }
            case IdentifiableType.GENERATOR -> Optional.of(((Generator)identifiable).getRegulatingTerminal());
            case IdentifiableType.SHUNT_COMPENSATOR -> Optional.of(((ShuntCompensator)identifiable).getRegulatingTerminal());
            case IdentifiableType.STATIC_VAR_COMPENSATOR -> Optional.of(((StaticVarCompensator)identifiable).getRegulatingTerminal());
            case IdentifiableType.HVDC_CONVERTER_STATION -> {
                if (((HvdcConverterStation)identifiable).getHvdcType() == HvdcConverterStation.HvdcType.VSC) {
                    yield Optional.of(((VscConverterStation)identifiable).getTerminal());
                }
                yield Optional.empty();
            }
            default -> Optional.empty();
        };
    }
}

