/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.math.graph.TraverseResult;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class NodeBreakerTraverser
implements VoltageLevel.NodeBreakerView.TopologyTraverser {
    private final Set<Switch> switchesToOpen;
    private final Set<Terminal> traversedTerminals;
    private final List<Terminal> nextTerminals;
    private final VoltageLevel.NodeBreakerView nodeBreakerView;

    public NodeBreakerTraverser(Set<Switch> switchesToOpen, Set<Terminal> traversedTerminals, List<Terminal> nextTerminals, VoltageLevel.NodeBreakerView nodeBreakerView) {
        this.switchesToOpen = switchesToOpen;
        this.traversedTerminals = traversedTerminals;
        this.nextTerminals = nextTerminals;
        this.nodeBreakerView = nodeBreakerView;
    }

    public TraverseResult traverse(int nodeBefore, Switch sw, int nodeAfter) {
        if (sw != null && sw.isOpen()) {
            return TraverseResult.TERMINATE_PATH;
        }
        if (this.hasAttachedEquipment(nodeBefore) && this.traverserStopsAtOtherEdges(sw, nodeBefore, nodeAfter)) {
            if (NodeBreakerTraverser.isOpenable(sw)) {
                return TraverseResult.TERMINATE_PATH;
            }
            if (!this.hasAttachedEquipment(nodeAfter) && this.traverserStopsAtOtherEdges(sw, nodeAfter, nodeBefore)) {
                return TraverseResult.TERMINATE_PATH;
            }
        }
        if (NodeBreakerTraverser.isOpenable(sw)) {
            if (!this.hasAttachedEquipment(nodeAfter) && this.traverserStopsAtOtherEdges(sw, nodeAfter, nodeBefore)) {
                return TraverseResult.CONTINUE;
            }
            if (this.isEquivalentToStopAfterSwitch(sw, nodeAfter)) {
                this.nodeBreakerView.getOptionalTerminal(nodeAfter).ifPresent(this.traversedTerminals::add);
                return TraverseResult.TERMINATE_PATH;
            }
            this.switchesToOpen.add(sw);
            return TraverseResult.TERMINATE_PATH;
        }
        this.nodeBreakerView.getOptionalTerminal(nodeAfter).ifPresent(this::terminalTraversed);
        return TraverseResult.CONTINUE;
    }

    private boolean hasAttachedEquipment(int nodeBefore) {
        return this.nodeBreakerView.getOptionalTerminal(nodeBefore).isPresent();
    }

    private void terminalTraversed(Terminal terminal) {
        this.traversedTerminals.add(terminal);
        terminal.getConnectable().getTerminals().stream().filter(t -> t != terminal).forEach(this.nextTerminals::add);
    }

    private boolean isEquivalentToStopAfterSwitch(Switch sw, int nodeAfter) {
        Terminal terminal2 = this.nodeBreakerView.getTerminal(nodeAfter);
        if (terminal2 != null) {
            boolean endNodeAfter;
            IdentifiableType connectableAfter = terminal2.getConnectable().getType();
            boolean bl = endNodeAfter = connectableAfter == IdentifiableType.GENERATOR || connectableAfter == IdentifiableType.LOAD || connectableAfter == IdentifiableType.STATIC_VAR_COMPENSATOR || connectableAfter == IdentifiableType.BATTERY || connectableAfter == IdentifiableType.SHUNT_COMPENSATOR || connectableAfter == IdentifiableType.DANGLING_LINE || connectableAfter == IdentifiableType.LINE || connectableAfter == IdentifiableType.TWO_WINDINGS_TRANSFORMER || connectableAfter == IdentifiableType.THREE_WINDINGS_TRANSFORMER;
            if (endNodeAfter) {
                return this.noInternalConnectionAtNode(nodeAfter) && this.nodeBreakerView.getSwitchStream(nodeAfter).noneMatch(s -> s != sw && !s.isOpen());
            }
        }
        return false;
    }

    private boolean traverserStopsAtOtherEdges(Switch aSwitch, int nodeStart, int nodeEnd) {
        return this.internalConnectionsEndOnOpenOrOpenableSwitches(nodeStart, nodeEnd) && this.allOtherSwitchesOpenOrOpenable(aSwitch, nodeStart);
    }

    private boolean allOtherSwitchesOpenOrOpenable(Switch aSwitch, int node) {
        return this.nodeBreakerView.getSwitchStream(node).filter(s -> s != aSwitch).allMatch(NodeBreakerTraverser::isOpenOrOpenable);
    }

    private boolean noInternalConnectionAtNode(int node) {
        return this.nodeBreakerView.getNodeInternalConnectedToStream(node).findFirst().isEmpty();
    }

    private boolean internalConnectionsEndOnOpenOrOpenableSwitches(int node, int dismissedNode) {
        HashSet<Integer> visitedNodes = new HashSet<Integer>();
        visitedNodes.add(dismissedNode);
        return this.internalConnectionsEndOnOpenOrOpenableSwitches(node, visitedNodes);
    }

    private boolean internalConnectionsEndOnOpenOrOpenableSwitches(int nStart, Set<Integer> visitedNodes) {
        if (!visitedNodes.contains(nStart)) {
            visitedNodes.add(nStart);
            Iterator iterator = this.nodeBreakerView.getNodesInternalConnectedTo(nStart).iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (visitedNodes.contains(n) || !this.hasAttachedEquipment(n) && !this.nodeBreakerView.getSwitchStream(n).anyMatch(s -> !NodeBreakerTraverser.isOpenOrOpenable(s)) && this.internalConnectionsEndOnOpenOrOpenableSwitches(n, visitedNodes)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isOpenable(Switch aSwitch) {
        return aSwitch != null && !aSwitch.isFictitious() && aSwitch.getKind() == SwitchKind.BREAKER;
    }

    private static boolean isOpenOrOpenable(Switch aSwitch) {
        return aSwitch.isOpen() || NodeBreakerTraverser.isOpenable(aSwitch);
    }
}

