/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.util;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfLoad;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.util.GenerationActivePowerDistributionStep;
import com.powsybl.openloadflow.network.util.LoadActivePowerDistributionStep;
import com.powsybl.openloadflow.network.util.ParticipatingElement;
import com.powsybl.openloadflow.util.Reports;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActivePowerDistribution {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivePowerDistribution.class);
    public static final double P_RESIDUE_EPS = Math.pow(10.0, -5.0);
    private final Step step;

    private ActivePowerDistribution(Step step) {
        this.step = Objects.requireNonNull(step);
    }

    public String getElementType() {
        return this.step.getElementType();
    }

    public Result run(LfNetwork network, double activePowerMismatch) {
        return this.run(network.getReferenceGenerator(), network.getBuses(), activePowerMismatch);
    }

    public Result run(LfGenerator referenceGenerator, Collection<LfBus> buses, double activePowerMismatch) {
        Collection<LfBus> participatingBuses = ActivePowerDistribution.filterParticipatingBuses(buses);
        PreviousStateInfo previousStateInfo = this.step.resetToInitialState(participatingBuses, referenceGenerator);
        double remainingMismatch = activePowerMismatch + previousStateInfo.previousMismatch();
        List<ParticipatingElement> participatingElements = this.step.getParticipatingElements(participatingBuses, remainingMismatch);
        int iteration = 0;
        while (!participatingElements.isEmpty() && Math.abs(remainingMismatch) > P_RESIDUE_EPS && ParticipatingElement.participationFactorNorm(participatingElements) > 0.0) {
            double done = this.step.run(participatingElements, iteration, remainingMismatch);
            remainingMismatch -= done;
            ++iteration;
        }
        return new Result(iteration, remainingMismatch, previousStateInfo.moved());
    }

    public static ActivePowerDistribution create(LoadFlowParameters.BalanceType balanceType, boolean loadPowerFactorConstant, boolean useActiveLimits) {
        return new ActivePowerDistribution(ActivePowerDistribution.getStep(balanceType, loadPowerFactorConstant, useActiveLimits));
    }

    public static Step getStep(LoadFlowParameters.BalanceType balanceType, boolean loadPowerFactorConstant, boolean useActiveLimits) {
        return switch (balanceType) {
            default -> throw new IncompatibleClassChangeError();
            case LoadFlowParameters.BalanceType.PROPORTIONAL_TO_LOAD, LoadFlowParameters.BalanceType.PROPORTIONAL_TO_CONFORM_LOAD -> new LoadActivePowerDistributionStep(loadPowerFactorConstant);
            case LoadFlowParameters.BalanceType.PROPORTIONAL_TO_GENERATION_P_MAX -> new GenerationActivePowerDistributionStep(GenerationActivePowerDistributionStep.ParticipationType.MAX, useActiveLimits);
            case LoadFlowParameters.BalanceType.PROPORTIONAL_TO_GENERATION_P -> new GenerationActivePowerDistributionStep(GenerationActivePowerDistributionStep.ParticipationType.TARGET, useActiveLimits);
            case LoadFlowParameters.BalanceType.PROPORTIONAL_TO_GENERATION_PARTICIPATION_FACTOR -> new GenerationActivePowerDistributionStep(GenerationActivePowerDistributionStep.ParticipationType.PARTICIPATION_FACTOR, useActiveLimits);
            case LoadFlowParameters.BalanceType.PROPORTIONAL_TO_GENERATION_REMAINING_MARGIN -> new GenerationActivePowerDistributionStep(GenerationActivePowerDistributionStep.ParticipationType.REMAINING_MARGIN, useActiveLimits);
        };
    }

    public static Collection<LfBus> filterParticipatingBuses(Collection<LfBus> buses) {
        return buses.stream().filter(bus -> bus.isParticipating() && !bus.isDisabled() && !bus.isFictitious()).toList();
    }

    public static ResultWithFailureBehaviorHandling handleDistributionFailureBehavior(OpenLoadFlowParameters.SlackDistributionFailureBehavior behavior, LfGenerator referenceGenerator, double activePowerMismatch, Result result, String failMessageTemplate) {
        ResultWithFailureBehaviorHandling resultWithFailureBehaviorHandling;
        OpenLoadFlowParameters.SlackDistributionFailureBehavior effectiveBehavior;
        Objects.requireNonNull(behavior);
        Objects.requireNonNull(result);
        if (OpenLoadFlowParameters.SlackDistributionFailureBehavior.DISTRIBUTE_ON_REFERENCE_GENERATOR == behavior && referenceGenerator == null) {
            effectiveBehavior = OpenLoadFlowParameters.SlackDistributionFailureBehavior.FAIL;
            LOGGER.debug("Distribution failure behavior is DISTRIBUTE_ON_REFERENCE_GENERATOR but no reference generator selected, switching to FAIL mode");
        } else {
            effectiveBehavior = behavior;
        }
        double distributedActivePower = activePowerMismatch - result.remainingMismatch();
        if (Math.abs(result.remainingMismatch()) > P_RESIDUE_EPS) {
            String statusText = String.format(Locale.US, failMessageTemplate, result.remainingMismatch() * 100.0);
            switch (effectiveBehavior) {
                case THROW: {
                    throw new PowsyblException(statusText);
                }
                case LEAVE_ON_SLACK_BUS: {
                    LOGGER.warn(statusText);
                    resultWithFailureBehaviorHandling = new ResultWithFailureBehaviorHandling(false, statusText, result.iteration(), result.remainingMismatch(), result.movedBuses(), 0.0);
                    break;
                }
                case FAIL: {
                    LOGGER.error(statusText);
                    resultWithFailureBehaviorHandling = new ResultWithFailureBehaviorHandling(true, statusText, result.iteration(), result.remainingMismatch(), result.movedBuses(), distributedActivePower);
                    break;
                }
                case DISTRIBUTE_ON_REFERENCE_GENERATOR: {
                    Objects.requireNonNull(referenceGenerator, "No reference generator");
                    LOGGER.debug("{} MW distributed to reference generator '{}'", (Object)(result.remainingMismatch() * 100.0), (Object)referenceGenerator.getId());
                    referenceGenerator.setTargetP(referenceGenerator.getTargetP() + result.remainingMismatch());
                    resultWithFailureBehaviorHandling = new ResultWithFailureBehaviorHandling(false, statusText, result.iteration() + 1, 0.0, true, 0.0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown slackDistributionFailureBehavior");
                }
            }
        } else {
            resultWithFailureBehaviorHandling = new ResultWithFailureBehaviorHandling(false, "", result.iteration(), result.remainingMismatch(), result.movedBuses(), 0.0);
        }
        return resultWithFailureBehaviorHandling;
    }

    public static void reportAndLogSuccess(ReportNode reportNode, double slackBusActivePowerMismatch, ResultWithFailureBehaviorHandling result) {
        Reports.reportMismatchDistributionSuccess(reportNode, slackBusActivePowerMismatch * 100.0, result.iteration());
        LOGGER.info("Slack bus active power ({} MW) distributed in {} distribution iteration(s)", (Object)(slackBusActivePowerMismatch * 100.0), (Object)result.iteration());
    }

    public static interface Step {
        public String getElementType();

        default public PreviousStateInfo resetToInitialState(Collection<LfBus> participatingBuses, LfGenerator referenceGenerator) {
            double previousMismatch = 0.0;
            HashMap<Object, Double> previousTargetP = new HashMap<Object, Double>();
            if (referenceGenerator != null) {
                previousMismatch -= referenceGenerator.getInitialTargetP() - referenceGenerator.getTargetP();
                previousTargetP.put(referenceGenerator, referenceGenerator.getTargetP());
                referenceGenerator.setTargetP(referenceGenerator.getInitialTargetP());
            }
            return new PreviousStateInfo(previousMismatch, previousTargetP);
        }

        public List<ParticipatingElement> getParticipatingElements(Collection<LfBus> var1, double var2);

        public double run(List<ParticipatingElement> var1, int var2, double var3);
    }

    public record Result(int iteration, double remainingMismatch, boolean movedBuses) {
    }

    public record PreviousStateInfo(double previousMismatch, Map<Object, Double> previousTargetP) {
        public boolean moved() {
            return this.previousTargetP.entrySet().stream().mapToDouble(e -> {
                Object o = e.getKey();
                if (o instanceof LfGenerator) {
                    LfGenerator lfGenerator = (LfGenerator)o;
                    return Math.abs(lfGenerator.getTargetP() - (Double)e.getValue());
                }
                if (o instanceof LfLoad) {
                    LfLoad lfLoad = (LfLoad)o;
                    return Math.abs(lfLoad.getTargetP() - (Double)e.getValue());
                }
                throw new IllegalStateException();
            }).sum() > P_RESIDUE_EPS * 0.9;
        }
    }

    public record ResultWithFailureBehaviorHandling(boolean failed, String failedMessage, int iteration, double remainingMismatch, boolean movedBuses, double failedDistributedActivePower) {
    }
}

