/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.util;

import com.powsybl.commons.PowsyblException;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.util.ActivePowerDistribution;
import com.powsybl.openloadflow.network.util.ParticipatingElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerationActivePowerDistributionStep
implements ActivePowerDistribution.Step {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerationActivePowerDistributionStep.class);
    private final ParticipationType participationType;
    private final boolean useActiveLimits;

    public GenerationActivePowerDistributionStep(ParticipationType pParticipationType, boolean useActiveLimits) {
        this.participationType = pParticipationType;
        this.useActiveLimits = useActiveLimits;
    }

    @Override
    public String getElementType() {
        return "generation";
    }

    @Override
    public ActivePowerDistribution.PreviousStateInfo resetToInitialState(Collection<LfBus> participatingBuses, LfGenerator referenceGenerator) {
        ActivePowerDistribution.PreviousStateInfo previousStateInfo = ActivePowerDistribution.Step.super.resetToInitialState(participatingBuses, referenceGenerator);
        double previousMismatch = 0.0;
        for (LfBus bus : participatingBuses) {
            for (LfGenerator generator : bus.getGenerators()) {
                if (!generator.isParticipating()) continue;
                previousMismatch -= generator.getInitialTargetP() - generator.getTargetP();
                previousStateInfo.previousTargetP().putIfAbsent(generator, generator.getTargetP());
                generator.setTargetP(generator.getInitialTargetP());
            }
        }
        return new ActivePowerDistribution.PreviousStateInfo(previousMismatch + previousStateInfo.previousMismatch(), previousStateInfo.previousTargetP());
    }

    @Override
    public List<ParticipatingElement> getParticipatingElements(Collection<LfBus> participatingBuses, double mismatch) {
        return participatingBuses.stream().flatMap(bus -> bus.getGenerators().stream()).map(gen -> {
            double factor = this.getParticipationFactor((LfGenerator)gen, mismatch);
            if (this.isParticipating((LfGenerator)gen) && factor != 0.0) {
                return new ParticipatingElement(gen, factor);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public double run(List<ParticipatingElement> participatingElements, int iteration, double remainingMismatch) {
        ParticipatingElement.normalizeParticipationFactors(participatingElements);
        double done = 0.0;
        int modifiedBuses = 0;
        int generatorsAtMax = 0;
        int generatorsAtMin = 0;
        Iterator<ParticipatingElement> it = participatingElements.iterator();
        while (it.hasNext()) {
            ParticipatingElement participatingGenerator = it.next();
            LfGenerator generator = (LfGenerator)participatingGenerator.getElement();
            double factor = participatingGenerator.getFactor();
            double minTargetP = this.useActiveLimits ? generator.getMinTargetP() : -1.7976931348623157E308;
            double maxTargetP = this.useActiveLimits ? generator.getMaxTargetP() : Double.MAX_VALUE;
            double targetP = generator.getTargetP();
            if (targetP < 0.0) {
                maxTargetP = Math.min(maxTargetP, 0.0);
            } else {
                minTargetP = Math.max(minTargetP, 0.0);
            }
            double newTargetP = targetP + remainingMismatch * factor;
            if (remainingMismatch > 0.0 && newTargetP > maxTargetP) {
                newTargetP = maxTargetP;
                ++generatorsAtMax;
                it.remove();
            } else if (remainingMismatch < 0.0 && newTargetP < minTargetP) {
                newTargetP = minTargetP;
                ++generatorsAtMin;
                it.remove();
            }
            if (newTargetP == targetP) continue;
            LOGGER.trace("Rescale '{}' active power target: {} -> {}", new Object[]{generator.getId(), targetP * 100.0, newTargetP * 100.0});
            generator.setTargetP(newTargetP);
            done += newTargetP - targetP;
            ++modifiedBuses;
        }
        LOGGER.debug("{} MW / {} MW distributed at iteration {} to {} generators ({} at max power, {} at min power)", new Object[]{done * 100.0, remainingMismatch * 100.0, iteration, modifiedBuses, generatorsAtMax, generatorsAtMin});
        return done;
    }

    private double getParticipationFactor(LfGenerator generator, double mismatch) {
        return switch (this.participationType) {
            default -> throw new IncompatibleClassChangeError();
            case ParticipationType.MAX -> generator.getMaxP() / generator.getDroop();
            case ParticipationType.TARGET -> Math.abs(generator.getTargetP());
            case ParticipationType.PARTICIPATION_FACTOR -> generator.getParticipationFactor();
            case ParticipationType.REMAINING_MARGIN -> {
                if (Double.isNaN(mismatch)) {
                    throw new PowsyblException("The sign of the active power mismatch is unknown, it is mandatory for REMAINING_MARGIN participation type");
                }
                double targetP = generator.getTargetP();
                double minP = generator.getMinP();
                double maxP = generator.getMaxP();
                if (targetP < 0.0) {
                    maxP = Math.min(maxP, 0.0);
                } else {
                    minP = Math.max(minP, 0.0);
                }
                if (mismatch > 0.0) {
                    yield Math.max(0.0, maxP - targetP);
                }
                yield Math.max(0.0, targetP - minP);
            }
        };
    }

    private boolean isParticipating(LfGenerator generator) {
        if (!generator.isParticipating()) {
            return false;
        }
        switch (this.participationType) {
            case MAX: {
                return generator.getDroop() != 0.0;
            }
            case PARTICIPATION_FACTOR: {
                return generator.getParticipationFactor() > 0.0;
            }
            case TARGET: 
            case REMAINING_MARGIN: {
                return true;
            }
        }
        throw new UnsupportedOperationException("Unknown balance type mode: " + this.participationType);
    }

    public static enum ParticipationType {
        MAX,
        TARGET,
        PARTICIPATION_FACTOR,
        REMAINING_MARGIN;

    }
}

