/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.util;

import com.powsybl.commons.PowsyblException;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.util.UniformValueVoltageInitializer;
import com.powsybl.openloadflow.network.util.VoltageInitializer;

public class PreviousValueVoltageInitializer
implements VoltageInitializer {
    private final UniformValueVoltageInitializer defaultVoltageInitializer = new UniformValueVoltageInitializer();
    private final boolean defaultToUniformValue;

    public PreviousValueVoltageInitializer() {
        this(false);
    }

    public PreviousValueVoltageInitializer(boolean defaultToUniformValue) {
        this.defaultToUniformValue = defaultToUniformValue;
    }

    @Override
    public void prepare(LfNetwork network) {
    }

    @Override
    public double getMagnitude(LfBus bus) {
        double v = bus.getV();
        if (Double.isNaN(v)) {
            if (this.defaultToUniformValue) {
                return this.defaultVoltageInitializer.getMagnitude(bus);
            }
            throw new PowsyblException("Voltage magnitude is undefined for bus '" + bus.getId() + "'");
        }
        return v;
    }

    @Override
    public double getAngle(LfBus bus) {
        double angle = bus.getAngle();
        if (Double.isNaN(angle)) {
            if (this.defaultToUniformValue) {
                return this.defaultVoltageInitializer.getAngle(bus);
            }
            throw new PowsyblException("Voltage angle is undefined for bus '" + bus.getId() + "'");
        }
        return angle;
    }
}

