/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa;

import com.google.common.base.Stopwatch;
import com.powsybl.action.Action;
import com.powsybl.action.AreaInterchangeTargetAction;
import com.powsybl.action.GeneratorAction;
import com.powsybl.action.HvdcAction;
import com.powsybl.action.LoadAction;
import com.powsybl.action.PhaseTapChangerTapPositionAction;
import com.powsybl.action.RatioTapChangerTapPositionAction;
import com.powsybl.action.ShuntCompensatorPositionAction;
import com.powsybl.action.SwitchAction;
import com.powsybl.action.TerminalsConnectionAction;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.TypedValue;
import com.powsybl.computation.CompletableFutureTask;
import com.powsybl.computation.ComputationManager;
import com.powsybl.contingency.ContingenciesProvider;
import com.powsybl.contingency.Contingency;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.graph.GraphConnectivityFactory;
import com.powsybl.openloadflow.lf.AbstractLoadFlowParameters;
import com.powsybl.openloadflow.lf.LoadFlowContext;
import com.powsybl.openloadflow.lf.LoadFlowEngine;
import com.powsybl.openloadflow.lf.LoadFlowResult;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfContingency;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfTopoConfig;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.NetworkState;
import com.powsybl.openloadflow.network.action.LfAction;
import com.powsybl.openloadflow.network.action.LfActionUtils;
import com.powsybl.openloadflow.network.impl.LfLegBranch;
import com.powsybl.openloadflow.network.impl.LfNetworkList;
import com.powsybl.openloadflow.network.impl.Networks;
import com.powsybl.openloadflow.network.impl.PropagatedContingency;
import com.powsybl.openloadflow.network.impl.PropagatedContingencyCreationParameters;
import com.powsybl.openloadflow.sa.ContingencyActivePowerLossDistribution;
import com.powsybl.openloadflow.sa.LimitViolationManager;
import com.powsybl.openloadflow.sa.OpenSecurityAnalysisParameters;
import com.powsybl.openloadflow.sa.PostContingencyNetworkResult;
import com.powsybl.openloadflow.sa.PreContingencyNetworkResult;
import com.powsybl.openloadflow.sa.extensions.ContingencyLoadFlowParameters;
import com.powsybl.openloadflow.util.Lists2;
import com.powsybl.openloadflow.util.Reports;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationsResult;
import com.powsybl.security.PostContingencyComputationStatus;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.SecurityAnalysisReport;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.condition.AllViolationCondition;
import com.powsybl.security.condition.AtLeastOneViolationCondition;
import com.powsybl.security.limitreduction.LimitReduction;
import com.powsybl.security.monitor.StateMonitor;
import com.powsybl.security.monitor.StateMonitorIndex;
import com.powsybl.security.results.ConnectivityResult;
import com.powsybl.security.results.NetworkResult;
import com.powsybl.security.results.OperatorStrategyResult;
import com.powsybl.security.results.PostContingencyResult;
import com.powsybl.security.results.PreContingencyResult;
import com.powsybl.security.strategy.ConditionalActions;
import com.powsybl.security.strategy.OperatorStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class AbstractSecurityAnalysis<V extends Enum<V>, E extends Enum<E>, P extends AbstractLoadFlowParameters<P>, C extends LoadFlowContext<V, E, P>, R extends LoadFlowResult> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractSecurityAnalysis.class);
    protected final Network network;
    protected final MatrixFactory matrixFactory;
    protected final GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory;
    protected final StateMonitorIndex monitorIndex;
    protected final ReportNode reportNode;
    private static final String NOT_FOUND = "' not found in the network";
    protected Level logLevel = Level.INFO;

    protected AbstractSecurityAnalysis(Network network, MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory, List<StateMonitor> stateMonitors, ReportNode reportNode) {
        this.network = Objects.requireNonNull(network);
        this.matrixFactory = Objects.requireNonNull(matrixFactory);
        this.connectivityFactory = Objects.requireNonNull(connectivityFactory);
        this.monitorIndex = new StateMonitorIndex(stateMonitors);
        this.reportNode = Objects.requireNonNull(reportNode);
    }

    protected abstract LoadFlowModel getLoadFlowModel();

    protected static SecurityAnalysisResult createNoResult() {
        return new SecurityAnalysisResult(new LimitViolationsResult(Collections.emptyList()), LoadFlowResult.ComponentResult.Status.FAILED, Collections.emptyList());
    }

    public CompletableFuture<SecurityAnalysisReport> run(String workingVariantId, SecurityAnalysisParameters securityAnalysisParameters, ContingenciesProvider contingenciesProvider, ComputationManager computationManager, List<OperatorStrategy> operatorStrategies, List<Action> actions, List<LimitReduction> limitReductions) {
        Objects.requireNonNull(workingVariantId);
        Objects.requireNonNull(securityAnalysisParameters);
        Objects.requireNonNull(contingenciesProvider);
        return CompletableFutureTask.runAsync(() -> this.runSync(securityAnalysisParameters, contingenciesProvider, operatorStrategies, actions, limitReductions, workingVariantId, computationManager.getExecutor()), (Executor)computationManager.getExecutor());
    }

    protected abstract ReportNode createSaRootReportNode();

    protected abstract boolean isShuntCompensatorVoltageControlOn(LoadFlowParameters var1);

    protected abstract P createParameters(LoadFlowParameters var1, OpenLoadFlowParameters var2, boolean var3, boolean var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecurityAnalysisReport runSync(SecurityAnalysisParameters securityAnalysisParameters, ContingenciesProvider contingenciesProvider, List<OperatorStrategy> operatorStrategies, List<Action> actions, List<LimitReduction> limitReductions, String workingVariantId, Executor executor) throws ExecutionException {
        SecurityAnalysisResult finalResult;
        ReportNode saReportNode = this.createSaRootReportNode();
        Stopwatch stopwatch = Stopwatch.createStarted();
        LoadFlowParameters lfParameters = securityAnalysisParameters.getLoadFlowParameters();
        OpenLoadFlowParameters lfParametersExt = OpenLoadFlowParameters.get(securityAnalysisParameters.getLoadFlowParameters());
        OpenSecurityAnalysisParameters securityAnalysisParametersExt = OpenSecurityAnalysisParameters.getOrDefault(securityAnalysisParameters);
        this.network.getVariantManager().setWorkingVariant(workingVariantId);
        List contingencies = contingenciesProvider.getContingencies(this.network);
        LOGGER.info("Running {} security analysis on {} contingencies on {} threads", new Object[]{this.getLoadFlowModel() == LoadFlowModel.AC ? "AC" : "DC", contingencies.size(), securityAnalysisParametersExt.getThreadCount()});
        AbstractSecurityAnalysis.checkActions(this.network, actions);
        LfTopoConfig topoConfig = new LfTopoConfig();
        AbstractSecurityAnalysis.findAllSwitchesToOperate(this.network, actions, topoConfig);
        AbstractSecurityAnalysis.findAllPtcToOperate(actions, topoConfig);
        AbstractSecurityAnalysis.findAllRtcToOperate(actions, topoConfig);
        AbstractSecurityAnalysis.findAllShuntsToOperate(actions, topoConfig);
        AbstractSecurityAnalysis.findAllBranchesToClose(this.network, actions, topoConfig);
        PropagatedContingencyCreationParameters creationParameters = new PropagatedContingencyCreationParameters().setContingencyPropagation(securityAnalysisParametersExt.isContingencyPropagation()).setShuntCompensatorVoltageControlOn(this.isShuntCompensatorVoltageControlOn(lfParameters)).setSlackDistributionOnConformLoad(lfParameters.getBalanceType() == LoadFlowParameters.BalanceType.PROPORTIONAL_TO_CONFORM_LOAD).setHvdcAcEmulation(lfParameters.isHvdcAcEmulation());
        if (securityAnalysisParametersExt.getThreadCount() == 1) {
            List<PropagatedContingency> propagatedContingencies = PropagatedContingency.createList(this.network, contingencies, topoConfig, creationParameters);
            P parameters = this.createParameters(lfParameters, lfParametersExt, topoConfig.isBreaker(), this.isAreaInterchangeControl(lfParametersExt, contingencies));
            try (LfNetworkList lfNetworks = Networks.load(this.network, ((AbstractLoadFlowParameters)parameters).getNetworkParameters(), topoConfig, saReportNode);){
                finalResult = this.runSimulationsOnAllComponents(lfNetworks, propagatedContingencies, parameters, securityAnalysisParameters, operatorStrategies, actions, limitReductions, lfParameters);
            }
        }
        List contingenciesPartitions = Lists2.partition(contingencies, securityAnalysisParametersExt.getThreadCount());
        Set contingencyIds = contingencies.stream().map(Contingency::getId).collect(Collectors.toSet());
        operatorStrategies.stream().filter(o -> !AbstractSecurityAnalysis.hasValidContingency(o, contingencyIds)).findAny().ifPresent(AbstractSecurityAnalysis::throwMissingOperatorStrategyContingency);
        Set actionIds = actions.stream().map(Action::getId).collect(Collectors.toSet());
        operatorStrategies.forEach(o -> AbstractSecurityAnalysis.findMissingActionId(o, actionIds).ifPresent(id -> AbstractSecurityAnalysis.throwMissingOperatorStrategyAction(o, id)));
        List<SecurityAnalysisResult> partitionResults = Collections.synchronizedList(new ArrayList<SecurityAnalysisResult>(Collections.nCopies(contingenciesPartitions.size(), AbstractSecurityAnalysis.createNoResult())));
        ArrayList lfNetworksList = new ArrayList();
        List<ReportNode> reportNodes = Collections.synchronizedList(new ArrayList<ReportNode>(Collections.nCopies(contingenciesPartitions.size(), ReportNode.NO_OP)));
        boolean oldAllowVariantMultiThreadAccess = this.network.getVariantManager().isVariantMultiThreadAccessAllowed();
        this.network.getVariantManager().allowVariantMultiThreadAccess(true);
        try {
            ReentrantLock networkLock = new ReentrantLock();
            ArrayList<CompletableFutureTask> futures = new ArrayList<CompletableFutureTask>();
            for (int i = 0; i < contingenciesPartitions.size(); ++i) {
                int partitionNum = i;
                List contingenciesPartition = contingenciesPartitions.get(i);
                futures.add(CompletableFutureTask.runAsync(() -> {
                    LfNetworkList lfNetworks;
                    P parameters;
                    List<PropagatedContingency> propagatedContingencies;
                    LfTopoConfig partitionTopoConfig = new LfTopoConfig(topoConfig);
                    networkLock.lock();
                    try {
                        this.network.getVariantManager().setWorkingVariant(workingVariantId);
                        propagatedContingencies = PropagatedContingency.createList(this.network, contingenciesPartition, partitionTopoConfig, creationParameters);
                        parameters = this.createParameters(lfParameters, lfParametersExt, partitionTopoConfig.isBreaker(), this.isAreaInterchangeControl(lfParametersExt, contingencies));
                        ReportNode threadRootNode = partitionNum == 0 ? saReportNode : Reports.createRootThreadReport(saReportNode);
                        reportNodes.set(partitionNum, threadRootNode);
                        lfNetworks = Networks.load(this.network, ((AbstractLoadFlowParameters)parameters).getNetworkParameters(), partitionTopoConfig, threadRootNode);
                        lfNetworksList.add(0, lfNetworks);
                    }
                    finally {
                        networkLock.unlock();
                    }
                    partitionResults.set(partitionNum, this.runSimulationsOnAllComponents(lfNetworks, propagatedContingencies, parameters, securityAnalysisParameters, operatorStrategies, actions, limitReductions, lfParameters));
                    return null;
                }, (Executor)executor));
            }
            try {
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get();
            }
            catch (InterruptedException e) {
                Iterator iterator = futures.iterator();
                while (iterator.hasNext()) {
                    CompletableFuture future = (CompletableFuture)iterator.next();
                    future.cancel(true);
                }
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.network.getVariantManager().allowVariantMultiThreadAccess(oldAllowVariantMultiThreadAccess);
        }
        int networkRank = 0;
        for (LfNetworkList lfNetworks : lfNetworksList) {
            if (networkRank != 0) {
                this.mergeReportThreadResults(saReportNode, reportNodes.get(networkRank));
            }
            lfNetworks.close();
            ++networkRank;
        }
        ArrayList postContingencyResults = new ArrayList();
        ArrayList operatorStrategyResults = new ArrayList();
        for (SecurityAnalysisResult partitionResult : partitionResults) {
            postContingencyResults.addAll(partitionResult.getPostContingencyResults());
            operatorStrategyResults.addAll(partitionResult.getOperatorStrategyResults());
        }
        finalResult = new SecurityAnalysisResult(partitionResults.get(0).getPreContingencyResult(), postContingencyResults, operatorStrategyResults);
        stopwatch.stop();
        LOGGER.info("Security analysis {} in {} ms", (Object)(Thread.currentThread().isInterrupted() ? "cancelled" : "done"), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return new SecurityAnalysisReport(finalResult);
    }

    private void mergeReportThreadResults(ReportNode mainReport, ReportNode toMerge) {
        Map<LfNetworkId, ReportNode> mainNodes = mainReport.getChildren().stream().filter(r -> r.getMessageKey().equals("olf.lfNetwork")).collect(Collectors.toMap(n -> new LfNetworkId(((TypedValue)n.getValue("networkNumCc").orElseThrow()).getValue(), ((TypedValue)n.getValue("networkNumSc").orElseThrow()).getValue()), n -> n));
        Map<LfNetworkId, ReportNode> toMergeNodes = toMerge.getChildren().stream().filter(r -> r.getMessageKey().equals("olf.lfNetwork")).collect(Collectors.toMap(n -> new LfNetworkId(((TypedValue)n.getValue("networkNumCc").orElseThrow()).getValue(), ((TypedValue)n.getValue("networkNumSc").orElseThrow()).getValue()), n -> n));
        for (Map.Entry<LfNetworkId, ReportNode> entry : mainNodes.entrySet()) {
            ReportNode mainReportNode = entry.getValue();
            ReportNode toMergeNode = toMergeNodes.get(entry.getKey());
            toMergeNode.getChildren().stream().filter(n -> n.getMessageKey().equals("olf.postContingencySimulation")).forEach(arg_0 -> ((ReportNode)mainReportNode).addCopy(arg_0));
        }
    }

    SecurityAnalysisResult runSimulationsOnAllComponents(LfNetworkList networks, List<PropagatedContingency> propagatedContingencies, P parameters, SecurityAnalysisParameters securityAnalysisParameters, List<OperatorStrategy> operatorStrategies, List<Action> actions, List<LimitReduction> limitReductions, LoadFlowParameters lfParameters) {
        ArrayList<LfNetwork> networkToSimulate = new ArrayList<LfNetwork>(AbstractSecurityAnalysis.getNetworksToSimulate(networks, lfParameters.getConnectedComponentMode()));
        OpenSecurityAnalysisParameters openSecurityAnalysisParameters = OpenSecurityAnalysisParameters.getOrDefault(securityAnalysisParameters);
        ContingencyActivePowerLossDistribution contingencyActivePowerLossDistribution = ContingencyActivePowerLossDistribution.find(openSecurityAnalysisParameters.getContingencyActivePowerLossDistribution());
        if (networkToSimulate.isEmpty()) {
            return AbstractSecurityAnalysis.createNoResult();
        }
        LfNetwork firstNetwork = (LfNetwork)networkToSimulate.remove(0);
        SecurityAnalysisResult result = this.runSimulations(firstNetwork, propagatedContingencies, parameters, securityAnalysisParameters, operatorStrategies, actions, limitReductions, contingencyActivePowerLossDistribution);
        List postContingencyResults = result.getPostContingencyResults();
        List operatorStrategyResults = result.getOperatorStrategyResults();
        NetworkResult mergedPreContingencyNetworkResult = result.getPreContingencyResult().getNetworkResult();
        ArrayList preContingencyViolations = result.getPreContingencyResult().getLimitViolationsResult().getLimitViolations();
        LinkedHashMap<String, PostContingencyResult> postContingencyResultMap = new LinkedHashMap<String, PostContingencyResult>();
        LinkedHashMap<String, OperatorStrategyResult> operatorStrategyResultMap = new LinkedHashMap<String, OperatorStrategyResult>();
        postContingencyResults.forEach(r -> postContingencyResultMap.put(r.getContingency().getId(), (PostContingencyResult)r));
        operatorStrategyResults.forEach(r -> operatorStrategyResultMap.put(r.getOperatorStrategy().getId(), (OperatorStrategyResult)r));
        preContingencyViolations = new ArrayList(preContingencyViolations);
        for (LfNetwork n : networkToSimulate) {
            SecurityAnalysisResult resultOtherComponent = this.runSimulations(n, propagatedContingencies, parameters, securityAnalysisParameters, operatorStrategies, actions, limitReductions, contingencyActivePowerLossDistribution);
            preContingencyViolations.addAll(resultOtherComponent.getPreContingencyResult().getLimitViolationsResult().getLimitViolations());
            mergedPreContingencyNetworkResult = AbstractSecurityAnalysis.mergeNetworkResult(mergedPreContingencyNetworkResult, resultOtherComponent.getPreContingencyResult().getNetworkResult());
            this.mergeSecurityAnalysisResult(resultOtherComponent, postContingencyResultMap, operatorStrategyResultMap, n.getNumCC());
        }
        postContingencyResults = postContingencyResultMap.values().stream().toList();
        operatorStrategyResults = operatorStrategyResultMap.values().stream().toList();
        PreContingencyResult mergedPrecontingencyResult = new PreContingencyResult(result.getPreContingencyResult().getStatus(), new LimitViolationsResult(preContingencyViolations), mergedPreContingencyNetworkResult);
        return new SecurityAnalysisResult(mergedPrecontingencyResult, postContingencyResults, operatorStrategyResults);
    }

    static List<LfNetwork> getNetworksToSimulate(LfNetworkList networks, LoadFlowParameters.ConnectedComponentMode mode) {
        if (LoadFlowParameters.ConnectedComponentMode.MAIN.equals((Object)mode)) {
            return networks.getList().stream().filter(n -> n.getNumCC() == 0 && n.getValidity().equals((Object)LfNetwork.Validity.VALID)).toList();
        }
        if (LoadFlowParameters.ConnectedComponentMode.ALL.equals((Object)mode)) {
            return networks.getList().stream().filter(n -> n.getValidity().equals((Object)LfNetwork.Validity.VALID)).toList();
        }
        throw new PowsyblException("Unsupported ConnectedComponentMode " + mode);
    }

    void mergeSecurityAnalysisResult(SecurityAnalysisResult resultToMerge, Map<String, PostContingencyResult> postContingencyResults, Map<String, OperatorStrategyResult> operatorStrategyResults, int connectedComponentNum) {
        resultToMerge.getPostContingencyResults().forEach(postContingencyResult -> {
            String contingencyId = postContingencyResult.getContingency().getId();
            PostContingencyResult originalResult = (PostContingencyResult)postContingencyResults.get(contingencyId);
            if (originalResult != null) {
                this.warnDifferentStatus(originalResult.getStatus(), postContingencyResult.getStatus(), connectedComponentNum, "post contingency", postContingencyResult.getContingency().getId());
                NetworkResult mergedNetworkResult = AbstractSecurityAnalysis.mergeNetworkResult(originalResult.getNetworkResult(), postContingencyResult.getNetworkResult());
                ArrayList violations = new ArrayList(postContingencyResult.getLimitViolationsResult().getLimitViolations());
                violations.addAll(originalResult.getLimitViolationsResult().getLimitViolations());
                PostContingencyResult mergedPostContingencyResult = new PostContingencyResult(originalResult.getContingency(), originalResult.getStatus(), new LimitViolationsResult(violations), mergedNetworkResult, originalResult.getConnectivityResult());
                postContingencyResults.put(contingencyId, mergedPostContingencyResult);
            } else {
                postContingencyResults.put(contingencyId, (PostContingencyResult)postContingencyResult);
            }
        });
        resultToMerge.getOperatorStrategyResults().forEach(operatorStrategyResult -> {
            String strategyId = operatorStrategyResult.getOperatorStrategy().getId();
            OperatorStrategyResult originalResult = (OperatorStrategyResult)operatorStrategyResults.get(strategyId);
            if (originalResult != null) {
                ArrayList conditionalActionsResults = new ArrayList();
                operatorStrategyResult.getConditionalActionsResults().forEach(conditionalActionsResult -> {
                    Optional<OperatorStrategyResult.ConditionalActionsResult> originalRes = originalResult.getConditionalActionsResults().stream().filter(originalConditionalActionResult -> originalConditionalActionResult.getConditionalActionsId().equals(conditionalActionsResult.getConditionalActionsId())).findAny();
                    if (originalRes.isPresent()) {
                        this.warnDifferentStatus(originalRes.get().getStatus(), conditionalActionsResult.getStatus(), connectedComponentNum, "conditional actions", conditionalActionsResult.getConditionalActionsId());
                        NetworkResult mergedNetworkResult = AbstractSecurityAnalysis.mergeNetworkResult(originalRes.get().getNetworkResult(), conditionalActionsResult.getNetworkResult());
                        ArrayList violations = new ArrayList(conditionalActionsResult.getLimitViolationsResult().getLimitViolations());
                        violations.addAll(originalResult.getLimitViolationsResult().getLimitViolations());
                        OperatorStrategyResult.ConditionalActionsResult mergedConditionalActionResult = new OperatorStrategyResult.ConditionalActionsResult(conditionalActionsResult.getConditionalActionsId(), conditionalActionsResult.getStatus(), new LimitViolationsResult(violations), mergedNetworkResult);
                        conditionalActionsResults.add(mergedConditionalActionResult);
                    } else {
                        conditionalActionsResults.add(conditionalActionsResult);
                    }
                });
                operatorStrategyResults.put(strategyId, new OperatorStrategyResult(originalResult.getOperatorStrategy(), conditionalActionsResults));
            } else {
                operatorStrategyResults.put(strategyId, (OperatorStrategyResult)operatorStrategyResult);
            }
        });
    }

    void warnDifferentStatus(PostContingencyComputationStatus mainStatus, PostContingencyComputationStatus subComponentStatus, int subComponentNum, String stage, String stageId) {
        if (mainStatus != subComponentStatus) {
            LOGGER.warn("Component {} {} {} result being merged has status {} while main connected component has status {}. Status of component {} will not be represented in the output.", new Object[]{subComponentNum, stage, stageId, subComponentStatus, mainStatus, subComponentNum});
        }
    }

    private static <T> ArrayList<T> ensureMutable(List<T> orig) {
        ArrayList<T> arrayList;
        if (orig instanceof ArrayList) {
            ArrayList arrayList2 = (ArrayList)orig;
            arrayList = arrayList2;
        } else {
            arrayList = new ArrayList<T>(orig);
        }
        return arrayList;
    }

    static NetworkResult mergeNetworkResult(NetworkResult source, NetworkResult target) {
        ArrayList branchResults = AbstractSecurityAnalysis.ensureMutable(source.getBranchResults());
        ArrayList twtResults = AbstractSecurityAnalysis.ensureMutable(source.getThreeWindingsTransformerResults());
        ArrayList busResults = AbstractSecurityAnalysis.ensureMutable(source.getBusResults());
        branchResults.addAll(target.getBranchResults());
        twtResults.addAll(target.getThreeWindingsTransformerResults());
        busResults.addAll(target.getBusResults());
        return new NetworkResult(branchResults, busResults, twtResults);
    }

    protected abstract PostContingencyComputationStatus postContingencyStatusFromLoadFlowResult(R var1);

    protected static void checkActions(Network network, List<Action> actions) {
        block21: for (Action action : actions) {
            switch (action.getType()) {
                case "SWITCH": {
                    SwitchAction switchAction = (SwitchAction)action;
                    if (network.getSwitch(switchAction.getSwitchId()) != null) continue block21;
                    throw new PowsyblException("Switch '" + switchAction.getSwitchId() + NOT_FOUND);
                }
                case "TERMINALS_CONNECTION": {
                    TerminalsConnectionAction terminalsConnectionAction = (TerminalsConnectionAction)action;
                    if (network.getBranch(terminalsConnectionAction.getElementId()) != null) continue block21;
                    throw new PowsyblException("Branch '" + terminalsConnectionAction.getElementId() + NOT_FOUND);
                }
                case "PHASE_TAP_CHANGER_TAP_POSITION": 
                case "RATIO_TAP_CHANGER_TAP_POSITION": {
                    String transformerId = action.getType().equals("PHASE_TAP_CHANGER_TAP_POSITION") ? ((PhaseTapChangerTapPositionAction)action).getTransformerId() : ((RatioTapChangerTapPositionAction)action).getTransformerId();
                    if (network.getTwoWindingsTransformer(transformerId) != null || network.getThreeWindingsTransformer(transformerId) != null) continue block21;
                    throw new PowsyblException("Transformer '" + transformerId + NOT_FOUND);
                }
                case "LOAD": {
                    LoadAction loadAction = (LoadAction)action;
                    if (network.getLoad(loadAction.getLoadId()) != null) continue block21;
                    throw new PowsyblException("Load '" + loadAction.getLoadId() + NOT_FOUND);
                }
                case "GENERATOR": {
                    GeneratorAction generatorAction = (GeneratorAction)action;
                    if (network.getGenerator(generatorAction.getGeneratorId()) != null) continue block21;
                    throw new PowsyblException("Generator '" + generatorAction.getGeneratorId() + NOT_FOUND);
                }
                case "HVDC": {
                    HvdcAction hvdcAction = (HvdcAction)action;
                    if (network.getHvdcLine(hvdcAction.getHvdcId()) != null) continue block21;
                    throw new PowsyblException("Hvdc line '" + hvdcAction.getHvdcId() + NOT_FOUND);
                }
                case "SHUNT_COMPENSATOR_POSITION": {
                    ShuntCompensatorPositionAction shuntCompensatorPositionAction = (ShuntCompensatorPositionAction)action;
                    if (network.getShuntCompensator(shuntCompensatorPositionAction.getShuntCompensatorId()) != null) continue block21;
                    throw new PowsyblException("Shunt compensator '" + shuntCompensatorPositionAction.getShuntCompensatorId() + "' not found");
                }
                case "AREA_INTERCHANGE_TARGET_ACTION": {
                    AreaInterchangeTargetAction areaInterchangeAction = (AreaInterchangeTargetAction)action;
                    if (network.getArea(areaInterchangeAction.getAreaId()) != null) continue block21;
                    throw new PowsyblException("Area '" + areaInterchangeAction.getAreaId() + "' not found");
                }
            }
            throw new UnsupportedOperationException("Unsupported action type: " + action.getType());
        }
    }

    protected static Map<String, LfAction> createLfActions(LfNetwork lfNetwork, Set<Action> actions, Network network, LfNetworkParameters parameters) {
        return actions.stream().map(action -> LfActionUtils.createLfAction(action, network, parameters.isBreakers(), lfNetwork)).collect(Collectors.toMap(LfAction::getId, Function.identity()));
    }

    protected static Map<String, Action> indexActionsById(List<Action> actions) {
        return actions.stream().collect(Collectors.toMap(Action::getId, Function.identity(), (action1, action2) -> {
            throw new PowsyblException("An action '" + action1.getId() + "' already exist");
        }));
    }

    private static boolean hasValidContingency(OperatorStrategy operatorStrategy, Set<String> contingencyIds) {
        return contingencyIds.contains(operatorStrategy.getContingencyContext().getContingencyId());
    }

    private static Optional<String> findMissingActionId(OperatorStrategy operatorStrategy, Set<String> actionIds) {
        for (ConditionalActions conditionalActions : operatorStrategy.getConditionalActions()) {
            for (String actionId : conditionalActions.getActionIds()) {
                if (actionIds.contains(actionId)) continue;
                return Optional.of(actionId);
            }
        }
        return Optional.empty();
    }

    private static void throwMissingOperatorStrategyContingency(OperatorStrategy operatorStrategy) {
        throw new PowsyblException("Operator strategy '" + operatorStrategy.getId() + "' is associated to contingency '" + operatorStrategy.getContingencyContext().getContingencyId() + "' but this contingency is not present in the list");
    }

    private static void throwMissingOperatorStrategyAction(OperatorStrategy operatorStrategy, String actionId) {
        throw new PowsyblException("Operator strategy '" + operatorStrategy.getId() + "' is associated to action '" + actionId + "' but this action is not present in the list");
    }

    protected static Map<String, List<OperatorStrategy>> indexOperatorStrategiesByContingencyId(List<PropagatedContingency> propagatedContingencies, List<OperatorStrategy> operatorStrategies, Map<String, Action> actionsById, Set<Action> neededActions, boolean checkOperatorStrategies) {
        Set<String> contingencyIds = propagatedContingencies.stream().map(propagatedContingency -> propagatedContingency.getContingency().getId()).collect(Collectors.toSet());
        HashMap<String, List<OperatorStrategy>> operatorStrategiesByContingencyId = new HashMap<String, List<OperatorStrategy>>();
        Set<String> actionIds = actionsById.keySet();
        for (OperatorStrategy operatorStrategy : operatorStrategies) {
            if (AbstractSecurityAnalysis.hasValidContingency(operatorStrategy, contingencyIds)) {
                if (checkOperatorStrategies) {
                    AbstractSecurityAnalysis.findMissingActionId(operatorStrategy, actionIds).ifPresent(id -> AbstractSecurityAnalysis.throwMissingOperatorStrategyAction(operatorStrategy, id));
                }
                for (ConditionalActions conditionalActions : operatorStrategy.getConditionalActions()) {
                    for (String actionId : conditionalActions.getActionIds()) {
                        Action action = actionsById.get(actionId);
                        neededActions.add(action);
                    }
                }
                operatorStrategiesByContingencyId.computeIfAbsent(operatorStrategy.getContingencyContext().getContingencyId(), key -> new ArrayList()).add(operatorStrategy);
                continue;
            }
            if (!checkOperatorStrategies) continue;
            AbstractSecurityAnalysis.throwMissingOperatorStrategyContingency(operatorStrategy);
        }
        return operatorStrategiesByContingencyId;
    }

    private static boolean checkCondition(ConditionalActions conditionalActions, Set<String> limitViolationEquipmentIds) {
        switch (conditionalActions.getCondition().getType()) {
            case "TRUE_CONDITION": {
                return true;
            }
            case "ANY_VIOLATION_CONDITION": {
                return !limitViolationEquipmentIds.isEmpty();
            }
            case "AT_LEAST_ONE_VIOLATION": {
                AtLeastOneViolationCondition atLeastCondition = (AtLeastOneViolationCondition)conditionalActions.getCondition();
                Set commonEquipmentIds = atLeastCondition.getViolationIds().stream().distinct().filter(limitViolationEquipmentIds::contains).collect(Collectors.toSet());
                return !commonEquipmentIds.isEmpty();
            }
            case "ALL_VIOLATION": {
                AllViolationCondition allCondition = (AllViolationCondition)conditionalActions.getCondition();
                Set commonEquipmentIds = allCondition.getViolationIds().stream().distinct().filter(limitViolationEquipmentIds::contains).collect(Collectors.toSet());
                return commonEquipmentIds.equals(new HashSet(allCondition.getViolationIds()));
            }
        }
        throw new UnsupportedOperationException("Unsupported condition type: " + conditionalActions.getCondition().getType());
    }

    protected List<String> checkCondition(OperatorStrategy operatorStrategy, LimitViolationsResult limitViolationsResult) {
        Set<String> limitViolationEquipmentIds = limitViolationsResult.getLimitViolations().stream().map(LimitViolation::getSubjectId).collect(Collectors.toSet());
        ArrayList<String> actionsIds = new ArrayList<String>();
        for (ConditionalActions conditionalActions : operatorStrategy.getConditionalActions()) {
            if (!AbstractSecurityAnalysis.checkCondition(conditionalActions, limitViolationEquipmentIds)) continue;
            actionsIds.addAll(conditionalActions.getActionIds());
        }
        return actionsIds;
    }

    protected static void findAllSwitchesToOperate(Network network, List<Action> actions, LfTopoConfig topoConfig) {
        actions.stream().filter(action -> action.getType().equals("SWITCH")).forEach(action -> {
            String switchId = ((SwitchAction)action).getSwitchId();
            Switch sw = network.getSwitch(switchId);
            boolean toOpen = ((SwitchAction)action).isOpen();
            if (sw.isOpen() && !toOpen) {
                topoConfig.getSwitchesToClose().add(sw);
            } else if (!sw.isOpen() && toOpen) {
                topoConfig.getSwitchesToOpen().add(sw);
            }
        });
    }

    protected static void findAllPtcToOperate(List<Action> actions, LfTopoConfig topoConfig) {
        for (Action action : actions) {
            if (!"PHASE_TAP_CHANGER_TAP_POSITION".equals(action.getType())) continue;
            PhaseTapChangerTapPositionAction ptcAction = (PhaseTapChangerTapPositionAction)action;
            ptcAction.getSide().ifPresentOrElse(side -> topoConfig.addBranchIdWithPtcToRetain(LfLegBranch.getId(side, ptcAction.getTransformerId())), () -> topoConfig.addBranchIdWithPtcToRetain(ptcAction.getTransformerId()));
        }
    }

    protected static void findAllRtcToOperate(List<Action> actions, LfTopoConfig topoConfig) {
        for (Action action : actions) {
            if (!"RATIO_TAP_CHANGER_TAP_POSITION".equals(action.getType())) continue;
            RatioTapChangerTapPositionAction rtcAction = (RatioTapChangerTapPositionAction)action;
            rtcAction.getSide().ifPresentOrElse(side -> topoConfig.addBranchIdWithRtcToRetain(LfLegBranch.getId(side, rtcAction.getTransformerId())), () -> topoConfig.addBranchIdWithRtcToRetain(rtcAction.getTransformerId()));
        }
    }

    protected static void findAllShuntsToOperate(List<Action> actions, LfTopoConfig topoConfig) {
        actions.stream().filter(action -> action.getType().equals("SHUNT_COMPENSATOR_POSITION")).forEach(action -> topoConfig.addShuntIdToOperate(((ShuntCompensatorPositionAction)action).getShuntCompensatorId()));
    }

    protected static void findAllBranchesToClose(Network network, List<Action> actions, LfTopoConfig topoConfig) {
        for (Action action : actions) {
            Branch branch;
            TerminalsConnectionAction terminalsConnectionAction;
            if (!"TERMINALS_CONNECTION".equals(action.getType()) || !(terminalsConnectionAction = (TerminalsConnectionAction)action).getSide().isEmpty() || terminalsConnectionAction.isOpen() || (branch = network.getBranch(terminalsConnectionAction.getElementId())) == null || branch instanceof TieLine || branch.getTerminal1().isConnected() || branch.getTerminal2().isConnected()) continue;
            topoConfig.getBranchIdsToClose().add(terminalsConnectionAction.getElementId());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isAreaInterchangeControl(OpenLoadFlowParameters lfParametersExt, List<Contingency> contingencies) {
        if (lfParametersExt.isAreaInterchangeControl()) return true;
        if (!contingencies.stream().map(contingency -> contingency.getExtension(ContingencyLoadFlowParameters.class)).filter(Objects::nonNull).map(ContingencyLoadFlowParameters.class::cast).anyMatch(contingencyParameters -> contingencyParameters.isAreaInterchangeControl().orElse(false))) return false;
        return true;
    }

    protected abstract C createLoadFlowContext(LfNetwork var1, P var2);

    protected abstract LoadFlowEngine<V, E, P, R> createLoadFlowEngine(C var1);

    protected void afterPreContingencySimulation(P acParameters) {
    }

    protected SecurityAnalysisResult runSimulations(LfNetwork lfNetwork, List<PropagatedContingency> propagatedContingencies, P acParameters, SecurityAnalysisParameters securityAnalysisParameters, List<OperatorStrategy> operatorStrategies, List<Action> actions, List<LimitReduction> limitReductions, ContingencyActivePowerLossDistribution contingencyActivePowerLossDistribution) {
        Map<String, Action> actionsById = AbstractSecurityAnalysis.indexActionsById(actions);
        HashSet<Action> neededActions = new HashSet<Action>(actionsById.size());
        boolean checkOperatorStrategies = OpenSecurityAnalysisParameters.getOrDefault(securityAnalysisParameters).getThreadCount() == 1;
        Map<String, List<OperatorStrategy>> operatorStrategiesByContingencyId = AbstractSecurityAnalysis.indexOperatorStrategiesByContingencyId(propagatedContingencies, operatorStrategies, actionsById, neededActions, checkOperatorStrategies);
        Map<String, LfAction> lfActionById = AbstractSecurityAnalysis.createLfActions(lfNetwork, neededActions, this.network, ((AbstractLoadFlowParameters)acParameters).getNetworkParameters());
        LoadFlowParameters loadFlowParameters = securityAnalysisParameters.getLoadFlowParameters();
        OpenLoadFlowParameters openLoadFlowParameters = OpenLoadFlowParameters.get(loadFlowParameters);
        OpenSecurityAnalysisParameters openSecurityAnalysisParameters = OpenSecurityAnalysisParameters.getOrDefault(securityAnalysisParameters);
        boolean createResultExtension = openSecurityAnalysisParameters.isCreateResultExtension();
        try (C context = this.createLoadFlowContext(lfNetwork, acParameters);){
            ReportNode networkReportNode = lfNetwork.getReportNode();
            ReportNode preContSimReportNode = Reports.createPreContingencySimulation(networkReportNode);
            lfNetwork.setReportNode(preContSimReportNode);
            R preContingencyLoadFlowResult = this.createLoadFlowEngine(context).run();
            boolean preContingencyComputationOk = preContingencyLoadFlowResult.isSuccess();
            LimitViolationManager preContingencyLimitViolationManager = new LimitViolationManager(limitReductions);
            ArrayList postContingencyResults = new ArrayList();
            PreContingencyNetworkResult preContingencyNetworkResult = new PreContingencyNetworkResult(lfNetwork, this.monitorIndex, createResultExtension);
            ArrayList operatorStrategyResults = new ArrayList();
            if (preContingencyComputationOk) {
                this.afterPreContingencySimulation(acParameters);
                preContingencyNetworkResult.update();
                preContingencyLimitViolationManager.detectViolations(lfNetwork);
                NetworkState networkState = NetworkState.save(lfNetwork);
                Consumer<P> parametersResetter = this.createParametersResetter(acParameters);
                Iterator<PropagatedContingency> contingencyIt = propagatedContingencies.iterator();
                while (contingencyIt.hasNext() && !Thread.currentThread().isInterrupted()) {
                    PropagatedContingency propagatedContingency = contingencyIt.next();
                    propagatedContingency.toLfContingency(lfNetwork).ifPresent(lfContingency -> {
                        ReportNode postContSimReportNode = Reports.createPostContingencySimulation(networkReportNode, lfContingency.getId());
                        lfNetwork.setReportNode(postContSimReportNode);
                        ContingencyLoadFlowParameters contingencyLoadFlowParameters = (ContingencyLoadFlowParameters)propagatedContingency.getContingency().getExtension(ContingencyLoadFlowParameters.class);
                        if (contingencyLoadFlowParameters != null) {
                            this.applyContingencyParameters(context.getParameters(), contingencyLoadFlowParameters, loadFlowParameters, openLoadFlowParameters);
                        }
                        lfContingency.apply(loadFlowParameters.getBalanceType());
                        contingencyActivePowerLossDistribution.run(lfNetwork, (LfContingency)lfContingency, propagatedContingency.getContingency(), securityAnalysisParameters, contingencyLoadFlowParameters, postContSimReportNode);
                        PostContingencyResult postContingencyResult = this.runPostContingencySimulation(lfNetwork, context, propagatedContingency.getContingency(), (LfContingency)lfContingency, preContingencyLimitViolationManager, securityAnalysisParameters.getIncreasedViolationsParameters(), preContingencyNetworkResult, createResultExtension, limitReductions);
                        postContingencyResults.add(postContingencyResult);
                        List operatorStrategiesForThisContingency = (List)operatorStrategiesByContingencyId.get(lfContingency.getId());
                        if (operatorStrategiesForThisContingency != null) {
                            if (operatorStrategiesForThisContingency.size() == 1) {
                                lfNetwork.setGeneratorsInitialTargetPToTargetP();
                                OperatorStrategy operatorStrategy = (OperatorStrategy)operatorStrategiesForThisContingency.get(0);
                                ReportNode osSimReportNode = Reports.createOperatorStrategySimulation(postContSimReportNode, operatorStrategy.getId());
                                lfNetwork.setReportNode(osSimReportNode);
                                this.runActionSimulation(lfNetwork, context, operatorStrategy, preContingencyLimitViolationManager, securityAnalysisParameters.getIncreasedViolationsParameters(), lfActionById, createResultExtension, (LfContingency)lfContingency, postContingencyResult.getLimitViolationsResult(), acParameters.getNetworkParameters(), limitReductions).ifPresent(operatorStrategyResults::add);
                            } else {
                                NetworkState postContingencyNetworkState = NetworkState.save(lfNetwork);
                                for (OperatorStrategy operatorStrategy : operatorStrategiesForThisContingency) {
                                    ReportNode osSimReportNode = Reports.createOperatorStrategySimulation(postContSimReportNode, operatorStrategy.getId());
                                    lfNetwork.setReportNode(osSimReportNode);
                                    this.runActionSimulation(lfNetwork, context, operatorStrategy, preContingencyLimitViolationManager, securityAnalysisParameters.getIncreasedViolationsParameters(), lfActionById, createResultExtension, (LfContingency)lfContingency, postContingencyResult.getLimitViolationsResult(), acParameters.getNetworkParameters(), limitReductions).ifPresent(result -> {
                                        operatorStrategyResults.add(result);
                                        postContingencyNetworkState.restore();
                                    });
                                }
                            }
                        }
                        if (contingencyIt.hasNext()) {
                            networkState.restore();
                            if (contingencyLoadFlowParameters != null) {
                                parametersResetter.accept(context.getParameters());
                            }
                        }
                    });
                }
            }
            SecurityAnalysisResult securityAnalysisResult = new SecurityAnalysisResult(new PreContingencyResult(preContingencyLoadFlowResult.toComponentResultStatus().status(), new LimitViolationsResult(preContingencyLimitViolationManager.getLimitViolations()), preContingencyNetworkResult.getBranchResults(), preContingencyNetworkResult.getBusResults(), preContingencyNetworkResult.getThreeWindingsTransformerResults()), postContingencyResults, operatorStrategyResults);
            return securityAnalysisResult;
        }
    }

    protected abstract Consumer<P> createParametersResetter(P var1);

    protected abstract void applyContingencyParameters(P var1, ContingencyLoadFlowParameters var2, LoadFlowParameters var3, OpenLoadFlowParameters var4);

    private Optional<OperatorStrategyResult> runActionSimulation(LfNetwork network, C context, OperatorStrategy operatorStrategy, LimitViolationManager preContingencyLimitViolationManager, SecurityAnalysisParameters.IncreasedViolationsParameters violationsParameters, Map<String, LfAction> lfActionById, boolean createResultExtension, LfContingency contingency, LimitViolationsResult postContingencyLimitViolations, LfNetworkParameters networkParameters, List<LimitReduction> limitReductions) {
        OperatorStrategyResult operatorStrategyResult = null;
        List<String> actionIds = this.checkCondition(operatorStrategy, postContingencyLimitViolations);
        if (!actionIds.isEmpty()) {
            operatorStrategyResult = this.runActionSimulation(network, context, operatorStrategy, actionIds, preContingencyLimitViolationManager, violationsParameters, lfActionById, createResultExtension, contingency, networkParameters, limitReductions);
        }
        return Optional.ofNullable(operatorStrategyResult);
    }

    protected PostContingencyResult runPostContingencySimulation(LfNetwork network, C context, Contingency contingency, LfContingency lfContingency, LimitViolationManager preContingencyLimitViolationManager, SecurityAnalysisParameters.IncreasedViolationsParameters violationsParameters, PreContingencyNetworkResult preContingencyNetworkResult, boolean createResultExtension, List<LimitReduction> limitReductions) {
        this.logPostContingencyStart(network, lfContingency);
        Stopwatch stopwatch = Stopwatch.createStarted();
        PostContingencyComputationStatus status = this.runActionLoadFlow(context);
        LimitViolationManager postContingencyLimitViolationManager = new LimitViolationManager(preContingencyLimitViolationManager, limitReductions, violationsParameters);
        PostContingencyNetworkResult postContingencyNetworkResult = new PostContingencyNetworkResult(network, this.monitorIndex, createResultExtension, preContingencyNetworkResult, contingency);
        if (status.equals((Object)PostContingencyComputationStatus.CONVERGED)) {
            postContingencyNetworkResult.update();
            postContingencyLimitViolationManager.detectViolations(network);
        }
        stopwatch.stop();
        this.logPostContingencyEnd(network, lfContingency, stopwatch);
        ConnectivityResult connectivityResult = new ConnectivityResult(lfContingency.getCreatedSynchronousComponentsCount(), 0, lfContingency.getDisconnectedLoadActivePower() * 100.0, lfContingency.getDisconnectedGenerationActivePower() * 100.0, lfContingency.getDisconnectedElementIds());
        return new PostContingencyResult(contingency, status, new LimitViolationsResult(postContingencyLimitViolationManager.getLimitViolations()), postContingencyNetworkResult.getBranchResults(), postContingencyNetworkResult.getBusResults(), postContingencyNetworkResult.getThreeWindingsTransformerResults(), connectivityResult);
    }

    protected void logPostContingencyStart(LfNetwork network, LfContingency lfContingency) {
        LOGGER.atLevel(this.logLevel).log("Start post contingency '{}' simulation on network {}", (Object)lfContingency.getId(), (Object)network);
        LOGGER.debug("Contingency '{}' impact on network {}: remove {} buses, remove {} branches, remove {} generators, shift {} shunts, shift {} loads", new Object[]{lfContingency.getId(), network, lfContingency.getDisabledNetwork().getBuses(), lfContingency.getDisabledNetwork().getBranchesStatus(), lfContingency.getLostGenerators(), lfContingency.getShuntsShift(), lfContingency.getLostLoads()});
    }

    protected void logPostContingencyEnd(LfNetwork network, LfContingency lfContingency, Stopwatch stopwatch) {
        LOGGER.atLevel(this.logLevel).log("Post contingency '{}' simulation done on network {} in {} ms", new Object[]{lfContingency.getId(), network, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
    }

    protected OperatorStrategyResult runActionSimulation(LfNetwork network, C context, OperatorStrategy operatorStrategy, List<String> actionsIds, LimitViolationManager preContingencyLimitViolationManager, SecurityAnalysisParameters.IncreasedViolationsParameters violationsParameters, Map<String, LfAction> lfActionById, boolean createResultExtension, LfContingency contingency, LfNetworkParameters networkParameters, List<LimitReduction> limitReductions) {
        this.logActionStart(network, operatorStrategy);
        List<LfAction> operatorStrategyLfActions = actionsIds.stream().map(lfActionById::get).filter(Objects::nonNull).toList();
        LfActionUtils.applyListOfActions(operatorStrategyLfActions, network, contingency, networkParameters);
        Stopwatch stopwatch = Stopwatch.createStarted();
        PostContingencyComputationStatus status = this.runActionLoadFlow(context);
        LimitViolationManager postActionsViolationManager = new LimitViolationManager(preContingencyLimitViolationManager, limitReductions, violationsParameters);
        PreContingencyNetworkResult postActionsNetworkResult = new PreContingencyNetworkResult(network, this.monitorIndex, createResultExtension);
        if (status.equals((Object)PostContingencyComputationStatus.CONVERGED)) {
            postActionsNetworkResult.update();
            postActionsViolationManager.detectViolations(network);
        }
        stopwatch.stop();
        this.logActionEnd(network, operatorStrategy, stopwatch);
        return new OperatorStrategyResult(operatorStrategy, status, new LimitViolationsResult(postActionsViolationManager.getLimitViolations()), new NetworkResult(postActionsNetworkResult.getBranchResults(), postActionsNetworkResult.getBusResults(), postActionsNetworkResult.getThreeWindingsTransformerResults()));
    }

    protected void logActionStart(LfNetwork network, OperatorStrategy operatorStrategy) {
        LOGGER.atLevel(this.logLevel).log("Start operator strategy {} after contingency '{}' simulation on network {}", new Object[]{operatorStrategy.getId(), operatorStrategy.getContingencyContext().getContingencyId(), network});
    }

    protected void logActionEnd(LfNetwork network, OperatorStrategy operatorStrategy, Stopwatch stopwatch) {
        LOGGER.atLevel(this.logLevel).log("Operator strategy {} after contingency '{}' simulation done on network {} in {} ms", new Object[]{operatorStrategy.getId(), operatorStrategy.getContingencyContext().getContingencyId(), network, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
    }

    protected void beforeActionLoadFlowRun(C context) {
    }

    protected PostContingencyComputationStatus runActionLoadFlow(C context) {
        this.beforeActionLoadFlowRun(context);
        R result = this.createLoadFlowEngine(context).run();
        return this.postContingencyStatusFromLoadFlowResult(result);
    }

    private record LfNetworkId(Object numCC, Object numSC) {
    }
}

