/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.dc.DcLoadFlowContext;
import com.powsybl.openloadflow.dc.DcLoadFlowEngine;
import com.powsybl.openloadflow.dc.DcLoadFlowParameters;
import com.powsybl.openloadflow.dc.DcLoadFlowResult;
import com.powsybl.openloadflow.dc.DcOuterLoop;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.graph.GraphConnectivityFactory;
import com.powsybl.openloadflow.lf.outerloop.config.AbstractDcOuterLoopConfig;
import com.powsybl.openloadflow.lf.outerloop.config.DcOuterLoopConfig;
import com.powsybl.openloadflow.lf.outerloop.config.DefaultDcOuterLoopConfig;
import com.powsybl.openloadflow.lf.outerloop.config.ExplicitDcOuterLoopConfig;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.ReferenceBusSelector;
import com.powsybl.openloadflow.sa.AbstractSecurityAnalysis;
import com.powsybl.openloadflow.sa.extensions.ContingencyLoadFlowParameters;
import com.powsybl.openloadflow.util.Reports;
import com.powsybl.security.PostContingencyComputationStatus;
import com.powsybl.security.monitor.StateMonitor;
import java.util.List;
import java.util.function.Consumer;

public class DcSecurityAnalysis
extends AbstractSecurityAnalysis<DcVariableType, DcEquationType, DcLoadFlowParameters, DcLoadFlowContext, DcLoadFlowResult> {
    protected DcSecurityAnalysis(Network network, MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory, List<StateMonitor> stateMonitors, ReportNode reportNode) {
        super(network, matrixFactory, connectivityFactory, stateMonitors, reportNode);
    }

    @Override
    protected LoadFlowModel getLoadFlowModel() {
        return LoadFlowModel.DC;
    }

    @Override
    protected ReportNode createSaRootReportNode() {
        return Reports.createDcSecurityAnalysis(this.reportNode, this.network.getId());
    }

    @Override
    protected boolean isShuntCompensatorVoltageControlOn(LoadFlowParameters lfParameters) {
        return false;
    }

    @Override
    protected DcLoadFlowParameters createParameters(LoadFlowParameters lfParameters, OpenLoadFlowParameters lfParametersExt, boolean breakers, boolean areas) {
        DcLoadFlowParameters dcParameters = OpenLoadFlowParameters.createDcParameters(this.network, lfParameters, lfParametersExt, this.matrixFactory, this.connectivityFactory, false);
        dcParameters.getNetworkParameters().setBreakers(breakers).setCacheEnabled(false).setReferenceBusSelector(ReferenceBusSelector.DEFAULT_SELECTOR).setAreaInterchangeControl(areas);
        return dcParameters;
    }

    @Override
    protected DcLoadFlowContext createLoadFlowContext(LfNetwork lfNetwork, DcLoadFlowParameters parameters) {
        return new DcLoadFlowContext(lfNetwork, parameters);
    }

    protected DcLoadFlowEngine createLoadFlowEngine(DcLoadFlowContext context) {
        return new DcLoadFlowEngine(context);
    }

    @Override
    protected PostContingencyComputationStatus postContingencyStatusFromLoadFlowResult(DcLoadFlowResult result) {
        return result.isSuccess() ? PostContingencyComputationStatus.CONVERGED : PostContingencyComputationStatus.FAILED;
    }

    @Override
    protected Consumer<DcLoadFlowParameters> createParametersResetter(DcLoadFlowParameters parameters) {
        boolean oldDistributedSlack = parameters.isDistributedSlack();
        LoadFlowParameters.BalanceType oldBalanceType = parameters.getBalanceType();
        List<DcOuterLoop> oldOuterLoops = List.copyOf(parameters.getOuterLoops());
        return p -> {
            p.setDistributedSlack(oldDistributedSlack);
            p.setBalanceType(oldBalanceType);
            p.setOuterLoops(oldOuterLoops);
        };
    }

    @Override
    protected void applyContingencyParameters(DcLoadFlowParameters parameters, ContingencyLoadFlowParameters contingencyParameters, LoadFlowParameters loadFlowParameters, OpenLoadFlowParameters openLoadFlowParameters) {
        DcOuterLoopConfig outerLoopConfig = AbstractDcOuterLoopConfig.getOuterLoopConfig().orElseGet(() -> contingencyParameters.getOuterLoopNames().isPresent() ? new ExplicitDcOuterLoopConfig() : new DefaultDcOuterLoopConfig());
        parameters.setOuterLoops(outerLoopConfig.configure(loadFlowParameters, openLoadFlowParameters, contingencyParameters));
        contingencyParameters.isDistributedSlack().ifPresent(parameters::setDistributedSlack);
        contingencyParameters.getBalanceType().ifPresent(parameters::setBalanceType);
    }
}

