/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa;

import com.google.auto.service.AutoService;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.contingency.Contingency;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.openloadflow.LoadFlowParametersOverride;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.network.LfContingency;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.util.ActivePowerDistribution;
import com.powsybl.openloadflow.sa.ContingencyActivePowerLossDistribution;
import com.powsybl.openloadflow.util.Reports;
import com.powsybl.security.SecurityAnalysisParameters;
import java.util.Objects;

@AutoService(value={ContingencyActivePowerLossDistribution.class})
public class DefaultContingencyActivePowerLossDistribution
implements ContingencyActivePowerLossDistribution {
    @Override
    public String getName() {
        return "Default";
    }

    @Override
    public void run(LfNetwork network, LfContingency lfContingency, Contingency contingency, SecurityAnalysisParameters securityAnalysisParameters, LoadFlowParametersOverride loadFlowParametersOverride, ReportNode reportNode) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(lfContingency);
        Objects.requireNonNull(contingency);
        Objects.requireNonNull(securityAnalysisParameters);
        Objects.requireNonNull(reportNode);
        LoadFlowParametersOverride paramsOverride = Objects.requireNonNullElse(loadFlowParametersOverride, LoadFlowParametersOverride.NO_OVERRIDE);
        double mismatch = lfContingency.getActivePowerLoss();
        LoadFlowParameters loadFlowParameters = securityAnalysisParameters.getLoadFlowParameters();
        OpenLoadFlowParameters openLoadFlowParameters = OpenLoadFlowParameters.get(loadFlowParameters);
        if ((paramsOverride.isDistributedSlack(loadFlowParameters) || paramsOverride.isAreaInterchangeControl(openLoadFlowParameters)) && Math.abs(mismatch) > 0.0) {
            ActivePowerDistribution activePowerDistribution = ActivePowerDistribution.create(paramsOverride.getBalanceType(loadFlowParameters), openLoadFlowParameters.isLoadPowerFactorConstant(), openLoadFlowParameters.isUseActiveLimits());
            ActivePowerDistribution.Result result = activePowerDistribution.run(network, mismatch);
            Reports.reportContingencyActivePowerLossDistribution(reportNode, mismatch * 100.0, result.remainingMismatch() * 100.0);
        }
    }
}

