/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa;

import com.powsybl.contingency.ContingencyContextType;
import com.powsybl.iidm.criteria.AtLeastOneNominalVoltageCriterion;
import com.powsybl.iidm.criteria.IdentifiableCriterion;
import com.powsybl.iidm.criteria.VoltageInterval;
import com.powsybl.iidm.criteria.duration.AllTemporaryDurationCriterion;
import com.powsybl.iidm.criteria.duration.EqualityTemporaryDurationCriterion;
import com.powsybl.iidm.criteria.duration.IntervalTemporaryDurationCriterion;
import com.powsybl.iidm.criteria.duration.LimitDurationCriterion;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.security.limitreduction.LimitReduction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang3.DoubleRange;
import org.apache.commons.lang3.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitReductionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LimitReductionManager.class);
    private final List<TerminalLimitReduction> terminalLimitReductions = new ArrayList<TerminalLimitReduction>();

    public boolean isEmpty() {
        return this.terminalLimitReductions.isEmpty();
    }

    public List<TerminalLimitReduction> getTerminalLimitReductions() {
        return this.terminalLimitReductions;
    }

    public void addTerminalLimitReduction(TerminalLimitReduction terminalLimitReduction) {
        this.terminalLimitReductions.add(terminalLimitReduction);
    }

    public static LimitReductionManager create(List<LimitReduction> limitReductions) {
        LimitReductionManager limitReductionManager = new LimitReductionManager();
        for (LimitReduction limitReduction : limitReductions) {
            if (!LimitReductionManager.isSupported(limitReduction)) continue;
            boolean permanent = false;
            Range<Integer> acceptableDurationRange = null;
            if (limitReduction.getDurationCriteria().isEmpty()) {
                permanent = true;
                acceptableDurationRange = Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
            } else {
                for (LimitDurationCriterion limitDurationCriterion : limitReduction.getDurationCriteria()) {
                    LimitDurationCriterion.LimitDurationType type = limitDurationCriterion.getType();
                    if (Objects.requireNonNull(type) == LimitDurationCriterion.LimitDurationType.PERMANENT) {
                        permanent = true;
                        continue;
                    }
                    if (type != LimitDurationCriterion.LimitDurationType.TEMPORARY) continue;
                    acceptableDurationRange = LimitReductionManager.getAcceptableDurationRange(limitDurationCriterion);
                }
            }
            List<DoubleRange> nominalVoltageRanges = limitReduction.getNetworkElementCriteria().isEmpty() ? List.of(DoubleRange.of((double)0.0, (double)Double.MAX_VALUE)) : limitReduction.getNetworkElementCriteria().stream().map(IdentifiableCriterion.class::cast).map(IdentifiableCriterion::getNominalVoltageCriterion).map(AtLeastOneNominalVoltageCriterion::getVoltageInterval).map(VoltageInterval::asRange).distinct().toList();
            for (DoubleRange nominalVoltageRange : nominalVoltageRanges) {
                limitReductionManager.addTerminalLimitReduction(new TerminalLimitReduction((Range<Double>)nominalVoltageRange, permanent, acceptableDurationRange, limitReduction.getValue()));
            }
        }
        return limitReductionManager;
    }

    private static Range<Integer> getAcceptableDurationRange(LimitDurationCriterion limitDurationCriterion) {
        Range acceptableDurationRange;
        if (limitDurationCriterion instanceof AllTemporaryDurationCriterion) {
            acceptableDurationRange = Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
        } else if (limitDurationCriterion instanceof EqualityTemporaryDurationCriterion) {
            EqualityTemporaryDurationCriterion equalityTemporaryDurationCriterion = (EqualityTemporaryDurationCriterion)limitDurationCriterion;
            acceptableDurationRange = Range.of((Comparable)Integer.valueOf(equalityTemporaryDurationCriterion.getDurationEqualityValue()), (Comparable)Integer.valueOf(equalityTemporaryDurationCriterion.getDurationEqualityValue()));
        } else {
            IntervalTemporaryDurationCriterion intervalTemporaryDurationCriterion = (IntervalTemporaryDurationCriterion)limitDurationCriterion;
            acceptableDurationRange = intervalTemporaryDurationCriterion.asRange();
        }
        return acceptableDurationRange;
    }

    private static boolean isSupported(LimitReduction limitReduction) {
        if (limitReduction.getContingencyContext().getContextType() != ContingencyContextType.ALL) {
            LOGGER.warn("Only contingency context ALL is yet supported.");
            return false;
        }
        if (limitReduction.isMonitoringOnly()) {
            LOGGER.warn("Limit reductions for monitoring only is not yet supported.");
            return false;
        }
        if (limitReduction.getLimitType() != LimitType.CURRENT) {
            LOGGER.warn("Only limit reductions for current limits are yet supported.");
            return false;
        }
        if (limitReduction.getNetworkElementCriteria().stream().anyMatch(Predicate.not(IdentifiableCriterion.class::isInstance))) {
            LOGGER.warn("Only no network element criterion or identifiable criteria are yet supported.");
            return false;
        }
        if (limitReduction.getDurationCriteria().size() > 2) {
            LOGGER.warn("More than two duration criteria provided.");
            return false;
        }
        if (limitReduction.getDurationCriteria().size() == 2 && ((LimitDurationCriterion)limitReduction.getDurationCriteria().get(0)).getType() == ((LimitDurationCriterion)limitReduction.getDurationCriteria().get(1)).getType()) {
            LOGGER.warn("When two duration criteria are provided, they cannot be of the same type");
            return false;
        }
        return true;
    }

    public record TerminalLimitReduction(Range<Double> nominalV, boolean isPermanent, Range<Integer> acceptableDuration, double reduction) {
    }
}

