/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa;

import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.extensions.AbstractExtension;
import com.powsybl.openloadflow.sa.ContingencyActivePowerLossDistribution;
import com.powsybl.security.SecurityAnalysisParameters;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OpenSecurityAnalysisParameters
extends AbstractExtension<SecurityAnalysisParameters> {
    private boolean createResultExtension = false;
    private boolean contingencyPropagation = true;
    private int threadCount = 1;
    private boolean dcFastMode = false;
    private String contingencyActivePowerLossDistribution = "Default";
    public static final String CREATE_RESULT_EXTENSION_PARAM_NAME = "createResultExtension";
    public static final boolean CREATE_RESULT_EXTENSION_DEFAULT_VALUE = false;
    public static final String CONTINGENCY_PROPAGATION_PARAM_NAME = "contingencyPropagation";
    public static final boolean CONTINGENCY_PROPAGATION_DEFAULT_VALUE = true;
    public static final String THREAD_COUNT_PARAM_NAME = "threadCount";
    public static final int THREAD_COUNT_DEFAULT_VALUE = 1;
    public static final String DC_FAST_MODE_PARAM_NAME = "dcFastMode";
    public static final boolean DC_FAST_MODE_DEFAULT_VALUE = false;
    public static final String CONTINGENCY_ACTIVE_POWER_LOSS_DISTRIBUTION_PARAM_NAME = "contingencyActivePowerLossDistribution";
    public static final String CONTINGENCY_ACTIVE_POWER_LOSS_DISTRIBUTION_DEFAULT_VALUE = "Default";
    public static final List<String> SPECIFIC_PARAMETERS_NAMES = List.of("createResultExtension", "contingencyPropagation", "threadCount", "dcFastMode", "contingencyActivePowerLossDistribution");

    public String getName() {
        return "open-security-analysis-parameters";
    }

    public boolean isCreateResultExtension() {
        return this.createResultExtension;
    }

    public OpenSecurityAnalysisParameters setCreateResultExtension(boolean createResultExtension) {
        this.createResultExtension = createResultExtension;
        return this;
    }

    public boolean isContingencyPropagation() {
        return this.contingencyPropagation;
    }

    public OpenSecurityAnalysisParameters setContingencyPropagation(boolean contingencyPropagation) {
        this.contingencyPropagation = contingencyPropagation;
        return this;
    }

    public boolean isDcFastMode() {
        return this.dcFastMode;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public OpenSecurityAnalysisParameters setThreadCount(int threadCount) {
        if (threadCount < 1) {
            throw new IllegalArgumentException("Invalid thread count value: " + threadCount);
        }
        this.threadCount = threadCount;
        return this;
    }

    public OpenSecurityAnalysisParameters setDcFastMode(boolean dcFastMode) {
        this.dcFastMode = dcFastMode;
        return this;
    }

    public String getContingencyActivePowerLossDistribution() {
        return this.contingencyActivePowerLossDistribution;
    }

    public OpenSecurityAnalysisParameters setContingencyActivePowerLossDistribution(String contingencyActivePowerLossDistribution) {
        ContingencyActivePowerLossDistribution.find(contingencyActivePowerLossDistribution);
        this.contingencyActivePowerLossDistribution = contingencyActivePowerLossDistribution;
        return this;
    }

    public static OpenSecurityAnalysisParameters getOrDefault(SecurityAnalysisParameters parameters) {
        OpenSecurityAnalysisParameters parametersExt = (OpenSecurityAnalysisParameters)parameters.getExtension(OpenSecurityAnalysisParameters.class);
        if (parametersExt == null) {
            parametersExt = new OpenSecurityAnalysisParameters();
        }
        return parametersExt;
    }

    public static OpenSecurityAnalysisParameters load() {
        return OpenSecurityAnalysisParameters.load(PlatformConfig.defaultConfig());
    }

    public static OpenSecurityAnalysisParameters load(PlatformConfig platformConfig) {
        OpenSecurityAnalysisParameters parameters = new OpenSecurityAnalysisParameters();
        platformConfig.getOptionalModuleConfig("open-security-analysis-default-parameters").ifPresent(config -> parameters.setCreateResultExtension(config.getBooleanProperty(CREATE_RESULT_EXTENSION_PARAM_NAME, false)).setContingencyPropagation(config.getBooleanProperty(CONTINGENCY_PROPAGATION_PARAM_NAME, true)).setThreadCount(config.getIntProperty(THREAD_COUNT_PARAM_NAME, 1)).setDcFastMode(config.getBooleanProperty(DC_FAST_MODE_PARAM_NAME, false)).setContingencyActivePowerLossDistribution(config.getStringProperty(CONTINGENCY_ACTIVE_POWER_LOSS_DISTRIBUTION_PARAM_NAME, CONTINGENCY_ACTIVE_POWER_LOSS_DISTRIBUTION_DEFAULT_VALUE)));
        return parameters;
    }

    public static OpenSecurityAnalysisParameters load(Map<String, String> properties) {
        return new OpenSecurityAnalysisParameters().update(properties);
    }

    public OpenSecurityAnalysisParameters update(Map<String, String> properties) {
        Optional.ofNullable(properties.get(CREATE_RESULT_EXTENSION_PARAM_NAME)).ifPresent(value -> this.setCreateResultExtension(Boolean.parseBoolean(value)));
        Optional.ofNullable(properties.get(CONTINGENCY_PROPAGATION_PARAM_NAME)).ifPresent(value -> this.setContingencyPropagation(Boolean.parseBoolean(value)));
        Optional.ofNullable(properties.get(THREAD_COUNT_PARAM_NAME)).ifPresent(value -> this.setThreadCount(Integer.parseInt(value)));
        Optional.ofNullable(properties.get(DC_FAST_MODE_PARAM_NAME)).ifPresent(value -> this.setDcFastMode(Boolean.parseBoolean(value)));
        Optional.ofNullable(properties.get(CONTINGENCY_ACTIVE_POWER_LOSS_DISTRIBUTION_PARAM_NAME)).ifPresent(this::setContingencyActivePowerLossDistribution);
        return this;
    }
}

