/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa;

import com.google.auto.service.AutoService;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.contingency.ContingenciesProvider;
import com.powsybl.iidm.network.Network;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.math.matrix.SparseMatrixFactory;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.graph.EvenShiloachGraphDecrementalConnectivityFactory;
import com.powsybl.openloadflow.graph.GraphConnectivityFactory;
import com.powsybl.openloadflow.graph.NaiveGraphConnectivityFactory;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.sa.AbstractSecurityAnalysis;
import com.powsybl.openloadflow.sa.AcSecurityAnalysis;
import com.powsybl.openloadflow.sa.DcSecurityAnalysis;
import com.powsybl.openloadflow.sa.OpenSecurityAnalysisParameterJsonSerializer;
import com.powsybl.openloadflow.sa.OpenSecurityAnalysisParameters;
import com.powsybl.openloadflow.sa.WoodburyDcSecurityAnalysis;
import com.powsybl.openloadflow.util.PowsyblOpenLoadFlowVersion;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.SecurityAnalysisProvider;
import com.powsybl.security.SecurityAnalysisReport;
import com.powsybl.security.SecurityAnalysisRunParameters;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SecurityAnalysisProvider.class})
public class OpenSecurityAnalysisProvider
implements SecurityAnalysisProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSecurityAnalysisProvider.class);
    private final MatrixFactory matrixFactory;
    private final GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory;

    public OpenSecurityAnalysisProvider(MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory) {
        this.matrixFactory = matrixFactory;
        this.connectivityFactory = connectivityFactory;
    }

    public OpenSecurityAnalysisProvider() {
        this((MatrixFactory)new SparseMatrixFactory(), new EvenShiloachGraphDecrementalConnectivityFactory<LfBus, LfBranch>());
    }

    public CompletableFuture<SecurityAnalysisReport> run(Network network, String workingVariantId, ContingenciesProvider contingenciesProvider, SecurityAnalysisRunParameters runParameters) {
        GraphConnectivityFactory<LfBus, LfBranch> selectedConnectivityFactory;
        Objects.requireNonNull(network);
        Objects.requireNonNull(workingVariantId);
        Objects.requireNonNull(contingenciesProvider);
        Objects.requireNonNull(runParameters);
        LoadFlowParameters loadFlowParameters = runParameters.getSecurityAnalysisParameters().getLoadFlowParameters();
        OpenLoadFlowParameters loadFlowParametersExt = OpenLoadFlowParameters.get(loadFlowParameters);
        if (runParameters.getOperatorStrategies().isEmpty() && !loadFlowParametersExt.isSimulateAutomationSystems()) {
            selectedConnectivityFactory = this.connectivityFactory;
        } else {
            LOGGER.warn("Naive (and slow!!!) connectivity algorithm has been selected because at least one operator strategy is configured");
            selectedConnectivityFactory = new NaiveGraphConnectivityFactory<LfBus, LfBranch>(LfElement::getNum);
        }
        AbstractSecurityAnalysis securityAnalysis = loadFlowParameters.isDc() ? (OpenSecurityAnalysisParameters.getOrDefault(runParameters.getSecurityAnalysisParameters()).isDcFastMode() ? new WoodburyDcSecurityAnalysis(network, this.matrixFactory, selectedConnectivityFactory, runParameters.getMonitors(), runParameters.getReportNode()) : new DcSecurityAnalysis(network, this.matrixFactory, selectedConnectivityFactory, runParameters.getMonitors(), runParameters.getReportNode())) : new AcSecurityAnalysis(network, this.matrixFactory, selectedConnectivityFactory, runParameters.getMonitors(), runParameters.getReportNode());
        return securityAnalysis.run(workingVariantId, runParameters.getSecurityAnalysisParameters(), contingenciesProvider, runParameters.getComputationManager(), runParameters.getOperatorStrategies(), runParameters.getActions(), runParameters.getLimitReductions());
    }

    public String getName() {
        return "OpenLoadFlow";
    }

    public String getVersion() {
        return new PowsyblOpenLoadFlowVersion().toString();
    }

    public Optional<String> getLoadFlowProviderName() {
        return Optional.of("OpenLoadFlow");
    }

    public Optional<ExtensionJsonSerializer> getSpecificParametersSerializer() {
        return Optional.of(new OpenSecurityAnalysisParameterJsonSerializer());
    }

    public Optional<Extension<SecurityAnalysisParameters>> loadSpecificParameters(PlatformConfig platformConfig) {
        return Optional.of(OpenSecurityAnalysisParameters.load(platformConfig));
    }

    public Optional<Extension<SecurityAnalysisParameters>> loadSpecificParameters(Map<String, String> properties) {
        return Optional.of(OpenSecurityAnalysisParameters.load(properties));
    }

    public List<String> getSpecificParametersNames() {
        return OpenSecurityAnalysisParameters.SPECIFIC_PARAMETERS_NAMES;
    }

    public void updateSpecificParameters(Extension<SecurityAnalysisParameters> extension, Map<String, String> properties) {
        ((OpenSecurityAnalysisParameters)extension).update(properties);
    }
}

