/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa;

import com.powsybl.contingency.Contingency;
import com.powsybl.contingency.ContingencyElement;
import com.powsybl.contingency.ContingencyElementType;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.sa.AbstractNetworkResult;
import com.powsybl.openloadflow.sa.PreContingencyNetworkResult;
import com.powsybl.security.monitor.StateMonitor;
import com.powsybl.security.monitor.StateMonitorIndex;
import com.powsybl.security.results.BranchResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PostContingencyNetworkResult
extends AbstractNetworkResult {
    private final List<BranchResult> branchResults = new ArrayList<BranchResult>();
    private final PreContingencyNetworkResult preContingencyMonitorInfos;
    private final Contingency contingency;

    public PostContingencyNetworkResult(LfNetwork network, StateMonitorIndex monitorIndex, boolean createResultExtension, PreContingencyNetworkResult preContingencyMonitorInfos, Contingency contingency) {
        super(network, monitorIndex, createResultExtension);
        this.preContingencyMonitorInfos = Objects.requireNonNull(preContingencyMonitorInfos);
        this.contingency = Objects.requireNonNull(contingency);
    }

    @Override
    protected void clear() {
        super.clear();
        this.branchResults.clear();
    }

    public void addResults(StateMonitor monitor, Predicate<LfBranch> isBranchDisabled) {
        this.addResults(monitor, branch -> {
            BranchResult preContingencyBranchOfContingencyResult;
            ContingencyElement contingencyElement;
            BranchResult preContingencyBranchResult = this.preContingencyMonitorInfos.getBranchResult(branch.getId());
            double preContingencyBranchP1 = preContingencyBranchResult != null ? preContingencyBranchResult.getP1() : Double.NaN;
            double preContingencyBranchOfContingencyP1 = Double.NaN;
            if (this.contingency.getElements().size() == 1 && ((contingencyElement = (ContingencyElement)this.contingency.getElements().get(0)).getType() == ContingencyElementType.BRANCH || contingencyElement.getType() == ContingencyElementType.LINE || contingencyElement.getType() == ContingencyElementType.DANGLING_LINE || contingencyElement.getType() == ContingencyElementType.TWO_WINDINGS_TRANSFORMER) && (preContingencyBranchOfContingencyResult = this.preContingencyMonitorInfos.getBranchResult(contingencyElement.getId())) != null) {
                preContingencyBranchOfContingencyP1 = preContingencyBranchOfContingencyResult.getP1();
            }
            this.branchResults.addAll(branch.createBranchResult(preContingencyBranchP1, preContingencyBranchOfContingencyP1, this.createResultExtension));
        }, isBranchDisabled);
    }

    @Override
    public void update() {
        this.update(LfElement::isDisabled);
    }

    public void update(Predicate<LfBranch> isBranchDisabled) {
        this.clear();
        StateMonitor stateMonitor = (StateMonitor)this.monitorIndex.getSpecificStateMonitors().get(this.contingency.getId());
        if (stateMonitor != null) {
            this.addResults(stateMonitor, isBranchDisabled);
        } else {
            this.addResults(this.monitorIndex.getAllStateMonitor(), isBranchDisabled);
        }
    }

    @Override
    public List<BranchResult> getBranchResults() {
        return this.branchResults;
    }
}

