/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa;

import com.google.common.base.Stopwatch;
import com.powsybl.action.Action;
import com.powsybl.action.PhaseTapChangerTapPositionAction;
import com.powsybl.action.SwitchAction;
import com.powsybl.action.TerminalsConnectionAction;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.contingency.Contingency;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.extensions.HvdcAngleDroopActivePowerControl;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.dc.DcLoadFlowContext;
import com.powsybl.openloadflow.dc.DcLoadFlowEngine;
import com.powsybl.openloadflow.dc.DcLoadFlowParameters;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.dc.fastdc.AbstractComputedElement;
import com.powsybl.openloadflow.dc.fastdc.ComputedContingencyElement;
import com.powsybl.openloadflow.dc.fastdc.ComputedSwitchBranchElement;
import com.powsybl.openloadflow.dc.fastdc.ComputedTapPositionChangeElement;
import com.powsybl.openloadflow.dc.fastdc.ConnectivityBreakAnalysis;
import com.powsybl.openloadflow.dc.fastdc.WoodburyEngine;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.graph.GraphConnectivityFactory;
import com.powsybl.openloadflow.network.BusDcState;
import com.powsybl.openloadflow.network.DisabledNetwork;
import com.powsybl.openloadflow.network.ElementState;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfContingency;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.NetworkState;
import com.powsybl.openloadflow.network.action.AbstractLfBranchAction;
import com.powsybl.openloadflow.network.action.AbstractLfTapChangerAction;
import com.powsybl.openloadflow.network.action.LfAction;
import com.powsybl.openloadflow.network.action.LfActionUtils;
import com.powsybl.openloadflow.network.impl.PropagatedContingency;
import com.powsybl.openloadflow.sa.ContingencyActivePowerLossDistribution;
import com.powsybl.openloadflow.sa.DcSecurityAnalysis;
import com.powsybl.openloadflow.sa.LimitViolationManager;
import com.powsybl.openloadflow.sa.OpenSecurityAnalysisParameters;
import com.powsybl.openloadflow.sa.PostContingencyNetworkResult;
import com.powsybl.openloadflow.sa.PreContingencyNetworkResult;
import com.powsybl.openloadflow.util.Reports;
import com.powsybl.security.LimitViolationsResult;
import com.powsybl.security.PostContingencyComputationStatus;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.limitreduction.LimitReduction;
import com.powsybl.security.monitor.StateMonitor;
import com.powsybl.security.results.ConnectivityResult;
import com.powsybl.security.results.NetworkResult;
import com.powsybl.security.results.OperatorStrategyResult;
import com.powsybl.security.results.PostContingencyResult;
import com.powsybl.security.results.PreContingencyResult;
import com.powsybl.security.strategy.OperatorStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.event.Level;

public class WoodburyDcSecurityAnalysis
extends DcSecurityAnalysis {
    protected WoodburyDcSecurityAnalysis(Network network, MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory, List<StateMonitor> stateMonitors, ReportNode reportNode) {
        super(network, matrixFactory, connectivityFactory, stateMonitors, reportNode);
        this.logLevel = Level.DEBUG;
    }

    @Override
    protected ReportNode createSaRootReportNode() {
        return Reports.createWoodburyDcSecurityAnalysis(this.reportNode, this.network.getId());
    }

    @Override
    protected DcLoadFlowParameters createParameters(LoadFlowParameters lfParameters, OpenLoadFlowParameters lfParametersExt, boolean breakers, boolean areas) {
        boolean hasDroopControl;
        DcLoadFlowParameters dcParameters = super.createParameters(lfParameters, lfParametersExt, breakers, areas);
        LfNetworkParameters lfNetworkParameters = dcParameters.getNetworkParameters();
        boolean bl = hasDroopControl = lfNetworkParameters.isHvdcAcEmulation() && this.network.getHvdcLineStream().anyMatch(l -> {
            HvdcAngleDroopActivePowerControl droopControl = (HvdcAngleDroopActivePowerControl)l.getExtension(HvdcAngleDroopActivePowerControl.class);
            return droopControl != null && droopControl.isEnabled();
        });
        if (hasDroopControl) {
            Reports.reportAcEmulationDisabledInWoodburyDcSecurityAnalysis(this.reportNode);
        }
        lfNetworkParameters.setMinImpedance(true).setHvdcAcEmulation(false);
        dcParameters.getEquationSystemCreationParameters().setForcePhaseControlOffAndAddAngle1Var(true);
        return dcParameters;
    }

    private double[] calculatePostContingencyStates(DcLoadFlowContext loadFlowContext, DenseMatrix contingenciesStates, double[] flowStates, ConnectivityBreakAnalysis.ConnectivityAnalysisResult connectivityAnalysisResult, Map<String, ComputedContingencyElement> contingencyElementByBranch, ReportNode reportNode) {
        return this.calculatePostContingencyAndOperatorStrategyStates(loadFlowContext, contingenciesStates, flowStates, connectivityAnalysisResult, contingencyElementByBranch, Collections.emptyMap(), DenseMatrix.EMPTY, reportNode);
    }

    private double[] calculatePostContingencyAndOperatorStrategyStates(DcLoadFlowContext loadFlowContext, DenseMatrix contingenciesStates, double[] flowStates, ConnectivityBreakAnalysis.ConnectivityAnalysisResult connectivityAnalysisResult, Map<String, ComputedContingencyElement> contingencyElementByBranch, Map<LfAction, AbstractComputedElement> actionElementByLfAction, DenseMatrix actionsStates, ReportNode reportNode) {
        PropagatedContingency contingency = connectivityAnalysisResult.getPropagatedContingency();
        Set<LfBus> disabledBuses = connectivityAnalysisResult.getDisabledBuses();
        Set<LfBranch> partialDisabledBranches = connectivityAnalysisResult.getPartialDisabledBranches();
        Set<String> elementsToReconnect = connectivityAnalysisResult.getElementsToReconnect();
        List<LfAction> operatorStrategyLfActions = connectivityAnalysisResult.getLfActions();
        connectivityAnalysisResult.getHvdcsWithoutPower().forEach(hvdcWithoutPower -> {
            contingency.getGeneratorIdsToLose().add(hvdcWithoutPower.getConverterStation1().getId());
            contingency.getGeneratorIdsToLose().add(hvdcWithoutPower.getConverterStation2().getId());
        });
        List<ComputedContingencyElement> contingencyElements = contingency.getBranchIdsToOpen().keySet().stream().filter(element -> !elementsToReconnect.contains(element)).map(contingencyElementByBranch::get).collect(Collectors.toList());
        List<AbstractComputedElement> actionElements = operatorStrategyLfActions.stream().map(actionElementByLfAction::get).filter(actionElement -> !elementsToReconnect.contains(actionElement.getLfBranch().getId())).collect(Collectors.toList());
        LfNetwork lfNetwork = loadFlowContext.getNetwork();
        Set<LfBranch> disabledBranches = contingency.getBranchIdsToOpen().keySet().stream().map(lfNetwork::getBranchById).collect(Collectors.toSet());
        disabledBranches.addAll(partialDisabledBranches);
        DisabledNetwork disabledNetwork = new DisabledNetwork(disabledBuses, disabledBranches);
        WoodburyEngine engine = new WoodburyEngine(((DcLoadFlowParameters)loadFlowContext.getParameters()).getEquationSystemCreationParameters(), contingencyElements, contingenciesStates, actionElements, actionsStates);
        double[] newFlowStates = flowStates;
        if (contingency.getGeneratorIdsToLose().isEmpty() && contingency.getLoadIdsToLose().isEmpty()) {
            Set lostPhaseControllers = contingency.getBranchIdsToOpen().keySet().stream().filter(element -> !elementsToReconnect.contains(element)).map(contingencyElementByBranch::get).map(AbstractComputedElement::getLfBranch).filter(LfBranch::hasPhaseControllerCapability).collect(Collectors.toSet());
            if (!(disabledBuses.isEmpty() && lostPhaseControllers.isEmpty() && operatorStrategyLfActions.isEmpty())) {
                newFlowStates = WoodburyEngine.runDcLoadFlowWithModifiedTargetVector(loadFlowContext, disabledNetwork, reportNode, operatorStrategyLfActions);
            }
            engine.toPostContingencyAndOperatorStrategyStates(newFlowStates);
        } else {
            DcLoadFlowParameters lfParameters = (DcLoadFlowParameters)loadFlowContext.getParameters();
            List<BusDcState> busStates = ElementState.save(lfNetwork.getBuses(), BusDcState::save);
            connectivityAnalysisResult.toLfContingency().ifPresent(lfContingency -> lfContingency.processLostPowerChanges(lfParameters.getBalanceType(), false));
            newFlowStates = WoodburyEngine.runDcLoadFlowWithModifiedTargetVector(loadFlowContext, disabledNetwork, reportNode, operatorStrategyLfActions);
            engine.toPostContingencyAndOperatorStrategyStates(newFlowStates);
            ElementState.restore(busStates);
        }
        return newFlowStates;
    }

    private void filterActions(List<Action> actions, LfNetwork lfNetwork) {
        actions.stream().filter(TerminalsConnectionAction.class::isInstance).map(TerminalsConnectionAction.class::cast).filter(action -> !action.isOpen() && (lfNetwork.getBranchById(action.getElementId()).getBranchType() == LfBranch.BranchType.TRANSFO_2 || lfNetwork.getBranchById(action.getElementId()).getBranchType() == LfBranch.BranchType.TRANSFO_3_LEG_1 || lfNetwork.getBranchById(action.getElementId()).getBranchType() == LfBranch.BranchType.TRANSFO_3_LEG_2 || lfNetwork.getBranchById(action.getElementId()).getBranchType() == LfBranch.BranchType.TRANSFO_3_LEG_3)).findAny().ifPresent(e -> {
            throw new IllegalStateException("For now, TerminalsConnectionAction enabling a transformer is not allowed in WoodburyDcSecurityAnalysis");
        });
        actions.stream().filter(action -> !(action instanceof PhaseTapChangerTapPositionAction) && !(action instanceof TerminalsConnectionAction) && !(action instanceof SwitchAction)).findAny().ifPresent(e -> {
            throw new IllegalStateException("For now, only PhaseTapChangerTapPositionAction, TerminalsConnectionAction and SwitchAction are allowed in fast DC Security Analysis");
        });
    }

    private PostContingencyResult computePostContingencyResultFromPostContingencyStates(WoodburyContext woodburyContext, Contingency contingency, LfContingency lfContingency, LimitViolationManager preContingencyLimitViolationManager, PreContingencyNetworkResult preContingencyNetworkResult, double[] postContingencyStates, Predicate<LfBranch> isBranchDisabledDueToContingency) {
        DcLoadFlowContext loadFlowContext = woodburyContext.dcLoadFlowContext;
        LfNetwork lfNetwork = loadFlowContext.getNetwork();
        loadFlowContext.getEquationSystem().getStateVector().set(postContingencyStates);
        DcLoadFlowEngine.updateNetwork(lfNetwork, loadFlowContext.getEquationSystem(), postContingencyStates);
        lfContingency.apply(((DcLoadFlowParameters)loadFlowContext.getParameters()).getBalanceType());
        PostContingencyNetworkResult postContingencyNetworkResult = new PostContingencyNetworkResult(lfNetwork, this.monitorIndex, woodburyContext.createResultExtension, preContingencyNetworkResult, contingency);
        postContingencyNetworkResult.update(isBranchDisabledDueToContingency);
        LimitViolationManager postContingencyLimitViolationManager = new LimitViolationManager(preContingencyLimitViolationManager, woodburyContext.limitReductions, woodburyContext.violationsParameters);
        postContingencyLimitViolationManager.detectViolations(lfNetwork, isBranchDisabledDueToContingency);
        ConnectivityResult connectivityResult = new ConnectivityResult(lfContingency.getCreatedSynchronousComponentsCount(), 0, lfContingency.getDisconnectedLoadActivePower() * 100.0, lfContingency.getDisconnectedGenerationActivePower() * 100.0, lfContingency.getDisconnectedElementIds());
        return new PostContingencyResult(contingency, PostContingencyComputationStatus.CONVERGED, new LimitViolationsResult(postContingencyLimitViolationManager.getLimitViolations()), postContingencyNetworkResult.getBranchResults(), postContingencyNetworkResult.getBusResults(), postContingencyNetworkResult.getThreeWindingsTransformerResults(), connectivityResult);
    }

    private OperatorStrategyResult computeOperatorStrategyResultFromPostContingencyAndOperatorStrategyStates(WoodburyContext woodburyContext, LfContingency lfContingency, OperatorStrategy operatorStrategy, List<LfAction> operatorStrategyLfActions, LimitViolationManager preContingencyLimitViolationManager, double[] postContingencyAndOperatorStrategyStates, Predicate<LfBranch> isBranchDisabledDueToContingency) {
        DcLoadFlowContext loadFlowContext = woodburyContext.dcLoadFlowContext;
        LfNetwork lfNetwork = loadFlowContext.getNetwork();
        loadFlowContext.getEquationSystem().getStateVector().set(postContingencyAndOperatorStrategyStates);
        DcLoadFlowEngine.updateNetwork(lfNetwork, loadFlowContext.getEquationSystem(), postContingencyAndOperatorStrategyStates);
        lfContingency.apply(((DcLoadFlowParameters)loadFlowContext.getParameters()).getBalanceType());
        LfActionUtils.applyListOfActions(operatorStrategyLfActions, lfNetwork, lfContingency, ((DcLoadFlowParameters)loadFlowContext.getParameters()).getNetworkParameters());
        PreContingencyNetworkResult postActionsNetworkResult = new PreContingencyNetworkResult(lfNetwork, this.monitorIndex, woodburyContext.createResultExtension);
        postActionsNetworkResult.update(isBranchDisabledDueToContingency);
        LimitViolationManager postActionsViolationManager = new LimitViolationManager(preContingencyLimitViolationManager, woodburyContext.limitReductions, woodburyContext.violationsParameters);
        postActionsViolationManager.detectViolations(lfNetwork, isBranchDisabledDueToContingency);
        return new OperatorStrategyResult(operatorStrategy, PostContingencyComputationStatus.CONVERGED, new LimitViolationsResult(postActionsViolationManager.getLimitViolations()), new NetworkResult(postActionsNetworkResult.getBranchResults(), postActionsNetworkResult.getBusResults(), postActionsNetworkResult.getThreeWindingsTransformerResults()));
    }

    private void addPostContingencyAndOperatorStrategyResults(WoodburyContext woodburyContext, ConnectivityBreakAnalysis.ConnectivityAnalysisResult connectivityAnalysisResult, ToFastDcResults toFastDcResults, Runnable restorePreContingencyStates, SecurityAnalysisSimulationResults securityAnalysisSimulationResults) {
        connectivityAnalysisResult.toLfContingency().ifPresent(lfContingency -> {
            DcLoadFlowContext dcLoadFlowContext = woodburyContext.dcLoadFlowContext;
            LfNetwork lfNetwork = dcLoadFlowContext.getNetwork();
            Contingency contingency = connectivityAnalysisResult.getPropagatedContingency().getContingency();
            ReportNode postContSimReportNode = Reports.createPostContingencySimulation(lfNetwork.getReportNode(), contingency.getId());
            lfNetwork.setReportNode(postContSimReportNode);
            Predicate<LfBranch> isBranchDisabled = branch -> lfContingency.getDisabledNetwork().getBranchesStatus().containsKey(branch);
            this.logPostContingencyStart(lfNetwork, (LfContingency)lfContingency);
            Stopwatch stopwatch = Stopwatch.createStarted();
            double[] postContingencyStates = toFastDcResults.toPostContingencyStates.apply(connectivityAnalysisResult);
            PostContingencyResult postContingencyResult = this.computePostContingencyResultFromPostContingencyStates(woodburyContext, contingency, (LfContingency)lfContingency, securityAnalysisSimulationResults.preContingencyLimitViolationManager, securityAnalysisSimulationResults.preContingencyNetworkResult, postContingencyStates, isBranchDisabled);
            stopwatch.stop();
            this.logPostContingencyEnd(lfNetwork, (LfContingency)lfContingency, stopwatch);
            securityAnalysisSimulationResults.postContingencyResults.add(postContingencyResult);
            restorePreContingencyStates.run();
            List<OperatorStrategy> operatorStrategiesForThisContingency = woodburyContext.operatorStrategiesByContingencyId.get(contingency.getId());
            if (operatorStrategiesForThisContingency != null) {
                for (OperatorStrategy operatorStrategy : operatorStrategiesForThisContingency) {
                    ReportNode osSimReportNode = Reports.createOperatorStrategySimulation(postContSimReportNode, operatorStrategy.getId());
                    lfNetwork.setReportNode(osSimReportNode);
                    List<String> actionIds = this.checkCondition(operatorStrategy, postContingencyResult.getLimitViolationsResult());
                    List<LfAction> operatorStrategyLfActions = actionIds.stream().map(woodburyContext.lfActionById::get).filter(Objects::nonNull).toList();
                    this.logActionStart(lfNetwork, operatorStrategy);
                    stopwatch = Stopwatch.createStarted();
                    ConnectivityBreakAnalysis.ConnectivityAnalysisResult postContingencyAndOperatorStrategyConnectivityAnalysisResult = toFastDcResults.toPostContingencyAndOperatorStrategyConnectivityAnalysisResult.apply(connectivityAnalysisResult, operatorStrategyLfActions);
                    Predicate<LfBranch> isBranchDisabledDueToContingencyAndOperatorStrategy = branch -> {
                        Set disabledBranches = postContingencyAndOperatorStrategyConnectivityAnalysisResult.getPropagatedContingency().getBranchIdsToOpen().keySet().stream().map(lfNetwork::getBranchById).collect(Collectors.toSet());
                        disabledBranches.addAll(postContingencyAndOperatorStrategyConnectivityAnalysisResult.getPartialDisabledBranches());
                        return disabledBranches.contains(branch);
                    };
                    double[] postContingencyAndOperatorStrategyStates = toFastDcResults.toPostContingencyAndOperatorStrategyStates.apply(postContingencyAndOperatorStrategyConnectivityAnalysisResult);
                    OperatorStrategyResult operatorStrategyResult = this.computeOperatorStrategyResultFromPostContingencyAndOperatorStrategyStates(woodburyContext, (LfContingency)lfContingency, operatorStrategy, operatorStrategyLfActions, securityAnalysisSimulationResults.preContingencyLimitViolationManager, postContingencyAndOperatorStrategyStates, isBranchDisabledDueToContingencyAndOperatorStrategy);
                    securityAnalysisSimulationResults.operatorStrategyResults.add(operatorStrategyResult);
                    stopwatch.stop();
                    this.logActionEnd(lfNetwork, operatorStrategy, stopwatch);
                    restorePreContingencyStates.run();
                }
            }
        });
    }

    private static Map<LfAction, AbstractComputedElement> createActionElementsIndexByLfAction(Map<String, LfAction> lfActionById, EquationSystem<DcVariableType, DcEquationType> equationSystem) {
        Map computedElements = lfActionById.values().stream().map(lfAction -> {
            AbstractLfBranchAction abstractLfBranchAction;
            AbstractLfBranchAction abstractLfBranchAction2;
            AbstractComputedElement element;
            if (lfAction instanceof AbstractLfTapChangerAction) {
                AbstractLfTapChangerAction abstractLfTapChangerAction = (AbstractLfTapChangerAction)lfAction;
                element = new ComputedTapPositionChangeElement(abstractLfTapChangerAction.getChange(), equationSystem);
            } else if (lfAction instanceof AbstractLfBranchAction && (abstractLfBranchAction2 = (AbstractLfBranchAction)lfAction).getEnabledBranch() != null) {
                element = new ComputedSwitchBranchElement(abstractLfBranchAction2.getEnabledBranch(), true, equationSystem);
            } else if (lfAction instanceof AbstractLfBranchAction && (abstractLfBranchAction = (AbstractLfBranchAction)lfAction).getDisabledBranch() != null) {
                element = new ComputedSwitchBranchElement(abstractLfBranchAction.getDisabledBranch(), false, equationSystem);
            } else {
                throw new IllegalStateException("Only tap position change and branch enabling/disabling are supported in WoodburyDcSecurityAnalysis");
            }
            return Map.entry(lfAction, element);
        }).filter(e -> ((AbstractComputedElement)e.getValue()).getLfBranchEquation() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, replacement) -> existing, LinkedHashMap::new));
        AbstractComputedElement.setComputedElementIndexes(computedElements.values());
        return computedElements;
    }

    @Override
    protected SecurityAnalysisResult runSimulations(LfNetwork lfNetwork, List<PropagatedContingency> propagatedContingencies, DcLoadFlowParameters dcParameters, SecurityAnalysisParameters securityAnalysisParameters, List<OperatorStrategy> operatorStrategies, List<Action> actions, List<LimitReduction> limitReductions, ContingencyActivePowerLossDistribution contingencyActivePowerLossDistribution) {
        this.filterActions(actions, lfNetwork);
        Map<String, Action> actionsById = WoodburyDcSecurityAnalysis.indexActionsById(actions);
        HashSet<Action> neededActions = new HashSet<Action>(actionsById.size());
        Map<String, List<OperatorStrategy>> operatorStrategiesByContingencyId = WoodburyDcSecurityAnalysis.indexOperatorStrategiesByContingencyId(propagatedContingencies, operatorStrategies, actionsById, neededActions, true);
        Map<String, LfAction> lfActionById = WoodburyDcSecurityAnalysis.createLfActions(lfNetwork, neededActions, this.network, dcParameters.getNetworkParameters());
        OpenSecurityAnalysisParameters openSecurityAnalysisParameters = OpenSecurityAnalysisParameters.getOrDefault(securityAnalysisParameters);
        boolean createResultExtension = openSecurityAnalysisParameters.isCreateResultExtension();
        try (DcLoadFlowContext context = new DcLoadFlowContext(lfNetwork, dcParameters, false);){
            ReportNode networkReportNode = lfNetwork.getReportNode();
            ReportNode preContSimReportNode = Reports.createPreContingencySimulation(networkReportNode);
            lfNetwork.setReportNode(preContSimReportNode);
            PropagatedContingency.cleanContingencies(lfNetwork, propagatedContingencies);
            double[] preContingencyStates = WoodburyEngine.runDcLoadFlowWithModifiedTargetVector(context, new DisabledNetwork(), this.reportNode);
            double[] workingContingencyStates = new double[preContingencyStates.length];
            System.arraycopy(preContingencyStates, 0, workingContingencyStates, 0, preContingencyStates.length);
            context.getEquationSystem().getStateVector().set(preContingencyStates);
            DcLoadFlowEngine.updateNetwork(lfNetwork, context.getEquationSystem(), preContingencyStates);
            if (((DcLoadFlowParameters)context.getParameters()).isSetVToNan()) {
                for (LfBus bus : lfNetwork.getBuses()) {
                    bus.setV(Double.NaN);
                }
            }
            PreContingencyNetworkResult preContingencyNetworkResult = new PreContingencyNetworkResult(lfNetwork, this.monitorIndex, createResultExtension);
            preContingencyNetworkResult.update();
            LimitViolationManager preContingencyLimitViolationManager = new LimitViolationManager(limitReductions);
            preContingencyLimitViolationManager.detectViolations(lfNetwork);
            WoodburyContext woodburyContext = new WoodburyContext(context, operatorStrategiesByContingencyId, lfActionById, createResultExtension, securityAnalysisParameters.getIncreasedViolationsParameters(), limitReductions);
            ConnectivityBreakAnalysis.ConnectivityBreakAnalysisResults connectivityBreakAnalysisResults = ConnectivityBreakAnalysis.run(context, propagatedContingencies);
            Map<LfAction, AbstractComputedElement> actionElementsIndexByLfAction = WoodburyDcSecurityAnalysis.createActionElementsIndexByLfAction(lfActionById, context.getEquationSystem());
            DenseMatrix actionsStates = AbstractComputedElement.calculateElementsStates(context, actionElementsIndexByLfAction.values());
            NetworkState networkState = NetworkState.save(lfNetwork);
            ArrayList<PostContingencyResult> postContingencyResults = new ArrayList<PostContingencyResult>();
            ArrayList<OperatorStrategyResult> operatorStrategyResults = new ArrayList<OperatorStrategyResult>();
            SecurityAnalysisSimulationResults securityAnalysisSimulationResults = new SecurityAnalysisSimulationResults(preContingencyNetworkResult, preContingencyLimitViolationManager, postContingencyResults, operatorStrategyResults);
            Function<ConnectivityBreakAnalysis.ConnectivityAnalysisResult, double[]> toPostContingencyStates = postContingencyConnectivityAnalysisResult -> this.calculatePostContingencyStates(context, connectivityBreakAnalysisResults.contingenciesStates(), workingContingencyStates, (ConnectivityBreakAnalysis.ConnectivityAnalysisResult)postContingencyConnectivityAnalysisResult, connectivityBreakAnalysisResults.contingencyElementByBranch(), this.reportNode);
            BiFunction<ConnectivityBreakAnalysis.ConnectivityAnalysisResult, List<LfAction>, ConnectivityBreakAnalysis.ConnectivityAnalysisResult> toPostContingencyAndOperatorStrategyConnectivityAnalysisResult = (postContingencyConnectivityAnalysisResult, operatorStrategyLfActions) -> {
                ConnectivityBreakAnalysis.ConnectivityAnalysisResult postOperatorStrategyConnectivityAnalysisResult = ConnectivityBreakAnalysis.processPostContingencyAndPostOperatorStrategyConnectivityAnalysisResult(context, postContingencyConnectivityAnalysisResult, connectivityBreakAnalysisResults.contingencyElementByBranch(), connectivityBreakAnalysisResults.contingenciesStates(), operatorStrategyLfActions, actionElementsIndexByLfAction, actionsStates);
                if (postOperatorStrategyConnectivityAnalysisResult == null) {
                    postOperatorStrategyConnectivityAnalysisResult = new ConnectivityBreakAnalysis.ConnectivityAnalysisResult(postContingencyConnectivityAnalysisResult.getPropagatedContingency(), (List<LfAction>)operatorStrategyLfActions, lfNetwork);
                }
                return postOperatorStrategyConnectivityAnalysisResult;
            };
            Function<ConnectivityBreakAnalysis.ConnectivityAnalysisResult, double[]> toPostContingencyAndOperatorStrategyStates = postContingencyAndOperatorStrategyConnectivityAnalysisResult -> this.calculatePostContingencyAndOperatorStrategyStates(context, connectivityBreakAnalysisResults.contingenciesStates(), workingContingencyStates, (ConnectivityBreakAnalysis.ConnectivityAnalysisResult)postContingencyAndOperatorStrategyConnectivityAnalysisResult, connectivityBreakAnalysisResults.contingencyElementByBranch(), actionElementsIndexByLfAction, actionsStates, this.reportNode);
            ToFastDcResults toFastDcResults = new ToFastDcResults(toPostContingencyStates, toPostContingencyAndOperatorStrategyConnectivityAnalysisResult, toPostContingencyAndOperatorStrategyStates);
            LOGGER.info("Processing post contingency results for contingencies with no connectivity break");
            connectivityBreakAnalysisResults.nonBreakingConnectivityContingencies().forEach(nonBreakingConnectivityContingency -> {
                ConnectivityBreakAnalysis.ConnectivityAnalysisResult connectivityAnalysisResult = new ConnectivityBreakAnalysis.ConnectivityAnalysisResult((PropagatedContingency)nonBreakingConnectivityContingency, lfNetwork);
                Runnable restorePreContingencyStates = () -> {
                    System.arraycopy(preContingencyStates, 0, workingContingencyStates, 0, preContingencyStates.length);
                    networkState.restore();
                };
                this.addPostContingencyAndOperatorStrategyResults(woodburyContext, connectivityAnalysisResult, toFastDcResults, restorePreContingencyStates, securityAnalysisSimulationResults);
            });
            LOGGER.info("Processing post contingency results for contingencies breaking connectivity");
            connectivityBreakAnalysisResults.connectivityAnalysisResults().forEach(connectivityAnalysisResult -> {
                Runnable restorePreContingencyStates = networkState::restore;
                this.addPostContingencyAndOperatorStrategyResults(woodburyContext, (ConnectivityBreakAnalysis.ConnectivityAnalysisResult)connectivityAnalysisResult, toFastDcResults, restorePreContingencyStates, securityAnalysisSimulationResults);
            });
            SecurityAnalysisResult securityAnalysisResult = new SecurityAnalysisResult(new PreContingencyResult(LoadFlowResult.ComponentResult.Status.CONVERGED, new LimitViolationsResult(preContingencyLimitViolationManager.getLimitViolations()), preContingencyNetworkResult.getBranchResults(), preContingencyNetworkResult.getBusResults(), preContingencyNetworkResult.getThreeWindingsTransformerResults()), postContingencyResults, operatorStrategyResults);
            return securityAnalysisResult;
        }
    }

    private record WoodburyContext(DcLoadFlowContext dcLoadFlowContext, Map<String, List<OperatorStrategy>> operatorStrategiesByContingencyId, Map<String, LfAction> lfActionById, boolean createResultExtension, SecurityAnalysisParameters.IncreasedViolationsParameters violationsParameters, List<LimitReduction> limitReductions) {
    }

    private record ToFastDcResults(Function<ConnectivityBreakAnalysis.ConnectivityAnalysisResult, double[]> toPostContingencyStates, BiFunction<ConnectivityBreakAnalysis.ConnectivityAnalysisResult, List<LfAction>, ConnectivityBreakAnalysis.ConnectivityAnalysisResult> toPostContingencyAndOperatorStrategyConnectivityAnalysisResult, Function<ConnectivityBreakAnalysis.ConnectivityAnalysisResult, double[]> toPostContingencyAndOperatorStrategyStates) {
    }

    private record SecurityAnalysisSimulationResults(PreContingencyNetworkResult preContingencyNetworkResult, LimitViolationManager preContingencyLimitViolationManager, List<PostContingencyResult> postContingencyResults, List<OperatorStrategyResult> operatorStrategyResults) {
    }
}

